/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import com.badlogic.gdx.utils.Clipboard;

public class AndroidClipboard
implements Clipboard {
    private android.text.ClipboardManager clipboard;
    private ClipboardManager honeycombClipboard;

    public AndroidClipboard(Context context) {
        if (Build.VERSION.SDK_INT < 11) {
            this.clipboard = (android.text.ClipboardManager)context.getSystemService("clipboard");
        } else {
            this.honeycombClipboard = (ClipboardManager)context.getSystemService("clipboard");
        }
    }

    public String getContents() {
        if (Build.VERSION.SDK_INT < 11) {
            if (this.clipboard.getText() == null) {
                return null;
            }
            return this.clipboard.getText().toString();
        }
        ClipData clip = this.honeycombClipboard.getPrimaryClip();
        if (clip == null) {
            return null;
        }
        CharSequence text = clip.getItemAt(0).getText();
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    public void setContents(String contents) {
        if (Build.VERSION.SDK_INT < 11) {
            this.clipboard.setText((CharSequence)contents);
        } else {
            ClipData data = ClipData.newPlainText((CharSequence)contents, (CharSequence)contents);
            this.honeycombClipboard.setPrimaryClip(data);
        }
    }
}

