/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import au.com.ds.ef.call.EventHandler;
import au.com.ds.ef.call.ExecutionErrorHandler;
import au.com.ds.ef.call.Handler;
import au.com.ds.ef.call.StateHandler;
import au.com.ds.ef.err.ExecutionError;
import java.util.HashMap;
import java.util.Map;

class HandlerCollection {
    private Map<HandlerType, Handler> handlers = new HashMap<HandlerType, Handler>();

    HandlerCollection() {
    }

    public void setHandler(EventType eventType, StateEnum state, EventEnum event, Handler handler) {
        this.handlers.put(new HandlerType(eventType, event, state), handler);
    }

    public <C extends StatefulContext> void callOnEventTriggered(EventEnum event, StateEnum stateFrom, StateEnum stateTo, C context) throws Exception {
        Handler h = this.handlers.get(new HandlerType(EventType.EVENT_TRIGGER, event, null));
        if (h != null) {
            ContextHandler contextHandler = (ContextHandler)h;
            contextHandler.call(context);
        }
        if ((h = this.handlers.get(new HandlerType(EventType.ANY_EVENT_TRIGGER, null, null))) != null) {
            EventHandler eventHandler = (EventHandler)h;
            eventHandler.call(event, stateFrom, stateTo, context);
        }
    }

    public <C extends StatefulContext> void callOnStateEntered(StateEnum state, C context) throws Exception {
        Handler h = this.handlers.get(new HandlerType(EventType.STATE_ENTER, null, state));
        if (h != null) {
            ContextHandler contextHandler = (ContextHandler)h;
            contextHandler.call(context);
        }
        if ((h = this.handlers.get(new HandlerType(EventType.ANY_STATE_ENTER, null, null))) != null) {
            StateHandler stateHandler = (StateHandler)h;
            stateHandler.call(state, context);
        }
    }

    public <C extends StatefulContext> void callOnStateLeaved(StateEnum state, C context) throws Exception {
        Handler h = this.handlers.get(new HandlerType(EventType.STATE_LEAVE, null, state));
        if (h != null) {
            ContextHandler contextHandler = (ContextHandler)h;
            contextHandler.call(context);
        }
        if ((h = this.handlers.get(new HandlerType(EventType.ANY_STATE_LEAVE, null, null))) != null) {
            StateHandler stateHandler = (StateHandler)h;
            stateHandler.call(state, context);
        }
    }

    public <C extends StatefulContext> void callOnFinalState(StateEnum state, C context) throws Exception {
        Handler h = this.handlers.get(new HandlerType(EventType.FINAL_STATE, null, null));
        if (h != null) {
            StateHandler contextHandler = (StateHandler)h;
            contextHandler.call(state, context);
        }
    }

    public void callOnError(ExecutionError error) {
        Handler h = this.handlers.get(new HandlerType(EventType.ERROR, null, null));
        if (h != null) {
            ExecutionErrorHandler errorHandler = (ExecutionErrorHandler)h;
            errorHandler.call(error, error.getContext());
        }
    }

    private static final class HandlerType {
        EventType eventType;
        EventEnum event;
        StateEnum state;

        private HandlerType(EventType eventType, EventEnum event, StateEnum state) {
            this.eventType = eventType;
            this.event = event;
            this.state = state;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerType that = (HandlerType)o;
            if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
                return false;
            }
            if (this.eventType != that.eventType) {
                return false;
            }
            return !(this.state != null ? !this.state.equals(that.state) : that.state != null);
        }

        public int hashCode() {
            int result = this.eventType.hashCode();
            result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            return result;
        }
    }

    public static enum EventType {
        EVENT_TRIGGER,
        ANY_EVENT_TRIGGER,
        STATE_ENTER,
        ANY_STATE_ENTER,
        STATE_LEAVE,
        ANY_STATE_LEAVE,
        FINAL_STATE,
        ERROR;

    }
}

