/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils;

import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import java.util.ArrayList;
import java.util.Random;

public class OnlineHostAddressPool {
    private static final int PORT = 8085;
    public static final int PORT2 = 80;
    private static final String MAJOR = "eval.hivoice.cn";
    private static final String SH = "43.231.149.195";
    private static final String BJ = "43.231.163.22";
    private static final String HTTP_BJ = "edubj.hivoice.cn";
    private static final String HTTP_SH = "edush.hivoice.cn";
    private static final int CN_PORT = 18085;
    public static final int CN_HTTP_PORT = 80;
    private static final String CN_MAIN = "cn-eval.hivoice.cn";
    private static final String CN_SH = "43.231.149.197";
    private static final String CN_BJ = "43.231.163.19";
    private static final String CN_HTTP_BJ = "cn-edubj.hivoice.cn";
    private static final String CN_HTTP_SH = "cn-edush.hivoice.cn";
    private static final String[] HTTP_IPS = new String[]{"edubj.hivoice.cn", "edush.hivoice.cn"};
    private static HostAndPort CUR;
    private static ArrayList<HostAndPort> HOSTS;
    private static final String[] CN_HTTP_IPS;
    private static HostAndPort CN_CUR;
    private static ArrayList<HostAndPort> CN_HOSTS;
    private static Random RND;

    private static void ResetPool() {
        HOSTS.add(new HostAndPort(SH, 8085));
        HOSTS.add(new HostAndPort(BJ, 8085));
        CUR = OnlineHostAddressPool.DEFAULT();
    }

    private static void ResetPoolCN() {
        CN_HOSTS.add(new HostAndPort(CN_SH, 18085));
        CN_HOSTS.add(new HostAndPort(CN_BJ, 18085));
        CN_CUR = OnlineHostAddressPool.DEFAULTCN();
    }

    public static HostAndPort DEFAULT() {
        return new HostAndPort(MAJOR, 8085);
    }

    public static HostAndPort DEFAULTCN() {
        return new HostAndPort(CN_MAIN, 18085);
    }

    public static String RANDOM_HTTP_IP(boolean isCN) {
        if (isCN) {
            return CN_HTTP_IPS[RND.nextInt(CN_HTTP_IPS.length)];
        }
        return HTTP_IPS[RND.nextInt(HTTP_IPS.length)];
    }

    public static String RANDOM_HTTP_IP(int next_ip, boolean isCN) {
        if (isCN) {
            return CN_HTTP_IPS[next_ip];
        }
        return HTTP_IPS[next_ip];
    }

    public static HostAndPort RANDOM_IP(String exclude, boolean isCN) {
        int idx;
        if (isCN) {
            int idx2;
            do {
                idx2 = RND.nextInt(CN_HOSTS.size());
                if (exclude == null) break;
                LogBuffer.ONE.d("BackupAddress", "try " + OnlineHostAddressPool.CN_HOSTS.get((int)idx2).host + " with " + exclude);
            } while (OnlineHostAddressPool.CN_HOSTS.get((int)idx2).host.trim().equals(exclude.trim()));
            return CN_HOSTS.get(idx2);
        }
        do {
            idx = RND.nextInt(HOSTS.size());
            if (exclude == null) break;
            LogBuffer.ONE.d("BackupAddress", "try " + OnlineHostAddressPool.HOSTS.get((int)idx).host + " with " + exclude);
        } while (OnlineHostAddressPool.HOSTS.get((int)idx).host.trim().equals(exclude.trim()));
        return HOSTS.get(idx);
    }

    public static HostAndPort CURRENT(boolean isCN) {
        if (isCN) {
            return CN_CUR;
        }
        return CUR;
    }

    public static int CURRENT_PORT(boolean isCN) {
        if (isCN) {
            return 18085;
        }
        return 80;
    }

    public static void RESET() {
        OnlineHostAddressPool.ResetPool();
    }

    public static boolean NEXT() {
        if (HOSTS.size() > 0) {
            int idx = RND.nextInt(HOSTS.size());
            CUR = HOSTS.get(idx);
            HOSTS.remove(idx);
            return true;
        }
        return false;
    }

    static {
        HOSTS = new ArrayList(6);
        CN_HTTP_IPS = new String[]{CN_HTTP_SH, CN_HTTP_BJ};
        CN_HOSTS = new ArrayList(3);
        OnlineHostAddressPool.ResetPool();
        OnlineHostAddressPool.ResetPoolCN();
        RND = new Random();
    }

    public static class HostAndPort {
        public String host;
        public int port;

        public HostAndPort(String h, int p) {
            this.host = h;
            this.port = p;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

