/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class SimpleReadWriteStream
extends InputStream {
    private LinkedList<byte[]> _pkgs = new LinkedList();
    boolean _writeEnd = false;

    public void endWrite() {
        this._writeEnd = true;
    }

    public boolean isEndWrite() {
        return this._writeEnd;
    }

    public void write(byte[] b, int off, int len) {
        if (off != 0 || len < b.length) {
            byte[] newb = new byte[len];
            System.arraycopy(b, off, newb, 0, len);
            b = newb;
        }
        this._pkgs.add(b);
    }

    public boolean hasData() {
        return this._pkgs.size() > 0;
    }

    @Override
    public int available() {
        int count = 0;
        for (byte[] pkg : this._pkgs) {
            count += pkg.length;
        }
        return count;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int rd = this.read(b, 0, 1);
        if (rd == 1) {
            return b[0];
        }
        return rd;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._pkgs.size() <= 0) {
            return -1;
        }
        int totalLen = 0;
        while (len > 0 && this._pkgs.size() > 0) {
            byte[] pkg = this._pkgs.get(0);
            if (pkg.length <= len) {
                System.arraycopy(pkg, 0, b, off, pkg.length);
                this._pkgs.remove(0);
                len -= pkg.length;
                off += pkg.length;
                totalLen += pkg.length;
                continue;
            }
            System.arraycopy(pkg, 0, b, off, len);
            byte[] newPkg = new byte[pkg.length - len];
            System.arraycopy(pkg, len, newPkg, 0, pkg.length - len);
            this._pkgs.set(0, newPkg);
            totalLen += len;
            len = 0;
        }
        return totalLen;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("not supported skip");
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("not supported reset");
    }

    @Override
    public void close() throws IOException {
        this._pkgs.clear();
    }
}

