/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils;

import android.util.Log;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SubmitLogDataUtils {
    private static final String TAG = "SubmitLogDataUtils";
    private static boolean isSubmit = false;

    private SubmitLogDataUtils() {
    }

    public static void submit(final File file, final String url) {
        if (isSubmit) {
            return;
        }
        isSubmit = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SubmitLogDataUtils.submitLogData(file, url);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void submitLogData(File file, String urlStr) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setChunkedStreamingMode(0x100000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", "UTF-8");
            conn.setConnectTimeout(30000);
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("fileName", file.getName());
            conn.connect();
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[2048];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            ((OutputStream)out).flush();
            int res = conn.getResponseCode();
            if (res == 200) {
                file.delete();
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Log.d((String)TAG, (String)line);
                }
            }
            ((OutputStream)out).close();
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.d((String)TAG, (String)e.getMessage());
        }
        finally {
            isSubmit = false;
        }
    }
}

