/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils.http;

import android.text.TextUtils;
import android.util.Log;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import com.unisound.edu.oraleval.sdk.sep15.utils.http.HttpBody;
import com.unisound.edu.oraleval.sdk.sep15.utils.http.SSLTrustManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class HttpConnection {
    static final String _URL_ = "https://_HOST_TBR_/eval/opus";
    private int _conTimeout;
    private int _readTimeout;
    private String _deviceid;
    private String _appkey;
    private HttpsURLConnection _conn;
    private HttpBody _body;
    private OutputStream _out;
    private String _bound;
    private String _text;
    private String _mode;
    private String _sessionId;
    private String _host;
    private OralEvalEnum oralEvalMode = OralEvalEnum.OnlineUS;
    public static final Integer PLAY_URL = 1;
    public static final Integer EVAL_RESULT = 2;
    public static final Integer ERROR = 3;
    public static final Integer CODE = 4;

    public static HttpConnection newInstance(int conTimeout, int readTimeout, String deviceid, String appkey, String text, String mode, String sessionid, String host, OralEvalEnum oralEvalMode) throws IOException {
        HttpConnection con = new HttpConnection();
        con._bound = sessionid.replaceAll("-", "");
        con._text = text;
        con._mode = mode;
        con._conTimeout = conTimeout;
        con._readTimeout = readTimeout;
        con._deviceid = deviceid;
        con._appkey = appkey;
        con._sessionId = sessionid;
        con._host = host;
        con.oralEvalMode = oralEvalMode;
        return con;
    }

    public void setVoice(InputStream s) {
        this._body = new HttpBody(this._bound, this._text, this._mode, s);
    }

    public void connect(String host) throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[1];
        SSLTrustManager tm = new SSLTrustManager();
        trustAllCerts[0] = tm;
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        if (this._host != null && !this._host.trim().equals("")) {
            String[] host_ip = this._host.split(":");
            Proxy proxy = host_ip.length == 2 ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host_ip[0], Integer.parseInt(host_ip[1]))) : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host_ip[0], 80));
            this._conn = (HttpsURLConnection)new URL(_URL_.replace("_HOST_TBR_", host)).openConnection(proxy);
        } else {
            this._conn = (HttpsURLConnection)new URL(_URL_.replace("_HOST_TBR_", host)).openConnection();
        }
        this._conn.setSSLSocketFactory(sc.getSocketFactory());
        this._conn.setHostnameVerifier(tm);
        if (this.oralEvalMode == OralEvalEnum.OnlineCH) {
            this._conn.setRequestProperty("X-EngineType", "oral.zh_CH");
        }
        this._conn.setConnectTimeout(this._conTimeout);
        this._conn.setReadTimeout(this._readTimeout);
        this._conn.setDoOutput(true);
        this._conn.setChunkedStreamingMode(1);
        this._conn.setRequestProperty("Connection", "close");
        this._conn.setRequestProperty("X-Attr", host);
        this._conn.setRequestProperty("session-id", this._sessionId);
        this._conn.setRequestProperty("device-id", this._deviceid);
        this._conn.setRequestProperty("appkey", this._appkey);
        this._conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this._bound);
    }

    public HttpBody getBody() {
        return this._body;
    }

    public int tick(int maxSize) throws IOException {
        return this.tick(new byte[maxSize]);
    }

    public int tick(byte[] buf) throws IOException {
        int rd = this._body.read(buf);
        if (rd > 0) {
            this._out.write(buf, 0, rd);
        }
        return rd;
    }

    public HashMap<Integer, Object> getResponse() throws IOException {
        InputStream is;
        String sessid;
        HashMap<Integer, Object> ret = new HashMap<Integer, Object>(4);
        ret.put(CODE, this._conn.getResponseCode());
        if (200 == this._conn.getResponseCode() && !TextUtils.isEmpty((CharSequence)(sessid = this._conn.getHeaderField("session-id")))) {
            ret.put(PLAY_URL, sessid);
        }
        try {
            is = this._conn.getInputStream();
            if (is == null && (is = this._conn.getErrorStream()) == null) {
                return ret;
            }
        }
        catch (Exception exp) {
            Log.d((String)"getResponse", (String)exp.getMessage());
            try {
                is = this._conn.getErrorStream();
                if (is == null) {
                    return ret;
                }
            }
            catch (Exception e) {
                Log.d((String)"getResponse", (String)e.getMessage());
                return ret;
            }
        }
        int rd = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        byte[] pack = new byte[1024];
        do {
            if ((rd = is.read(pack)) <= 0) continue;
            baos.write(pack, 0, rd);
        } while (rd > 0);
        String result = new String(baos.toByteArray());
        if (!result.startsWith("{")) {
            ret.put(ERROR, result);
        } else {
            ret.put(EVAL_RESULT, result);
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public void close() throws IOException {
        try {
            this._out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._body.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._conn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._out = null;
        this._body = null;
        this._conn = null;
    }

    public void connect() throws Exception {
        this._conn.connect();
    }

    public void send() throws Exception {
        this._out = this._conn.getOutputStream();
        int rd = 0;
        do {
            byte[] buf;
            if ((rd = this._body.read(buf = new byte[1024])) <= 0) continue;
            this._out.write(buf, 0, rd);
        } while (rd > 0);
    }

    public void flush() throws Exception {
        this._out.close();
    }
}

