/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import com.hpplay.common.asyncmanager.HttpMethod;
import com.hpplay.common.log.LeLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.json.JSONObject;

public class UploadFileRequest {
    private final String TAG = "UploadFileRequest";
    private String mURL;
    private String[] mLocalPath;
    private Map<String, String> mHeadParameter;
    private HttpMethod httpMethod;

    public UploadFileRequest(String string, String[] stringArray, Map<String, String> map, HttpMethod httpMethod) {
        this.mLocalPath = stringArray;
        this.mURL = string;
        this.mHeadParameter = map;
        this.httpMethod = httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile() {
        String string = "\r\n";
        String string2 = "--";
        String string3 = "*****";
        FilterOutputStream filterOutputStream = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        FileInputStream fileInputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = null;
        try {
            int n2;
            URL uRL = new URL(this.mURL);
            URLConnection uRLConnection = uRL.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            if (this.httpMethod != null) {
                httpURLConnection.setRequestMethod(this.httpMethod.toString());
            }
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + string3);
            if (this.mHeadParameter != null && this.mHeadParameter.size() > 0) {
                for (Map.Entry<String, String> object2 : this.mHeadParameter.entrySet()) {
                    httpURLConnection.setRequestProperty(object2.getKey(), object2.getValue());
                }
            }
            filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            for (n2 = 0; n2 < this.mLocalPath.length; ++n2) {
                String string5 = this.mLocalPath[n2];
                String string6 = string5.substring(string5.lastIndexOf("//") + 1);
                if (n2 > 0) {
                    ((DataOutputStream)filterOutputStream).writeBytes(string2 + string3 + string);
                    ((DataOutputStream)filterOutputStream).writeBytes("Content-Disposition: form-data; name=\"file" + n2 + "\";filename=\"" + string6 + "\"" + string);
                    ((DataOutputStream)filterOutputStream).writeBytes(string);
                }
                fileInputStream = new FileInputStream(string5);
                int n3 = 1024;
                byte[] byArray = new byte[n3];
                int n4 = -1;
                while ((n4 = fileInputStream.read(byArray)) != -1) {
                    ((DataOutputStream)filterOutputStream).write(byArray, 0, n4);
                }
                ((DataOutputStream)filterOutputStream).writeBytes(string);
                fileInputStream.close();
            }
            ((DataOutputStream)filterOutputStream).flush();
            n2 = httpURLConnection.getResponseCode();
            if (n2 >= 300) {
                LeLog.w("UploadFileRequest", "HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
                stringBuffer = new StringBuffer();
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("code", n2);
                jSONObject.put("msg", (Object)"");
                stringBuffer.append(jSONObject.toString());
            }
            if (n2 == 200) {
                inputStream = httpURLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                string4 = null;
                stringBuffer = new StringBuffer();
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string4);
                    stringBuffer.append("\n");
                }
            }
            LeLog.w("UploadFileRequest", "resultBuffer =" + stringBuffer.toString());
        }
        catch (Exception exception) {
            LeLog.w("UploadFileRequest", exception);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w("UploadFileRequest", exception);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    LeLog.w("UploadFileRequest", iOException);
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    LeLog.w("UploadFileRequest", iOException);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LeLog.w("UploadFileRequest", iOException);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    LeLog.w("UploadFileRequest", exception);
                }
            }
            return stringBuffer.toString();
        }
    }
}

