/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.NLProtocolBuiler;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.connection.IConnection;
import com.hpplay.component.protocol.encrypt.LelinkEncrypt;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;

public class LelinkV2Connection
extends IConnection {
    private static final String TAG = "LelinkV2Connection";
    private static final String FEATURE = "feature";
    private LelinkEncrypt mLelinkEncrypt = new LelinkEncrypt(this.sessionId);
    private int cseq = 0;
    private String mResult;

    public LelinkV2Connection(ParamsMap paramsMap) {
        super(paramsMap);
        this.mLelinkEncrypt.setSrpPassword(paramsMap.getScreenCode());
    }

    public String getFeature() {
        if (!TextUtils.isEmpty((CharSequence)this.mResult) && this.mResult.contains(FEATURE)) {
            try {
                NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(ProtocolUtils.removeHeader(this.mResult.getBytes()));
                if (nSDictionary.containsKey(FEATURE)) {
                    return nSDictionary.objectForKey(FEATURE).toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return "";
    }

    @Override
    boolean startConnect() {
        try {
            String string = String.valueOf(this.paramsMap.getParam("cjson", ""));
            String string2 = new NLProtocolBuiler().getNewConnectionCmd().setPlatfrom().setUserAgent("HappyCast5,0/500.0").setContentType("application/json").setNewLelinkClientId(this.getSessionId()).setNewClientUid(this.paramsMap.getCuid()).setNewSessionId(this.getSessionId()).setNewCSEQ(this.cseq + "").setContentLength(string.length() + "").getString(true);
            String string3 = string2 + string;
            if (this.mProtocolSender.connectServer() && this.mProtocolSender.checkEncrypt(this.mLelinkEncrypt, TAG)) {
                byte[] byArray = this.mProtocolSender.interactiveEncryptData(new byte[][]{this.mLelinkEncrypt.buildEncryptData(new byte[][]{string3.getBytes()})});
                if (byArray == null) {
                    return false;
                }
                byArray = this.mLelinkEncrypt.decryptData(byArray);
                this.mResult = new String(byArray);
                if (!TextUtils.isEmpty((CharSequence)this.mResult) && this.mResult.contains("200")) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            throw exception;
        }
    }

    @Override
    boolean checkConnection() {
        return this.mProtocolSender.tcpCheckTvState(this.mIp, this.mPort);
    }
}

