/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.os.Build;
import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolBuilder;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.protocol.push.IPushHandler;
import com.hpplay.component.protocol.push.PushControllerImpl;
import org.json.JSONObject;

public class LelinkPushHandler
extends IPushHandler {
    private static final String TAG = "LelinkPushHandler";

    public LelinkPushHandler(ParamsMap paramsMap) {
        super(paramsMap);
    }

    @Override
    public String buildPush(String string, ParamsMap paramsMap) {
        CLog.i(TAG, "start ----------->" + this.mSessionId);
        String string2 = "";
        if (paramsMap.containsKey("screencode")) {
            string2 = (String)paramsMap.get("screencode");
        }
        String string3 = "";
        if (paramsMap.containsKey("header")) {
            string3 = (String)paramsMap.get("header");
        }
        String string4 = (String)paramsMap.get("mediatype");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            // empty if block
        }
        String string5 = new ProtocolBuilder().setContentLocation(string).setStartPosition(this.mStartPosition + "").setContentUri(this.mPushUri).getString(true);
        String string6 = new ProtocolBuilder().getPlayCmd().setContentType("text/parameters").setContentLength(string5.getBytes().length + "").setUserAgent(string4.equals("101") ? "HappyCast/Audio 1.0" : "MediaControl/1.0").setAutorization(string2).setUserLelinkSessionId(this.mSessionId).setPlatfrom().setMobileDeviceName(Build.MANUFACTURER + " " + Build.MODEL).setDevicesIMEI(this.mImei).setMobileDeviceChannel(this.mAppid).setLelinkDeviceId(this.mHid).setMobileDevCu(this.mUid).setDeviceType("Android").getString(true);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("mStartPosition", this.mStartPosition);
                jSONObject.put("playUrl", (Object)string);
                jSONObject.put("urlId", (Object)this.mPushUri);
                jSONObject.put("header", (Object)string3);
                string5 = jSONObject.toString();
                string6 = new ProtocolBuilder().getSendVideoInfoCmd().setContentType("text/parameters").setContentLength(string5.getBytes().length + "").setUserAgent(string4.equals("101") ? "HappyCast/Audio 1.0" : "MediaControl/1.0").setUserLelinkSessionId(this.mSessionId).setPlatfrom().setMobileDeviceName(Build.MANUFACTURER + " " + Build.MODEL).setDevicesIMEI(this.mImei).setMobileDeviceChannel(this.mAppid).setLelinkDeviceId(this.mHid).setMobileDevCu(this.mUid).setDeviceType("Android").getString(true);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return string6 + string5;
    }

    @Override
    String buildGetPlayInfo() {
        return new ProtocolBuilder().getPositionCmd().setContentType("text/x-apple-plist+xml").setContentLength("0").setUserAgent("MediaControl/1.0").setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String buildGetStateInfo() {
        return null;
    }

    @Override
    String buildPause() {
        return new ProtocolBuilder().getPauseCmd().setContentLength("0").setUserAgent(this.mUserAgent).setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String buildResume() {
        return new ProtocolBuilder().getRecoverPlayCmd().setContentLength("0").setUserAgent(this.mUserAgent).setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String buildSeekTo(int n2) {
        String string = new ProtocolBuilder().getSetPositionCmd().setContentLength("0").setUserAgent("MediaControl/1.0").setUserLelinkSessionId(this.mSessionId).getString(true);
        return String.format(string, n2);
    }

    @Override
    String buildIncreaseVolume() {
        return new ProtocolBuilder().getaddVolumeCmd().setUserAgent("HappyCast3,1").setContentLength("0").setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String buildDecreaseVolume() {
        return new ProtocolBuilder().getsubVolumeCmd().setUserAgent("HappyCast3,1").setContentLength("0").setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String buildStopPlay() {
        CLog.i(TAG, "----------->" + this.mSessionId);
        return new ProtocolBuilder().getStopCmd().setContentLength("0").setUserAgent("MediaControl/1.0").setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    public String getReverseData() {
        return new ProtocolBuilder().getReverseCmd().setUpgradeKey("PTTH/1.0").setConnectionKey("Upgrade").setApplePurposeKey("event").setContentLength("0").setUserAgent("MediaControl/1.0").setUserLelinkSessionId(this.mSessionId).getString(true);
    }

    @Override
    String setVolume(int n2) {
        return null;
    }

    @Override
    public synchronized void parseReversePlist(PushControllerImpl pushControllerImpl, String ... stringArray) {
        NSDictionary nSDictionary;
        if (stringArray == null || stringArray[0] == null) {
            return;
        }
        String string = stringArray[0];
        CLog.d(TAG, string);
        if (string.contains("Switching Protocols")) {
            return;
        }
        if (string.contains("photohide")) {
            CLog.d(TAG, "on PHOTO_HIDE");
            pushControllerImpl.disConnect();
            return;
        }
        try {
            nSDictionary = (NSDictionary)PropertyListParser.parse(string.getBytes());
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return;
        }
        if (nSDictionary != null) {
            String string2 = "0";
            String string3 = "0";
            String string4 = "";
            if (nSDictionary.containsKey("urlID")) {
                string4 = nSDictionary.objectForKey("urlID").toString();
            }
            String string5 = this.upperFirstChar("duration");
            String string6 = this.upperFirstChar("position");
            if (nSDictionary.containsKey(string5)) {
                string2 = nSDictionary.objectForKey(string5).toString();
            }
            if (nSDictionary.containsKey(string6)) {
                string3 = nSDictionary.objectForKey(string6).toString();
            }
            try {
                if (Integer.valueOf(string2) > 0 && Integer.valueOf(string3) > 0) {
                    CLog.d(TAG, "reverse to uiduration : " + string2 + "position : " + string3);
                    pushControllerImpl.eventCallback(17, string2, string3, string4);
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (nSDictionary.containsKey("stoptype")) {
                String string7 = nSDictionary.objectForKey("stoptype").toString();
                if (TextUtils.equals((CharSequence)string7, (CharSequence)"media_completion")) {
                    pushControllerImpl.disConnect();
                    pushControllerImpl.eventCallback(12, string4);
                    CLog.d(TAG, "on completion");
                    return;
                }
                if (TextUtils.equals((CharSequence)string7, (CharSequence)"phonevideohide")) {
                    CLog.d(TAG, "on stop");
                    pushControllerImpl.disConnect();
                    pushControllerImpl.eventCallback(7, string4);
                    return;
                }
            }
            if (nSDictionary.containsKey("state")) {
                String string8;
                switch (string8 = nSDictionary.objectForKey("state").toString()) {
                    case "playing": {
                        if (!this.isPlaying) {
                            this.isPlaying = true;
                            pushControllerImpl.eventCallback(13, string4);
                        }
                        CLog.d(TAG, "PLAYING");
                        break;
                    }
                    case "loading": {
                        CLog.d(TAG, "LOADING");
                        pushControllerImpl.eventCallback(14, string4);
                        break;
                    }
                    case "paused": {
                        CLog.d(TAG, "PAUSED ");
                        if (this.isPlaying) {
                            pushControllerImpl.eventCallback(15, string4);
                        }
                        this.isPlaying = false;
                        break;
                    }
                    case "stopped": {
                        pushControllerImpl.disConnect();
                        CLog.d(TAG, "STOPPED ");
                        pushControllerImpl.eventCallback(16, string4);
                        CLog.d(TAG, "state on stop---------");
                        break;
                    }
                    case "error": {
                        CLog.d(TAG, "ERROR");
                        pushControllerImpl.disConnect();
                        pushControllerImpl.eventCallback(16, string4);
                    }
                }
            }
        }
    }

    public String upperFirstChar(String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (i2 == 0) {
                stringBuffer.append(String.valueOf(cArray[0]).toUpperCase());
                continue;
            }
            stringBuffer.append(cArray[i2]);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean parsePlayBackInfo(int n2, String string, ProtocolListener protocolListener) {
        if (string.contains("duration:") && string.contains("position:")) {
            try {
                String string2 = string.substring(string.lastIndexOf(":") + 1).trim();
                string = string.substring(0, string.lastIndexOf("position"));
                String string3 = string.substring(string.lastIndexOf(":") + 1).trim();
                if (protocolListener != null) {
                    protocolListener.onResult(n2, string3, string2);
                }
                return true;
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return false;
    }
}

