/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.browse.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class LelinkServiceInfoWrapper
implements Parcelable,
Comparable<LelinkServiceInfoWrapper> {
    private static final String TAG = "LelinkServiceInfoWrapper";
    private static final String KEY_INFOS = "info";
    private static final String IP_PREFIX_REGEX = "(?<!\\d)\\d{1,3}\\.\\d{1,3}(?=\\.\\d)";
    private String name;
    private String alias;
    private String ip;
    private int port;
    private String uid;
    private boolean isConnect;
    private String pinCode;
    private String manufacturer;
    private Map<Integer, BrowserInfo> mBrowserInfos;
    public static final Parcelable.Creator<LelinkServiceInfoWrapper> CREATOR = new Parcelable.Creator<LelinkServiceInfoWrapper>(){

        public LelinkServiceInfoWrapper createFromParcel(Parcel parcel) {
            LelinkServiceInfoWrapper lelinkServiceInfoWrapper = new LelinkServiceInfoWrapper(parcel);
            try {
                ConcurrentHashMap<Integer, BrowserInfo> concurrentHashMap = new ConcurrentHashMap<Integer, BrowserInfo>();
                int n2 = parcel.readInt();
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = parcel.readInt();
                    BrowserInfo browserInfo = (BrowserInfo)parcel.readParcelable(BrowserInfo.class.getClassLoader());
                    concurrentHashMap.put(n3, browserInfo);
                }
                lelinkServiceInfoWrapper.mBrowserInfos = concurrentHashMap;
            }
            catch (Exception exception) {
                SourceLog.w(LelinkServiceInfoWrapper.TAG, exception);
            }
            return lelinkServiceInfoWrapper;
        }

        public LelinkServiceInfoWrapper[] newArray(int n2) {
            return new LelinkServiceInfoWrapper[n2];
        }
    };

    public LelinkServiceInfoWrapper() {
        this.mBrowserInfos = new ConcurrentHashMap<Integer, BrowserInfo>();
    }

    public LelinkServiceInfoWrapper(int n2, BrowserInfo browserInfo) {
        this.uid = browserInfo.getUid();
        this.name = browserInfo.getName();
        this.ip = browserInfo.getIp();
        this.port = browserInfo.getPort();
        this.mBrowserInfos = new ConcurrentHashMap<Integer, BrowserInfo>();
        this.mBrowserInfos.put(browserInfo.getType(), browserInfo);
        this.supplyIMBrowserInfo(n2, browserInfo);
    }

    public LelinkServiceInfoWrapper(String string, String string2) {
        this.uid = string;
        this.name = string2;
        this.mBrowserInfos = new ConcurrentHashMap<Integer, BrowserInfo>();
        BrowserInfo browserInfo = new BrowserInfo(4, 4);
        browserInfo.setUid(string);
        browserInfo.setName(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("u", string);
        browserInfo.setExtras(hashMap);
        this.mBrowserInfos.put(4, browserInfo);
    }

    public LelinkServiceInfoWrapper(String string, int n2) {
        this.ip = string;
        this.port = n2;
        this.mBrowserInfos = new ConcurrentHashMap<Integer, BrowserInfo>();
        BrowserInfo browserInfo = new BrowserInfo(1, 8);
        browserInfo.setIp(string);
        browserInfo.setName(this.name);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ip", string);
        String string2 = String.valueOf(n2);
        hashMap.put("lelinkport", string2);
        hashMap.put("airplay", string2);
        hashMap.put("raop", string2);
        hashMap.put("vv", "2");
        browserInfo.setExtras(hashMap);
        this.mBrowserInfos.put(1, browserInfo);
    }

    protected LelinkServiceInfoWrapper(Parcel parcel) {
        this.name = parcel.readString();
        this.alias = parcel.readString();
        this.ip = parcel.readString();
        this.port = parcel.readInt();
        this.uid = parcel.readString();
        this.isConnect = parcel.readByte() != 0;
        this.pinCode = parcel.readString();
        this.manufacturer = parcel.readString();
    }

    @Deprecated
    public boolean isOnLine() {
        if (null != this.mBrowserInfos) {
            for (Integer n2 : this.mBrowserInfos.keySet()) {
                BrowserInfo browserInfo = this.mBrowserInfos.get(n2);
                if (!browserInfo.isOnLine()) continue;
                return true;
            }
        }
        return false;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String string) {
        this.pinCode = string;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    @Deprecated
    public boolean isConnect() {
        return this.isConnect;
    }

    @Deprecated
    public void setConnect(boolean bl) {
        this.isConnect = bl;
    }

    public boolean isLocalWifi() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            BrowserInfo browserInfo = this.mBrowserInfos.get(1);
            if (null != browserInfo && browserInfo.isLocalWifi()) {
                return true;
            }
            BrowserInfo browserInfo2 = this.mBrowserInfos.get(3);
            if (null != browserInfo2 && browserInfo2.isLocalWifi()) {
                return true;
            }
        }
        return false;
    }

    public String getPackageName() {
        Map<String, String> map;
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && !this.mBrowserInfos.isEmpty() && null != (browserInfo = this.mBrowserInfos.get(1)) && null != (map = browserInfo.getExtras()) && !map.isEmpty()) {
            return map.get("packagename");
        }
        return null;
    }

    public String getUdnUuid() {
        Map<String, String> map;
        if (this.mBrowserInfos == null || this.mBrowserInfos.size() == 0) {
            return null;
        }
        BrowserInfo browserInfo = this.mBrowserInfos.get(3);
        if (null != browserInfo && null != (map = browserInfo.getExtras()) && !map.isEmpty()) {
            return map.get("dlna_udn_uuid");
        }
        return null;
    }

    public int getRemotePort() {
        try {
            String string;
            BrowserInfo browserInfo;
            if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(1)) != null && !TextUtils.isEmpty((CharSequence)(string = browserInfo.getExtras().get("remote"))) && TextUtils.isDigitsOnly((CharSequence)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return 0;
    }

    public int getAndroidRemotePort() {
        try {
            String string;
            BrowserInfo browserInfo;
            if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(1)) != null && !TextUtils.isEmpty((CharSequence)(string = browserInfo.getExtras().get("port"))) && TextUtils.isDigitsOnly((CharSequence)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return 0;
    }

    public int getAgentPort() {
        try {
            String string;
            Map<String, String> map;
            BrowserInfo browserInfo;
            if (null != this.mBrowserInfos && !this.mBrowserInfos.isEmpty() && null != (browserInfo = this.mBrowserInfos.get(1)) && null != (map = browserInfo.getExtras()) && !map.isEmpty() && !TextUtils.isEmpty((CharSequence)(string = map.get("agentPort"))) && TextUtils.isDigitsOnly((CharSequence)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return 0;
    }

    public int getW() {
        try {
            BrowserInfo browserInfo;
            String string;
            if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && !TextUtils.isEmpty((CharSequence)(string = (browserInfo = this.mBrowserInfos.get(1)).getExtras().get("w"))) && TextUtils.isDigitsOnly((CharSequence)string)) {
                return Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return 0;
    }

    public int getH() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            BrowserInfo browserInfo = this.mBrowserInfos.get(1);
            try {
                String string = browserInfo.getExtras().get("h");
                if (!TextUtils.isEmpty((CharSequence)string) && TextUtils.isDigitsOnly((CharSequence)string)) {
                    return Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        return 0;
    }

    public int getAppId() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            try {
                String string;
                Object object;
                BrowserInfo browserInfo = this.mBrowserInfos.get(1);
                if (browserInfo != null && browserInfo.getExtras() != null && !TextUtils.isEmpty((CharSequence)(object = browserInfo.getExtras().get("a"))) && TextUtils.isDigitsOnly((CharSequence)object)) {
                    return Integer.parseInt((String)object);
                }
                object = this.mBrowserInfos.get(4);
                if (object != null && ((BrowserInfo)object).getExtras() != null && !TextUtils.isEmpty((CharSequence)(string = ((BrowserInfo)object).getExtras().get("a"))) && TextUtils.isDigitsOnly((CharSequence)string)) {
                    return Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        return 0;
    }

    public String getPol() {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(4)) != null) {
            return browserInfo.getExtras().get("pol");
        }
        return "0";
    }

    public String getPlatform() {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(4)) != null) {
            return browserInfo.getExtras().get("pt");
        }
        return "uk";
    }

    public String getMac() {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(1)) != null && browserInfo.getExtras() != null) {
            return browserInfo.getExtras().get("devicemac");
        }
        return "unknow";
    }

    public void setMac(String string) {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0 && (browserInfo = this.mBrowserInfos.get(1)) != null && browserInfo.getExtras() != null) {
            browserInfo.getExtras().put("devicemac", string);
        }
    }

    public boolean hasNewVersion() {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && !this.mBrowserInfos.isEmpty() && null != (browserInfo = this.mBrowserInfos.get(1))) {
            Map<String, String> map = browserInfo.getExtras();
            String string = map.get("appInfo");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                String[] stringArray = string.split(",");
                String string2 = stringArray[0];
                if ("1".equalsIgnoreCase(string2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public String getChannel() {
        Map<String, String> map;
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && !this.mBrowserInfos.isEmpty() && null != (browserInfo = this.mBrowserInfos.get(1)) && null != (map = browserInfo.getExtras()) && !map.isEmpty()) {
            return map.get("channel");
        }
        return null;
    }

    public Map<Integer, BrowserInfo> getBrowserInfos() {
        return this.mBrowserInfos;
    }

    public String getTypes() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Map.Entry<Integer, BrowserInfo>> iterator = this.mBrowserInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, BrowserInfo> entry = iterator.next();
                BrowserInfo browserInfo = entry.getValue();
                if (browserInfo != null) {
                    switch (browserInfo.getType()) {
                        case 1: {
                            stringBuilder.append("Lelink");
                            break;
                        }
                        case 3: {
                            stringBuilder.append("DLNA").append("(").append(browserInfo.getExtras().get("manufacturer")).append(",").append(browserInfo.getExtras().get("dlna_mode_name")).append(")");
                            break;
                        }
                        case 4: {
                            stringBuilder.append("IM");
                        }
                    }
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public String getSSDPPacketData() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            for (Map.Entry<Integer, BrowserInfo> entry : this.mBrowserInfos.entrySet()) {
                String string;
                BrowserInfo browserInfo = entry.getValue();
                if (browserInfo == null || browserInfo.getExtras() == null || browserInfo.getExtras().get("ssdp_packet_data") == null || TextUtils.isEmpty((CharSequence)(string = browserInfo.getExtras().get("ssdp_packet_data")))) continue;
                return string;
            }
        }
        return null;
    }

    public int getDrainage(int n2) {
        if (n2 < 0) {
            SourceLog.w(TAG, "getDrainage,value is invalid");
            return 0;
        }
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            for (Map.Entry<Integer, BrowserInfo> entry : this.mBrowserInfos.entrySet()) {
                String string;
                int n3;
                String string2;
                BrowserInfo browserInfo = entry.getValue();
                if (browserInfo == null || browserInfo.getExtras() == null || browserInfo.getExtras().get("drainage") == null || TextUtils.isEmpty((CharSequence)(string2 = browserInfo.getExtras().get("drainage"))) || !TextUtils.isDigitsOnly((CharSequence)string2.trim()) || (n3 = Integer.parseInt(string2.trim())) <= 0 || TextUtils.isEmpty((CharSequence)(string = new StringBuilder(Integer.toBinaryString(n3)).reverse().toString())) || string.length() <= n2) continue;
                return Integer.parseInt(string.substring(n2, n2 + 1));
            }
        }
        return 0;
    }

    public Integer[] getProtocols() {
        if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Map.Entry<Integer, BrowserInfo> entry : this.mBrowserInfos.entrySet()) {
                BrowserInfo browserInfo = entry.getValue();
                if (browserInfo == null) continue;
                switch (browserInfo.getType()) {
                    case 1: {
                        arrayList.add(1);
                        break;
                    }
                    case 3: {
                        arrayList.add(3);
                        break;
                    }
                    case 4: {
                        arrayList.add(4);
                    }
                }
            }
            Integer[] integerArray = new Integer[3];
            return arrayList.toArray(integerArray);
        }
        return null;
    }

    public Map<String, String> getParams() {
        BrowserInfo browserInfo;
        if (null != this.mBrowserInfos && !this.mBrowserInfos.isEmpty() && null != (browserInfo = this.mBrowserInfos.get(1))) {
            return browserInfo.getExtras();
        }
        return null;
    }

    public boolean isDangle(BrowserInfo browserInfo) {
        try {
            String string = browserInfo.getExtras().get("channel");
            if (!TextUtils.isEmpty((CharSequence)string) && string.contains("dongle")) {
                return true;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    public void supplyIMBrowserInfo(int n2, BrowserInfo browserInfo) {
        if (TextUtils.isEmpty((CharSequence)this.uid) && !TextUtils.isEmpty((CharSequence)browserInfo.getUid())) {
            this.uid = browserInfo.getUid();
        }
        this.name = browserInfo.getName();
        this.ip = browserInfo.getIp();
        this.mBrowserInfos.put(browserInfo.getType(), browserInfo);
        if (Feature.isDisableIM()) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.uid) && browserInfo.getType() == 1) {
            BrowserInfo browserInfo2 = this.mBrowserInfos.get(4);
            if (null == browserInfo2) {
                browserInfo2 = new BrowserInfo(4, n2);
                browserInfo2.setUid(browserInfo.getUid());
                browserInfo2.setIp(browserInfo.getIp());
                browserInfo2.setName(browserInfo.getName());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("u", String.valueOf(browserInfo.getUid()));
                if (browserInfo.getExtras() != null) {
                    hashMap.put("a", browserInfo.getExtras().get("a"));
                    hashMap.put("tunnels", browserInfo.getExtras().get("tunnels"));
                    hashMap.put("drainage", browserInfo.getExtras().get("drainage"));
                }
                browserInfo2.setExtras(hashMap);
                this.mBrowserInfos.put(4, browserInfo2);
            } else {
                browserInfo2.setName(browserInfo.getName());
                browserInfo2.setIp(browserInfo.getIp());
                Map<String, String> map = browserInfo2.getExtras();
                if (null == map) {
                    map = new HashMap<String, String>();
                }
                if (TextUtils.isEmpty((CharSequence)map.get("u"))) {
                    map.put("u", String.valueOf(browserInfo.getUid()));
                }
                if (TextUtils.isEmpty((CharSequence)map.get("a")) && browserInfo.getExtras() != null) {
                    map.put("a", browserInfo.getExtras().get("a"));
                }
                browserInfo2.setExtras(map);
            }
        }
    }

    public void updateByBrowseInfo(BrowserInfo browserInfo) {
        BrowserInfo browserInfo2;
        if (null == this.mBrowserInfos) {
            this.mBrowserInfos = new ConcurrentHashMap<Integer, BrowserInfo>();
        }
        if (null == (browserInfo2 = this.mBrowserInfos.get(browserInfo.getType()))) {
            this.mBrowserInfos.put(browserInfo.getType(), browserInfo);
        } else {
            this.supplyIMBrowserInfo(browserInfo2.getType(), browserInfo2);
            browserInfo2.setLocalWifi(browserInfo.isLocalWifi());
            browserInfo2.setOnLine(browserInfo.isOnLine());
        }
    }

    public void decode(int n2, JSONObject jSONObject) {
        if (null != jSONObject) {
            this.name = jSONObject.optString("name");
            this.ip = jSONObject.optString("ip");
            this.uid = jSONObject.optString("u");
            JSONArray jSONArray = jSONObject.optJSONArray(KEY_INFOS);
            if (null != jSONArray) {
                int n3 = jSONArray.length();
                for (int i2 = 0; i2 < n3; ++i2) {
                    BrowserInfo browserInfo = new BrowserInfo(n2, jSONArray.optJSONObject(i2));
                    this.supplyIMBrowserInfo(n2, browserInfo);
                }
            }
        }
    }

    public JSONObject encode() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("u", (Object)this.uid);
            jSONObject.put("name", (Object)this.name);
            jSONObject.put("ip", (Object)this.ip);
            if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
                JSONArray jSONArray = new JSONArray();
                for (Integer n2 : this.mBrowserInfos.keySet()) {
                    BrowserInfo browserInfo = this.mBrowserInfos.get(n2);
                    jSONArray.put((Object)browserInfo.encode());
                }
                jSONObject.put(KEY_INFOS, (Object)jSONArray);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public String toString() {
        return "LelinkServiceInfo{, name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", uid='" + this.uid + '\'' + ", mBrowserInfos=" + this.mBrowserInfos + '}';
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)object;
        if (!TextUtils.isEmpty((CharSequence)this.getUid()) && !TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getUid())) {
            return this.getUid().equalsIgnoreCase(lelinkServiceInfo.getUid());
        }
        if (!TextUtils.isEmpty((CharSequence)this.getIp()) && !TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getIp())) {
            return this.getIp().equalsIgnoreCase(lelinkServiceInfo.getIp()) && TextUtils.equals((CharSequence)this.getName(), (CharSequence)lelinkServiceInfo.getName());
        }
        return super.equals(object);
    }

    public String getManufacturer() {
        if (!TextUtils.isEmpty((CharSequence)this.manufacturer)) {
            return this.manufacturer;
        }
        return "unknow";
    }

    public void setManufacturer(String string) {
        this.manufacturer = string;
    }

    @Override
    public int compareTo(LelinkServiceInfoWrapper lelinkServiceInfoWrapper) {
        if (this == lelinkServiceInfoWrapper) {
            return 0;
        }
        if (!TextUtils.isEmpty((CharSequence)this.uid) && !TextUtils.isEmpty((CharSequence)lelinkServiceInfoWrapper.uid)) {
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)this.uid) && TextUtils.isEmpty((CharSequence)lelinkServiceInfoWrapper.uid)) {
            return 0;
        }
        return !TextUtils.isEmpty((CharSequence)this.uid) ? -1 : 1;
    }

    public String getRcvPlf() {
        BrowserInfo browserInfo = this.mBrowserInfos.get(1);
        if (browserInfo != null) {
            return browserInfo.getExtras().get("pt");
        }
        return "tv";
    }

    public boolean isSupportPassthrough() {
        if (TextUtils.isEmpty((CharSequence)this.uid)) {
            return false;
        }
        try {
            if (null != this.mBrowserInfos && this.mBrowserInfos.size() > 0) {
                Object object;
                if (this.mBrowserInfos.size() == 1 && (object = this.mBrowserInfos.get(4)) != null) {
                    return true;
                }
                for (Map.Entry entry : this.mBrowserInfos.entrySet()) {
                    BrowserInfo browserInfo = (BrowserInfo)entry.getValue();
                    if (browserInfo == null) continue;
                    Map<String, String> map = browserInfo.getExtras();
                    String string = null;
                    if (map != null) {
                        string = map.get("vv");
                    }
                    if ((TextUtils.isEmpty(string) || !TextUtils.equals((CharSequence)string, (CharSequence)"2")) && browserInfo.getType() != 4) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.name);
        parcel.writeString(this.alias);
        parcel.writeString(this.ip);
        parcel.writeInt(this.port);
        parcel.writeString(this.uid);
        parcel.writeByte((byte)(this.isConnect ? 1 : 0));
        parcel.writeString(this.pinCode);
        parcel.writeString(this.manufacturer);
        if (this.mBrowserInfos != null) {
            int n3 = this.mBrowserInfos.size();
            parcel.writeInt(n3);
            if (n3 > 0) {
                for (Map.Entry<Integer, BrowserInfo> entry : this.mBrowserInfos.entrySet()) {
                    parcel.writeInt(entry.getKey().intValue());
                    parcel.writeParcelable((Parcelable)entry.getValue(), n2);
                }
            }
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

