/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.common.store;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.hpplay.common.utils.ContextPath;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.bean.AuthRepeatInfoBean;
import com.hpplay.sdk.source.bean.DebugTimestampBean;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.LeboUtil;
import java.util.UUID;

public class Session {
    private static final String TAG = "Session";
    private static Session mInstance = null;
    private final Context mContext;
    public int serverPort = 0;
    public String serverProtocolVer = "";
    public String tid = "";
    private String token = "";
    @Deprecated
    public int scanTime = 60;
    public int mExpireTime;
    public String appKey;
    public String appSecret;
    public String appVersion;
    public String userID;
    public String oaID;
    public String mTUID;
    private String mUID;
    private String mHID;
    private long mRegTime;
    public boolean isAuthSuccess;
    public boolean isFirstBoot = true;
    public boolean isPreferLelink = false;
    public ContextPath mContextPath;
    public boolean isFilter501Version = true;
    public String department;
    public String jobNumber;
    private ILogCallback mLogCallback;
    private IDebugAVListener mDebugAVListener;
    private AuthRepeatInfoBean infoBean;
    private DebugTimestampBean mDebugBean;
    private boolean mDebugTimestamp = false;
    private String mBannerData = null;
    private boolean disableIM = false;
    private static final String DEFAULT_MAC = "02:00:00:00:00:00";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSession(Context context) {
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (mInstance == null) {
                mInstance = new Session(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Session getInstance() {
        Application application;
        if (mInstance == null && (application = HapplayUtils.getApplication()) != null) {
            Session.initSession((Context)application);
        }
        return mInstance;
    }

    private Session(Context context) {
        this.mContext = context;
        try {
            this.mContextPath = ContextPath.getInstance(context, 2, Feature.isZTEChannel() ? "smartcast" : "");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void updateRepeatInfo(AuthRepeatInfoBean authRepeatInfoBean) {
        this.infoBean = authRepeatInfoBean;
        this.updateUID();
        this.updateHID();
    }

    public String getUID() {
        if (TextUtils.isEmpty((CharSequence)this.mUID)) {
            this.updateUID();
        }
        return this.mUID;
    }

    public void updateUID() {
        if (this.infoBean != null && !TextUtils.isEmpty((CharSequence)this.infoBean.getUid())) {
            this.mUID = this.infoBean.getUid();
            SourceLog.i(TAG, "updateUID use server uid " + this.mUID);
        } else {
            this.mUID = String.valueOf(LeboUtil.getCUid64(this.mContext));
            SourceLog.i(TAG, "updateUID use local uid " + this.mUID);
        }
    }

    public String getHID() {
        if (TextUtils.isEmpty((CharSequence)this.mHID)) {
            this.updateHID();
        }
        return this.mHID;
    }

    public void updateHID() {
        if (this.infoBean != null && !TextUtils.isEmpty((CharSequence)this.infoBean.getHid())) {
            this.mHID = this.infoBean.getHid();
            SourceLog.i(TAG, "updateHID use server hid " + this.mHID);
        } else {
            this.mHID = LeboUtil.getNewSourceHID(this.mContext);
            SourceLog.i(TAG, "updateHID create new hid " + this.mHID);
        }
    }

    public String getIMEI() {
        String string;
        if (!TextUtils.isEmpty((CharSequence)DeviceUtil.getOAID(this.mContext))) {
            string = "oaid_" + DeviceUtil.getOAID(this.mContext);
        } else if (Feature.isOPPOChannel()) {
            string = Preference.getInstance().get("create_id");
            if (TextUtils.isEmpty((CharSequence)string)) {
                string = UUID.randomUUID().toString();
                Preference.getInstance().get("create_id", string);
            }
        } else {
            string = DeviceUtil.getIMEI(this.mContext);
        }
        return string;
    }

    @Deprecated
    public String getMac() {
        return DEFAULT_MAC;
    }

    public long getRegTime() {
        if (this.infoBean != null) {
            this.mRegTime = this.infoBean.getRegTime();
        }
        return this.mRegTime;
    }

    public void setRegTime(long l2) {
        this.mRegTime = l2;
    }

    public ILogCallback getLogCallback() {
        return this.mLogCallback;
    }

    public void setLogCallback(ILogCallback iLogCallback) {
        this.mLogCallback = iLogCallback;
    }

    public IDebugAVListener getDebugAVListener() {
        return this.mDebugAVListener;
    }

    public void setDebugAVListener(IDebugAVListener iDebugAVListener) {
        this.mDebugAVListener = iDebugAVListener;
    }

    public void setDebugTimestamp(boolean bl) {
        this.mDebugTimestamp = bl;
    }

    public boolean getDebugTimestamp() {
        return this.mDebugTimestamp;
    }

    public void setDebugTimestampBean(DebugTimestampBean debugTimestampBean) {
        this.mDebugBean = debugTimestampBean;
    }

    public DebugTimestampBean getDebugTimestampBean() {
        return this.mDebugBean;
    }

    public ContextPath getContextPath() {
        if (this.mContextPath == null) {
            try {
                this.mContextPath = ContextPath.getInstance(this.mContext.getApplicationContext(), 2, Feature.isZTEChannel() ? "smartcast" : "");
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        return this.mContextPath;
    }

    public String getToken() {
        if (TextUtils.isEmpty((CharSequence)this.token)) {
            SourceLog.w(TAG, "invalid token");
        }
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public String getBannerData() {
        if (TextUtils.isEmpty((CharSequence)this.mBannerData)) {
            SourceLog.w(TAG, "invalid mBannerData");
        }
        return this.mBannerData;
    }

    public void setBannerData(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "invalid mBannerData");
        }
        this.mBannerData = string;
    }

    public void disableIM(boolean bl) {
        this.disableIM = bl;
    }

    public boolean isDisableIM() {
        return this.disableIM;
    }
}

