/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.net;

import android.util.Log;
import com.hpplay.sdk.source.mdns.net.DNSParserThread;
import com.hpplay.sdk.source.mdns.net.NetworkProcessor;
import com.hpplay.sdk.source.mdns.net.Packet;
import com.hpplay.sdk.source.mdns.net.PacketListener;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;

public class DatagramProcessor
extends NetworkProcessor {
    private static final String TAG = "DatagramProcessor";
    protected int maxPayloadSize = 512;
    protected boolean isMulticast = false;
    protected boolean loopbackModeDisabled = false;
    protected boolean reuseAddress = true;
    protected int ttl = 255;
    protected DatagramSocket socket;
    private long lastPacket;

    public DatagramProcessor(InetAddress inetAddress, InetAddress inetAddress2, int n2, PacketListener packetListener) {
        super(inetAddress, inetAddress2, n2, packetListener);
        Object object;
        Log.i((String)TAG, (String)"-------start create DatagramProcessor-----");
        if (inetAddress2 != null) {
            this.isMulticast = inetAddress2.isMulticastAddress();
        }
        NetworkInterface networkInterface = null;
        if (this.isMulticast) {
            object = new MulticastSocket(n2);
            String string = Options.value("mdns_multicast_loopback");
            if (string != null && string.length() > 0) {
                boolean bl = this.loopbackModeDisabled = "true".equalsIgnoreCase(string) || "t".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "y".equalsIgnoreCase(string);
            }
            if ((string = Options.value("mdns_socket_ttl")) != null && string.length() > 0) {
                try {
                    this.ttl = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.reuseAddress = true;
            ((MulticastSocket)object).setLoopbackMode(this.loopbackModeDisabled);
            ((DatagramSocket)object).setReuseAddress(this.reuseAddress);
            ((MulticastSocket)object).setTimeToLive(this.ttl);
            ((MulticastSocket)object).joinGroup(inetAddress2);
            this.socket = object;
        } else {
            this.socket = new DatagramSocket(new InetSocketAddress(inetAddress, n2));
        }
        networkInterface = NetworkInterface.getByInetAddress(inetAddress);
        if (networkInterface == null && (networkInterface = NetworkInterface.getByInetAddress(this.socket.getLocalAddress())) == null && (object = this.socket.getInetAddress()) != null) {
            networkInterface = NetworkInterface.getByInetAddress((InetAddress)object);
        }
        if (networkInterface != null) {
            try {
                this.mtu = networkInterface.getMTU();
            }
            catch (SocketException socketException) {
                networkInterface = null;
                Log.i((String)TAG, (String)("Error getting MTU from nw Interface " + networkInterface + ". Using default MTU."));
            }
        }
        if (networkInterface == null) {
            object = NetworkInterface.getNetworkInterfaces();
            int n3 = 1500;
            while (object.hasMoreElements()) {
                int n4;
                NetworkInterface networkInterface2 = (NetworkInterface)object.nextElement();
                if (networkInterface2.isLoopback() || networkInterface2.isVirtual() || !networkInterface2.isUp() || (n4 = networkInterface2.getMTU()) >= n3) continue;
                n3 = n4;
            }
            this.mtu = n3;
        }
        Log.i((String)TAG, (String)"-------start end -----");
        this.maxPayloadSize = this.mtu - 40 - 8;
    }

    @Override
    public void close() {
        super.close();
        if (this.isMulticast) {
            try {
                Log.w((String)TAG, (String)"-------release  -----");
                ((MulticastSocket)this.socket).leaveGroup(this.address);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)"------------------------release socket ");
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public boolean isLoopbackModeDisabled() {
        return this.loopbackModeDisabled;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public int getTTL() {
        return this.ttl;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public boolean isMulticast() {
        return this.isMulticast;
    }

    @Override
    public boolean isOperational() {
        return super.isOperational() && this.socket.isBound() && !this.socket.isClosed() && this.lastPacket <= System.currentTimeMillis() + 120000L;
    }

    @Override
    public void run() {
        this.lastPacket = System.currentTimeMillis();
        Log.i((String)TAG, (String)" DatagramProcessor create ");
        DNSParserThread dNSParserThread = new DNSParserThread(this.listener);
        dNSParserThread.start();
        while (!this.exit && !this.isClose) {
            try {
                byte[] byArray = new byte[this.mtu];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.socket.receive(datagramPacket);
                this.lastPacket = System.currentTimeMillis();
                if (datagramPacket.getLength() <= 0) continue;
                Packet packet = new Packet(datagramPacket);
                dNSParserThread.updateReceiveData(packet);
            }
            catch (Exception exception) {
                if (this.exit) break;
                Log.i((String)TAG, (String)"Error receiving data from  executors is release");
                break;
            }
        }
        dNSParserThread.release();
        Log.i((String)TAG, (String)" runnable exit ");
    }

    @Override
    public void send(byte[] byArray) {
        if (this.exit) {
            return;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.address, this.port);
        try {
            if (this.isMulticast) {
                ((MulticastSocket)this.socket).setTimeToLive(255);
            }
            this.socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            if ("no route to host".equalsIgnoreCase(iOException.getMessage())) {
                this.close();
            }
            IOException iOException2 = new IOException("Exception \"" + iOException.getMessage() + "\" occured while sending datagram to \"" + datagramPacket.getSocketAddress() + "\".", iOException);
            iOException2.setStackTrace(iOException.getStackTrace());
            throw iOException2;
        }
    }
}

