/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.net;

import android.util.Log;
import com.hpplay.sdk.source.mdns.net.NetworkReadThread;
import com.hpplay.sdk.source.mdns.net.PacketListener;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;

public abstract class NetworkProcessor
implements Closeable,
Runnable {
    public static final String TAG = "NetworkProcessor";
    public static final int DEFAULT_MTU = 1500;
    public static final int AVERAGE_QUEUE_THRESHOLD = 2;
    public static final int MAX_QUEUE_THRESHOLD = 10;
    public static final int PACKET_MONITOR_NO_PACKET_RECEIVED_TIMEOUT = 100000;
    protected InetAddress ifaceAddress;
    protected InetAddress address;
    protected boolean ipv6;
    protected int port;
    protected int mtu = 1500;
    protected transient boolean exit = false;
    protected PacketListener listener;
    protected boolean threadMonitoring = Options.check("mdns_network_thread_monitor");
    protected NetworkReadThread networkReadThread = null;
    protected boolean isClose = false;

    public NetworkProcessor(InetAddress inetAddress, InetAddress inetAddress2, int n2, PacketListener packetListener) {
        this.setInterfaceAddress(inetAddress);
        this.address = inetAddress2;
        this.setPort(n2);
        if (inetAddress.getAddress().length != inetAddress2.getAddress().length) {
            throw new IOException("Interface Address and bind address bust be the same IP specifciation!");
        }
        this.ipv6 = inetAddress2.getAddress().length > 4;
        this.listener = packetListener;
    }

    @Override
    public synchronized void close() {
        Log.i((String)TAG, (String)"------------------------ > >>> >>> release  ");
        this.exit = true;
        this.isClose = true;
        if (this.networkReadThread != null) {
            this.networkReadThread.interrupt();
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getInterfaceAddress() {
        return this.ifaceAddress;
    }

    public int getMTU() {
        return this.mtu;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIPv4() {
        return !this.ipv6;
    }

    public boolean isIPv6() {
        return this.ipv6;
    }

    public boolean isOperational() {
        return !this.exit;
    }

    public abstract void send(byte[] var1);

    public void setInterfaceAddress(InetAddress inetAddress) {
        this.ifaceAddress = inetAddress;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public synchronized void start() {
        this.exit = false;
        Log.i((String)TAG, (String)("------------------------ > >>> >>> NetworkProcessor   run" + this.threadMonitoring));
        if (this.threadMonitoring) {
            // empty if block
        }
        Log.i((String)TAG, (String)"------------------------ > >>> >>> start CRATE THREAD ");
        this.networkReadThread = new NetworkReadThread(this);
        this.networkReadThread.start();
    }
}

