/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AAAARecord
extends Record {
    private static final long serialVersionUID = -4588601512069748050L;
    private byte[] address;

    AAAARecord() {
    }

    @Override
    Record getObject() {
        return new AAAARecord();
    }

    @Override
    void rrFromWire(DNSInput dNSInput) {
        this.address = dNSInput.readByteArray(16);
    }

    @Override
    void rdataFromString(Tokenizer tokenizer, Name name) {
        this.address = tokenizer.getAddressBytes(2);
    }

    @Override
    String rrToString() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByAddress(null, this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        if (inetAddress.getAddress().length == 4) {
            StringBuffer stringBuffer = new StringBuffer("0:0:0:0:0:ffff:");
            int n2 = ((this.address[12] & 0xFF) << 8) + (this.address[13] & 0xFF);
            int n3 = ((this.address[14] & 0xFF) << 8) + (this.address[15] & 0xFF);
            stringBuffer.append(Integer.toHexString(n2));
            stringBuffer.append(':');
            stringBuffer.append(Integer.toHexString(n3));
            return stringBuffer.toString();
        }
        return inetAddress.getHostAddress();
    }

    public InetAddress getAddress() {
        try {
            return this.name == null ? InetAddress.getByAddress(this.address) : InetAddress.getByAddress(this.name.toString(), this.address);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.address);
    }
}

