/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.pass.sinktouch;

import android.os.SystemClock;
import android.view.MotionEvent;
import com.hpplay.sdk.source.api.LelinkAccessibilityService;
import com.hpplay.sdk.source.bean.PathEventInfo;
import com.hpplay.sdk.source.bean.SinkTouchEvent;
import com.hpplay.sdk.source.bean.SinkTouchPointerInfo;
import com.hpplay.sdk.source.log.SourceLog;

public class GlobalSinkTouchEventTransformer {
    private static final String TAG = "GlobalSinkTouchEventTransformer";
    static float mStartX;
    static float mStartY;
    private static long mTouchDownTime;

    static void transformEvent(SinkTouchEvent sinkTouchEvent) {
        GlobalSinkTouchEventTransformer.transformPointerEvent(sinkTouchEvent.pointerInfos[0]);
    }

    private static void transformPointerEvent(SinkTouchPointerInfo sinkTouchPointerInfo) {
        int n2 = sinkTouchPointerInfo.actionType;
        float f2 = sinkTouchPointerInfo.ratioX;
        float f3 = sinkTouchPointerInfo.ratioY;
        SourceLog.i(TAG, "transformPointerEvent x:" + f2 + ",y:" + f3);
        MotionEvent motionEvent = MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)n2, (float)f2, (float)f3, (int)0);
        GlobalSinkTouchEventTransformer.transformWrapEvent(motionEvent);
    }

    private static void transformWrapEvent(MotionEvent motionEvent) {
        SourceLog.i(TAG, "onTouchEvent action:" + motionEvent.getAction());
        if (motionEvent.getAction() == 0) {
            mTouchDownTime = System.currentTimeMillis();
            mStartX = motionEvent.getX();
            mStartY = motionEvent.getY();
            SourceLog.i(TAG, "onTouchEvent mStartX:" + mStartX + ",mStartY:" + mStartY + "\uff0cmTouchDownTime\uff1a" + mTouchDownTime);
            return;
        }
        if (motionEvent.getAction() == 1) {
            PathEventInfo pathEventInfo = new PathEventInfo(mStartX, mStartY, motionEvent.getX(), motionEvent.getY(), (int)(System.currentTimeMillis() - mTouchDownTime));
            SourceLog.i(TAG, "onTouchEvent TargetRatioX:" + pathEventInfo.getTargetRatioX() + ",TargetRatioY:" + pathEventInfo.getTargetRatioY() + "\uff0cduration\uff1a" + pathEventInfo.getDuration());
            if (LelinkAccessibilityService.lelinkAccessibilityService != null) {
                LelinkAccessibilityService.lelinkAccessibilityService.moveOnScreen(pathEventInfo, null);
            }
            return;
        }
    }
}

