/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.RightsManager;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.process.OnlineManager;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.protocol.connect.CloudConnectBridge;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import com.hpplay.sdk.source.protocol.connect.GroupConnectBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectManager {
    private static final String TAG = "ConnectManager";
    public static final int DISCONNECT_BY_USER = 1;
    public static final int DISCONNECT_BY_RECONNECT = 2;
    public static final int DISCONNECT_BY_NET_DISCONNECT = 3;
    public static final int DISCONNECT_BY_OTHER = 100;
    private static ConnectManager sInstance;
    private OnlineManager mOnlineManager;
    private IConnectListener mOuterListener;
    private IConnectListener mConnectCheckListener;
    private final Map<String, ConnectBridge> mConnectMap = new ConcurrentHashMap<String, ConnectBridge>();
    private ConnectBridge mLastConnectBridge;
    private static final int MSG_NET_RECHECK = 1;
    private static final int DELAY_TIME_NET_RECHECK = 15000;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    NetworkUtil.NetworkType networkType = NetworkUtil.getNetworkType((Context)HapplayUtils.getApplication());
                    SourceLog.i(ConnectManager.TAG, "networkType:" + (Object)((Object)networkType));
                    if (networkType != NetworkUtil.NetworkType.NETWORK_NO && networkType != NetworkUtil.NetworkType.NETWORK_UNKNOWN) break;
                    Iterator iterator = ConnectManager.this.mConnectMap.values().iterator();
                    while (iterator.hasNext()) {
                        try {
                            ConnectBridge connectBridge = (ConnectBridge)iterator.next();
                            connectBridge.disconnect(3);
                            iterator.remove();
                            SourceLog.i(ConnectManager.TAG, "networkType:" + (Object)((Object)networkType));
                        }
                        catch (Exception exception) {
                            SourceLog.w(ConnectManager.TAG, exception);
                        }
                    }
                    break;
                }
            }
            return false;
        }
    });
    private final IConnectListener mConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            SourceLog.i(ConnectManager.TAG, "onConnect " + lelinkServiceInfo + "/" + n2);
            if (ConnectManager.this.mOuterListener != null) {
                if (n2 == 5) {
                    ConnectManager.this.mOuterListener.onConnect(lelinkServiceInfo, 1);
                } else {
                    ConnectManager.this.mOuterListener.onConnect(lelinkServiceInfo, n2);
                }
            }
            if (ConnectManager.this.mConnectCheckListener != null) {
                ConnectManager.this.mConnectCheckListener.onConnect(lelinkServiceInfo, n2);
            }
            ConnectManager.this.reportLiveConnect(lelinkServiceInfo);
            if (lelinkServiceInfo != null) {
                RightsManager.getInstance().getSinkTempRights(CastUtil.getKey(lelinkServiceInfo), lelinkServiceInfo.getAppId(), n2);
            }
            if (ConnectManager.this.mOnlineManager != null) {
                ConnectManager.this.mOnlineManager.updateOnlineTime(lelinkServiceInfo);
            }
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            if (lelinkServiceInfo == null) {
                return;
            }
            SourceLog.i(ConnectManager.TAG, "onDisconnect " + lelinkServiceInfo + " " + n2 + "/" + n3);
            if (ConnectManager.this.mOuterListener != null) {
                ConnectManager.this.mOuterListener.onDisconnect(lelinkServiceInfo, n2, n3);
            }
            if (n2 == 212012) {
                return;
            }
            if (ConnectManager.this.mOnlineManager != null) {
                ConnectManager.this.mOnlineManager.remove(lelinkServiceInfo);
            }
            ConnectManager.this.removeBridge(lelinkServiceInfo);
            String string = CastUtil.getKey(lelinkServiceInfo);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                RightsManager.getInstance().removeSinkRights(string);
            }
        }
    };
    private String mReportDll;

    private ConnectManager() {
        if (this.enableOnlineCheck()) {
            this.mOnlineManager = new OnlineManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConnectManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<ConnectManager> clazz = ConnectManager.class;
        synchronized (ConnectManager.class) {
            if (sInstance != null) return sInstance;
            SourceLog.i(TAG, "getInstance: new ConnectManager");
            sInstance = new ConnectManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void setConnectListener(IConnectListener iConnectListener) {
        this.mOuterListener = iConnectListener;
    }

    public void setConnectCheckListener(IConnectListener iConnectListener) {
        this.mConnectCheckListener = iConnectListener;
    }

    public void connect(Context context, LelinkServiceInfo lelinkServiceInfo, boolean bl) {
        String string = CastUtil.getKey(lelinkServiceInfo);
        SourceLog.i(TAG, "+++++++++++++++++++++++++++++++++= connect " + lelinkServiceInfo.getIp() + "/" + lelinkServiceInfo.getName() + "/" + string);
        if (bl) {
            GroupConnectBridge groupConnectBridge = null;
            if (this.mConnectMap.containsKey(string) && this.mConnectMap.get(string) instanceof GroupConnectBridge) {
                groupConnectBridge = (GroupConnectBridge)this.mConnectMap.get(string);
            }
            if (groupConnectBridge == null) {
                groupConnectBridge = new GroupConnectBridge();
                this.mConnectMap.put(string, groupConnectBridge);
            }
            this.mLastConnectBridge = groupConnectBridge;
            groupConnectBridge.setConnectListener(this.mConnectListener);
            groupConnectBridge.setConnectCheckListener(this.mConnectCheckListener);
            groupConnectBridge.connect(lelinkServiceInfo);
        } else {
            ConnectBridge connectBridge = null;
            if (this.mConnectMap.containsKey(string) && (connectBridge = this.mConnectMap.get(string)) instanceof GroupConnectBridge) {
                connectBridge.release();
                connectBridge = null;
            }
            if (connectBridge == null || !connectBridge.checkBridge(lelinkServiceInfo)) {
                connectBridge = new ConnectBridge(context, lelinkServiceInfo);
                this.mConnectMap.put(string, connectBridge);
            }
            this.mLastConnectBridge = connectBridge;
            connectBridge.setConnectListener(this.mConnectListener);
            connectBridge.connect(lelinkServiceInfo);
        }
    }

    public void connectServer(Context context, LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "connectServer");
        CloudConnectBridge cloudConnectBridge = new CloudConnectBridge(context);
        cloudConnectBridge.setConnectListener(this.mConnectListener);
        ((AbsConnectBridge)cloudConnectBridge).connect(lelinkServiceInfo);
    }

    public LelinkServiceInfo getLelinkServiceInfo(String string) {
        for (ConnectBridge connectBridge : this.mConnectMap.values()) {
            if (!string.equals(connectBridge.getServiceInfo().getUid())) continue;
            return connectBridge.getServiceInfo();
        }
        return null;
    }

    public void resetLastConnectBridge(LelinkServiceInfo lelinkServiceInfo) {
        for (ConnectBridge connectBridge : this.mConnectMap.values()) {
            LelinkServiceInfo lelinkServiceInfo2 = connectBridge.getServiceInfo();
            if (!TextUtils.equals((CharSequence)lelinkServiceInfo.getName(), (CharSequence)lelinkServiceInfo2.getName()) || !TextUtils.equals((CharSequence)lelinkServiceInfo.getIp(), (CharSequence)lelinkServiceInfo2.getIp())) continue;
            this.mLastConnectBridge = connectBridge;
            break;
        }
    }

    public void groupReconnect(int n2, LelinkServiceInfo lelinkServiceInfo, IConnectListener iConnectListener) {
        if (this.mLastConnectBridge != null && this.mLastConnectBridge instanceof GroupConnectBridge) {
            ((GroupConnectBridge)this.mLastConnectBridge).groupReconnect(n2, lelinkServiceInfo, iConnectListener);
        }
    }

    public ConnectBridge getLastConnectBridge() {
        return this.mLastConnectBridge;
    }

    public ConnectBridge getConnectBridge(String string) {
        if (TextUtils.isEmpty((CharSequence)string) || this.mConnectMap.isEmpty()) {
            SourceLog.i(TAG, " getConnectBridge uid:" + string);
            return null;
        }
        for (ConnectBridge connectBridge : this.mConnectMap.values()) {
            if (connectBridge == null || connectBridge.getServiceInfo() == null || !string.equals(connectBridge.getServiceInfo().getUid())) continue;
            return connectBridge;
        }
        SourceLog.w(TAG, " getConnectBridge has no uid bridge " + this.mConnectMap.size() + "/" + string);
        return null;
    }

    public boolean isConnected(OutParameter outParameter) {
        if (outParameter == null || outParameter.serviceInfo == null) {
            return false;
        }
        String string = CastUtil.getKey(outParameter.serviceInfo);
        return this.mConnectMap.containsKey(string);
    }

    public String getConnectSession(LelinkServiceInfo lelinkServiceInfo) {
        String string = CastUtil.getKey(lelinkServiceInfo);
        if (!this.mConnectMap.containsKey(string)) {
            SourceLog.w(TAG, "getConnectSession ignore, service not connect yet " + string);
            return null;
        }
        ConnectBridge connectBridge = this.mConnectMap.get(string);
        if (connectBridge == null) {
            SourceLog.w(TAG, "getConnectSession ignore, service not connect yet 2," + string);
            return null;
        }
        SourceLog.i(TAG, " ++++++++  getConnectSession ++++++++" + connectBridge.getConnectProtocol());
        if (connectBridge.getConnectProtocol() == -1) {
            SourceLog.i(TAG, "disconnect ......... ");
            this.disconnect(lelinkServiceInfo);
            return null;
        }
        return connectBridge.getConnectSession();
    }

    public String getConnectSession(LelinkServiceInfo lelinkServiceInfo, boolean bl) {
        try {
            String string = this.getConnectSession(lelinkServiceInfo);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                String string2 = CastUtil.getKey(lelinkServiceInfo);
                ConnectBridge connectBridge = this.mConnectMap.get(string2);
                SourceLog.i(TAG, " ++++++++  getConnectSession ++++++++" + bl);
                if (connectBridge != null && connectBridge.isGroup == bl) {
                    return string;
                }
                SourceLog.i(TAG, " ++++++++ getConnectSession disconnect ++++++++");
                this.disconnect(lelinkServiceInfo);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return null;
    }

    public int getConnectProtocol(LelinkServiceInfo lelinkServiceInfo) {
        String string = CastUtil.getKey(lelinkServiceInfo);
        if (!this.mConnectMap.containsKey(string)) {
            SourceLog.w(TAG, "getConnectProtocol ignore, service not connect yet " + string);
            return -1;
        }
        ConnectBridge connectBridge = this.mConnectMap.get(string);
        if (connectBridge == null) {
            SourceLog.w(TAG, "getConnectProtocol ignore, service not connect yet 2," + string);
            return -1;
        }
        return connectBridge.getConnectProtocol();
    }

    public LelinkServiceInfo getLastServiceInfo() {
        if (this.mLastConnectBridge == null) {
            SourceLog.w(TAG, "getLastServiceInfo has no valid connect bridge");
            return null;
        }
        return this.mLastConnectBridge.getServiceInfo();
    }

    public void switchGroupConnection(int n2) {
        if (this.mLastConnectBridge != null && this.mLastConnectBridge instanceof GroupConnectBridge) {
            ((GroupConnectBridge)this.mLastConnectBridge).switchGroupConnection(n2);
        }
    }

    public void groupReconnect() {
        if (this.mLastConnectBridge != null && this.mLastConnectBridge instanceof GroupConnectBridge) {
            ((GroupConnectBridge)this.mLastConnectBridge).groupReconnect();
        }
    }

    public void disconnect(LelinkServiceInfo lelinkServiceInfo) {
        String string = CastUtil.getKey(lelinkServiceInfo);
        if (!this.mConnectMap.containsKey(string)) {
            SourceLog.w(TAG, "disconnect ignore");
            return;
        }
        ConnectBridge connectBridge = this.mConnectMap.get(string);
        if (connectBridge == null) {
            SourceLog.w(TAG, "disconnect ignore 2");
            return;
        }
        if (connectBridge instanceof GroupConnectBridge) {
            connectBridge.setConnectListener(null);
            ((GroupConnectBridge)connectBridge).setConnectCheckListener(null);
        }
        connectBridge.disconnect(1);
        SourceLog.i(TAG, "disconnect");
        this.removeBridge(lelinkServiceInfo);
        RightsManager.getInstance().removeSinkRights(string);
    }

    public void onNetDisconnect() {
        Iterator<ConnectBridge> iterator = this.mConnectMap.values().iterator();
        while (iterator.hasNext()) {
            try {
                ConnectBridge connectBridge = iterator.next();
                if (connectBridge instanceof GroupConnectBridge) continue;
                if (connectBridge.mConnectBridge instanceof CloudConnectBridge) {
                    this.mMainHandler.removeCallbacksAndMessages(null);
                    this.mMainHandler.sendEmptyMessageDelayed(1, 15000L);
                    continue;
                }
                connectBridge.disconnect(3);
                iterator.remove();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
    }

    public void sendPassData(LelinkServiceInfo lelinkServiceInfo, int n2, String string, String string2) {
        String string3 = CastUtil.getKey(lelinkServiceInfo);
        ConnectBridge connectBridge = this.mConnectMap.get(string3);
        SourceLog.i(TAG, "=======sendPassData====== " + (connectBridge == null));
        if (connectBridge == null) {
            SourceLog.i(TAG, "sendPassData ignore 1");
            return;
        }
        if (!connectBridge.isSupportPassthrough()) {
            SourceLog.i(TAG, "sendPassData ignore, nonsupport passthrough");
            return;
        }
        this.sendPassData(connectBridge, n2, string, string2);
    }

    public void sendPassData(ConnectBridge connectBridge, int n2, String string, String string2) {
        if (connectBridge == null) {
            SourceLog.i(TAG, "sendPassData ignore 100");
            return;
        }
        if (!connectBridge.isSupportPassthrough()) {
            SourceLog.i(TAG, "sendPassData ignore, nonsupport passthrough");
            return;
        }
        connectBridge.sendPassData(n2, string, string2);
    }

    public List<LelinkServiceInfo> getConnections() {
        ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
        for (ConnectBridge connectBridge : this.mConnectMap.values()) {
            if (!connectBridge.isConnected()) continue;
            arrayList.add(connectBridge.getServiceInfo());
        }
        return arrayList;
    }

    public boolean checkOnline(LelinkServiceInfo lelinkServiceInfo, OnlineManager.OnlineListener onlineListener) {
        if (lelinkServiceInfo == null || this.mOnlineManager == null) {
            return false;
        }
        return this.mOnlineManager.checkOnline(lelinkServiceInfo, onlineListener);
    }

    public void notifyBrowseResult(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null || this.mOnlineManager == null) {
            return;
        }
        this.mOnlineManager.updateOnlineTime(lelinkServiceInfo);
    }

    public void notifyCastSuccess(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null || this.mOnlineManager == null) {
            return;
        }
        this.mOnlineManager.updateOnlineTime(lelinkServiceInfo);
    }

    public void notifyCastError(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null || this.mOnlineManager == null) {
            return;
        }
        this.mOnlineManager.remove(lelinkServiceInfo);
    }

    public void notifyCastStatusValid(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null || this.mOnlineManager == null) {
            return;
        }
        this.mOnlineManager.updateOnlineTime(lelinkServiceInfo);
    }

    public void notifyInvalid(LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.w(TAG, "notifyInvalid " + lelinkServiceInfo);
        this.notifyOffline(lelinkServiceInfo, 212010, 212100);
    }

    public void notifyOffline(LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.w(TAG, "notifyOffline " + lelinkServiceInfo);
        this.notifyOffline(lelinkServiceInfo, 212010, 212018);
    }

    private void notifyOffline(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
        try {
            this.mConnectListener.onDisconnect(lelinkServiceInfo, n2, n3);
            if (this.mOnlineManager != null) {
                this.mOnlineManager.remove(lelinkServiceInfo);
            }
            this.removeBridge(lelinkServiceInfo);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void notifyDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
        SourceLog.w(TAG, "notifyDisconnect " + lelinkServiceInfo + " " + n2 + " / " + n3);
        this.mConnectListener.onDisconnect(lelinkServiceInfo, n2, n3);
    }

    public void removeBridge(LelinkServiceInfo lelinkServiceInfo) {
        ConnectBridge connectBridge;
        String string = CastUtil.getKey(lelinkServiceInfo);
        if (!TextUtils.isEmpty((CharSequence)string) && (connectBridge = this.mConnectMap.get(string)) != null) {
            connectBridge.release();
            this.mConnectMap.remove(string);
        }
        if (this.mConnectMap != null && this.mConnectMap.size() < 1) {
            this.mMainHandler.removeCallbacksAndMessages(null);
        }
    }

    public void reportLiveConnect(LelinkServiceInfo lelinkServiceInfo) {
        List<LelinkServiceInfo> list = LelinkSdkManager.getInstance().getBrowserList();
        if (list == null || list.size() == 0 || lelinkServiceInfo == null) {
            return;
        }
        SourceLog.i(TAG, "reportLiveConnect lelinkServiceInfos = " + list.size());
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                LelinkServiceInfo lelinkServiceInfo2 = list.get(i2);
                Map<Integer, BrowserInfo> map = lelinkServiceInfo2.getBrowserInfos();
                if (map != null && map.size() > 0) {
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    String string6 = "0";
                    if (!TextUtils.isEmpty((CharSequence)lelinkServiceInfo2.getUid())) {
                        string6 = "1";
                        string5 = lelinkServiceInfo2.getUid();
                    }
                    for (Map.Entry<Integer, BrowserInfo> entry : map.entrySet()) {
                        BrowserInfo browserInfo = entry.getValue();
                        if (browserInfo == null) continue;
                        string = browserInfo.getExtras().get("devicemac");
                        if (TextUtils.isEmpty((CharSequence)string)) {
                            string = "";
                        }
                        string4 = browserInfo.getIp();
                        if (browserInfo.getType() == 3) {
                            string2 = browserInfo.getExtras().get("manufacturer");
                            if (TextUtils.isEmpty((CharSequence)string2)) {
                                string2 = "";
                            }
                            if (!(string3 = browserInfo.getName()).contains("#")) continue;
                            string3 = string3.replace("#", "");
                            continue;
                        }
                        string3 = browserInfo.getExtras().get("u");
                    }
                    stringBuffer.append(string6).append("#").append(string4).append("#").append(string).append("#").append(string2).append("#").append(string3).append("#").append(string5);
                }
                if (i2 >= list.size() - 1) continue;
                stringBuffer.append(",");
            }
            if (TextUtils.isEmpty((CharSequence)this.mReportDll) || !TextUtils.equals((CharSequence)this.mReportDll, (CharSequence)stringBuffer.toString().trim())) {
                this.mReportDll = stringBuffer.toString().trim();
                SourceLog.debug(TAG, "reportLiveConnect dll = " + this.mReportDll);
                SourceDataReport.getInstance().onReceiverLive(this.getConnectSession(lelinkServiceInfo), this.mReportDll);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private boolean enableOnlineCheck() {
        return Feature.isLeboApp();
    }
}

