/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.connect;

import android.text.TextUtils;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.bean.PassBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.common.store.ConnectCache;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.bean.BaseBean;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public abstract class AbsConnectBridge {
    private static final String TAG = "AbsConnectBridge";
    protected IConnectListener mAppListener = null;
    protected LelinkServiceInfo mServiceInfo;
    protected BrowserInfo mConnectBrowserInfo;
    protected String mConnectSession;
    private Map<Integer, Integer> mPassSMMap = new HashMap<Integer, Integer>();
    private final Map<Object, OnPassReceivedListener> onPassReceivedListenerMap = new HashMap<Object, OnPassReceivedListener>();
    private final Map<Object, OnPassSendCompleteListener> onPassSendCompleteListenerMap = new HashMap<Object, OnPassSendCompleteListener>();
    private boolean isConnected;

    public void setConnectListener(IConnectListener iConnectListener) {
        this.mAppListener = iConnectListener;
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        this.mServiceInfo = lelinkServiceInfo;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public void addOnPassReceivedListener(Object object, OnPassReceivedListener onPassReceivedListener) {
        if (!this.onPassReceivedListenerMap.containsKey(object)) {
            this.onPassReceivedListenerMap.put(object, onPassReceivedListener);
        }
    }

    public void removeOnPassReceivedListener(Object object) {
        this.onPassReceivedListenerMap.remove(object);
    }

    public void addOnPassSendCompleteListener(Object object, OnPassSendCompleteListener onPassSendCompleteListener) {
        if (!this.onPassSendCompleteListenerMap.containsKey(object)) {
            this.onPassSendCompleteListenerMap.put(object, onPassSendCompleteListener);
        }
    }

    public void removeOnPassSendCompleteListener(Object object) {
        this.onPassSendCompleteListenerMap.remove(object);
    }

    public void notifyPassReceivedData(int n2, BaseBean baseBean) {
        for (OnPassReceivedListener onPassReceivedListener : this.onPassReceivedListenerMap.values()) {
            onPassReceivedListener.onPassReversed(n2, baseBean);
        }
    }

    public LelinkServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public String getConnectSession() {
        return this.mConnectSession;
    }

    public abstract boolean isSupportUrlList();

    public abstract boolean isSupportTrack();

    public void callbackPass(PassBean passBean) {
        SourceLog.i(TAG, "callbackPass");
        if (LelinkSdkManager.getInstance().mPassCallback != null) {
            LelinkSdkManager.getInstance().mPassCallback.onSendPassCallBack(passBean);
        }
        for (OnPassSendCompleteListener onPassSendCompleteListener : this.onPassSendCompleteListenerMap.values()) {
            onPassSendCompleteListener.onPassReversed(passBean);
        }
    }

    public abstract void sendPassData(int var1, String var2, String var3);

    public void disconnect(int n2) {
        this.onPassReceivedListenerMap.clear();
    }

    public void setSinkSM(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        try {
            String[] stringArray;
            for (String string2 : stringArray = string.split(";")) {
                String[] stringArray2 = string2.split(",");
                this.mPassSMMap.put(Integer.valueOf(stringArray2[0]), Integer.valueOf(stringArray2[1]));
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public boolean isSupportPassMsg(int n2) {
        String string = this.getSinkKey();
        if (this.mPassSMMap.size() == 0 && !TextUtils.isEmpty((CharSequence)string)) {
            String string2 = ConnectCache.getInstance().get(string);
            try {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("sm");
                this.setSinkSM(string3);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, "isSupportPassMsg " + exception.getMessage());
            }
        }
        return this.mPassSMMap.containsKey(n2);
    }

    public void saveConnectBean(String string) {
        String string2 = this.getSinkKey();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            ConnectCache.getInstance().save(string2, string);
        }
    }

    private String getSinkKey() {
        String string = "";
        String string2 = "";
        if (this.mServiceInfo != null) {
            string = String.valueOf(this.mServiceInfo.getAppId());
            string2 = this.mServiceInfo.getUid();
        }
        return string + string2;
    }

    public void release() {
    }

    public static interface OnPassSendCompleteListener {
        public void onPassReversed(PassBean var1);
    }

    public static interface OnPassReceivedListener {
        public void onPassReversed(int var1, BaseBean var2);
    }
}

