/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import com.hpplay.common.log.LeLog;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.UUID;

public class LeboUtil {
    private static final String TAG = "LeboUtil";
    private static final String CUT_ANDROID = "1";
    private static final String SIGN_NORMAL = "0";
    private static final String SIGN_MAC = "1";
    private static final String SIGN_IMEI = "2";
    private static final String SIGN_OAID = "6";
    private static final String SIGN_ANDROIDID = "7";
    private static final String SIGN_NEW_MAC = "8";
    private static final String DEFAULT_MAC = "0000000000000000";
    private static String sAndroidID = "";

    public static int getCUid(Context context) {
        if (null == context) {
            return -1;
        }
        return EncryptUtil.fnvHash(EncryptUtil.md5EncryData16(("1" + LeboUtil.getCUidMaterial(context) + context.getPackageName()).toUpperCase()).toUpperCase());
    }

    public static long getCUid64(Context context) {
        return EncryptUtil.parseMd5L16ToLong(EncryptUtil.md5EncryData16(("1" + LeboUtil.getCUidMaterial(context) + context.getPackageName()).toUpperCase()).toUpperCase());
    }

    private static String getCUidMaterial(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.delete(0, stringBuilder.length());
        try {
            if (!TextUtils.isEmpty((CharSequence)DeviceUtil.getOAID(context))) {
                stringBuilder.append(DeviceUtil.getOAID(context));
            } else if (!TextUtils.isEmpty((CharSequence)DeviceUtil.getIMEI(context))) {
                stringBuilder.append(DeviceUtil.getIMEI(context));
            } else if (!TextUtils.isEmpty((CharSequence)LeboUtil.getAndroidID(context))) {
                stringBuilder.append(LeboUtil.getAndroidID(context));
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        if (TextUtils.isEmpty((CharSequence)stringBuilder.toString())) {
            stringBuilder.append(DEFAULT_MAC);
        }
        return stringBuilder.toString();
    }

    public static String getNewSourceHID(Context context) {
        String string = "";
        if (Build.VERSION.SDK_INT <= 28) {
            try {
                string = DeviceUtil.getIMEI(context);
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    string = EncryptUtil.md5EncryData(string.toUpperCase());
                    string = SIGN_IMEI + string.toUpperCase();
                    return string;
                }
                string = DEFAULT_MAC;
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
                string = DEFAULT_MAC;
            }
        } else {
            string = DEFAULT_MAC;
        }
        string = EncryptUtil.md5EncryData(string.toUpperCase());
        string = SIGN_NORMAL + string.toUpperCase();
        return string;
    }

    public static String getAndroidID(Context context) {
        if (!TextUtils.isEmpty((CharSequence)sAndroidID)) {
            return sAndroidID;
        }
        String string = Preference.getInstance().get("key_lb_ai");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                sAndroidID = new String(Base64.decode((String)string, (int)0));
                return sAndroidID;
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(sAndroidID = DeviceUtil.getAndroidID(context)))) {
            try {
                String string2 = Base64.encodeToString((byte[])sAndroidID.getBytes(), (int)0);
                Preference.getInstance().put("key_lb_ai", string2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            return sAndroidID;
        }
        sAndroidID = UUID.randomUUID().toString();
        try {
            String string3 = Base64.encodeToString((byte[])sAndroidID.getBytes(), (int)0);
            Preference.getInstance().put("key_lb_ai", string3);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return sAndroidID;
    }

    public static String anonymizeByMD5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            string = string.toUpperCase().replace(":", "");
            string = EncryptUtil.md5EncryData(string);
            string = string.toUpperCase();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "anonymizeByMD5 error " + exception);
        }
        return string;
    }

    public static String anonymizeBySHA256(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            string = string.toUpperCase().replace(":", "");
            string = EncryptUtil.encryptSHA256ToString(string);
            string = string.toUpperCase();
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "anonymizeBySHA256 error " + exception);
        }
        return string;
    }
}

