/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;

public class UriUtils {
    public static String getFilePathByUri(Context context, Uri uri) {
        String string = null;
        if ("file".equals(uri.getScheme())) {
            string = uri.getPath();
            return string;
        }
        if ("content".equals(uri.getScheme()) && Build.VERSION.SDK_INT < 19) {
            Cursor cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                int n2;
                if (cursor.moveToFirst() && (n2 = cursor.getColumnIndexOrThrow("_data")) > -1) {
                    string = cursor.getString(n2);
                }
                cursor.close();
            }
            return string;
        }
        if ("content".equals(uri.getScheme()) && Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (UriUtils.isExternalStorageDocument(uri)) {
                String string2 = DocumentsContract.getDocumentId((Uri)uri);
                String[] stringArray = string2.split(":");
                String string3 = stringArray[0];
                if ("primary".equalsIgnoreCase(string3)) {
                    string = Environment.getExternalStorageDirectory() + "/" + stringArray[1];
                    return string;
                }
            } else {
                if (UriUtils.isDownloadsDocument(uri)) {
                    String string4 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri uri2 = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(string4));
                    string = UriUtils.getDataColumn(context, uri2, null, null);
                    return string;
                }
                if (UriUtils.isMediaDocument(uri)) {
                    String string5 = DocumentsContract.getDocumentId((Uri)uri);
                    String[] stringArray = string5.split(":");
                    String string6 = stringArray[0];
                    Uri uri3 = null;
                    if ("image".equals(string6)) {
                        uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(string6)) {
                        uri3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(string6)) {
                        uri3 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String string7 = "_id=?";
                    String[] stringArray2 = new String[]{stringArray[1]};
                    string = UriUtils.getDataColumn(context, uri3, "_id=?", stringArray2);
                    return string;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String string, String[] stringArray) {
        Cursor cursor = null;
        String string2 = "_data";
        String[] stringArray2 = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, stringArray2, string, stringArray, null);
            if (cursor != null && cursor.moveToFirst()) {
                int n2 = cursor.getColumnIndexOrThrow("_data");
                String string3 = cursor.getString(n2);
                return string3;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }
}

