/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.asyncmanager;

import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncCallableJob;
import com.hpplay.common.asyncmanager.AsyncCallableListener;
import com.hpplay.common.asyncmanager.AsyncFileJob;
import com.hpplay.common.asyncmanager.AsyncFileParameter;
import com.hpplay.common.asyncmanager.AsyncFileRequestListener;
import com.hpplay.common.asyncmanager.AsyncHttpJob;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncRunnableJob;
import com.hpplay.common.asyncmanager.AsyncRunnableListener;
import com.hpplay.common.asyncmanager.AsyncUploadFileJob;
import com.hpplay.common.asyncmanager.AsyncUploadFileListener;
import com.hpplay.common.asyncmanager.AsyncUploadFileParameter;
import com.hpplay.common.log.LeLog;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;

public class AsyncManager {
    private static final String TAG = "AsyncManager";
    private static AsyncManager instance = new AsyncManager();
    public static final int METHOD_GET = 0;
    public static final int METHOD_POST = 1;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_FAILED = 1;
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_NULL_URL = 3;
    public static final int RESULT_INVALID_TYPE = 4;
    public static final int RESULT_FILE_DOWNLOADING = 5;
    public static final int RESULT_FILE_DOWNLOAD_CANCEL = 6;
    public static final int RESULT_FILE_DOWNLOAD_ERROR = 7;
    public static final int RESULT_FILE_DOWNLOAD_SUCCESS = 8;
    public static final int RESULT_UPLOAD_STATUS_SUCCESS = 1;
    public static final int RESULT_UPLOAD_STATUS_BUSY = 2;
    public static final int RESULT_UPLOAD_STATUS_FAILED = 3;
    private final int MAX_SEMAPHORE = 15;
    private volatile Semaphore mSemaphore = new Semaphore(15, true);
    private volatile ConcurrentLinkedQueue<AsyncTask> mSemaphoreTaskList = new ConcurrentLinkedQueue();
    private volatile ConcurrentLinkedQueue<AsyncTask> mTaskList = new ConcurrentLinkedQueue();
    private boolean isDebug = false;
    private Executor executor = Executors.newCachedThreadPool();

    private AsyncManager() {
    }

    public static synchronized AsyncManager getInstance() {
        return instance;
    }

    public void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    private void printTaskDetail() {
        if (this.isDebug) {
            LeLog.i(TAG, "printTaskDetail running list zie :" + this.mTaskList.size() + "  waiting task size:" + this.mSemaphoreTaskList.size() + " Semaphore: " + this.mSemaphore.availablePermits());
        }
    }

    private void exeTask(AsyncTask asyncTask, boolean bl) {
        if (bl) {
            try {
                asyncTask.executeOnExecutor(this.executor, new Object[0]);
                this.mTaskList.add(asyncTask);
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
            }
        } else if (this.mSemaphore.tryAcquire()) {
            try {
                asyncTask.executeOnExecutor(this.executor, new Object[0]);
                this.mTaskList.add(asyncTask);
            }
            catch (Exception exception) {
                LeLog.w(TAG, exception);
                this.mSemaphore.release();
            }
        } else {
            LeLog.w(TAG, "exeTask parallel too many,wait amount. mSemaphore: " + this.mSemaphore);
            this.mSemaphoreTaskList.add(asyncTask);
        }
        this.printTaskDetail();
    }

    private void releaseTask(AsyncTask asyncTask) {
        this.mSemaphore.release();
        try {
            if (this.mTaskList.contains(asyncTask)) {
                this.mTaskList.remove(asyncTask);
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        this.printTaskDetail();
        if (this.mSemaphoreTaskList.size() > 0 && this.mSemaphore.availablePermits() > 0) {
            AsyncTask asyncTask2 = this.mSemaphoreTaskList.poll();
            if (asyncTask2 == null) {
                return;
            }
            this.exeTask(asyncTask2, false);
        }
    }

    public AsyncRunnableJob exeRunnable(Runnable runnable, AsyncRunnableListener asyncRunnableListener) {
        return this.exeRunnable(runnable, asyncRunnableListener, false);
    }

    public AsyncRunnableJob exeRunnableWithoutParallel(Runnable runnable, AsyncRunnableListener asyncRunnableListener) {
        return this.exeRunnable(runnable, asyncRunnableListener, true);
    }

    private AsyncRunnableJob exeRunnable(Runnable runnable, AsyncRunnableListener asyncRunnableListener, boolean bl) {
        AsyncRunnableJob asyncRunnableJob = new AsyncRunnableJob(runnable, asyncRunnableListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncRunnableJob, bl);
        return asyncRunnableJob;
    }

    public AsyncCallableJob exeCallable(Callable callable, AsyncCallableListener asyncCallableListener) {
        return this.exeCallable(callable, asyncCallableListener, false);
    }

    public AsyncCallableJob exeCallableWithoutParallel(Callable callable, AsyncCallableListener asyncCallableListener) {
        return this.exeCallable(callable, asyncCallableListener, true);
    }

    private AsyncCallableJob exeCallable(Callable callable, AsyncCallableListener asyncCallableListener, boolean bl) {
        AsyncCallableJob asyncCallableJob = new AsyncCallableJob(callable, asyncCallableListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncCallableJob, bl);
        return asyncCallableJob;
    }

    public AsyncHttpJob exeHttpTask(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        return this.exeHttpTask(asyncHttpParameter, asyncHttpRequestListener, false);
    }

    public AsyncHttpJob exeHttpTaskWithoutParallel(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener) {
        return this.exeHttpTask(asyncHttpParameter, asyncHttpRequestListener, true);
    }

    private AsyncHttpJob exeHttpTask(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        if (asyncHttpParameter == null) {
            return null;
        }
        LeLog.i(TAG, "exeHttpTask  url=" + asyncHttpParameter.in.requestUrl);
        if (TextUtils.isEmpty((CharSequence)asyncHttpParameter.in.requestUrl)) {
            if (asyncHttpRequestListener != null) {
                asyncHttpParameter.out.resultType = 3;
                asyncHttpRequestListener.onRequestResult(asyncHttpParameter);
            }
            return null;
        }
        if (asyncHttpParameter.in.requestMethod == 1) {
            return this.doPostRequest(asyncHttpParameter, asyncHttpRequestListener, bl);
        }
        return this.doGetRequest(asyncHttpParameter, asyncHttpRequestListener, bl);
    }

    public AsyncFileJob exeFileTask(AsyncFileParameter asyncFileParameter, AsyncFileRequestListener asyncFileRequestListener) {
        return this.exeFileTask(asyncFileParameter, asyncFileRequestListener, false);
    }

    public AsyncFileJob exeFileTaskWithoutParallel(AsyncFileParameter asyncFileParameter, AsyncFileRequestListener asyncFileRequestListener) {
        return this.exeFileTask(asyncFileParameter, asyncFileRequestListener, true);
    }

    private AsyncFileJob exeFileTask(AsyncFileParameter asyncFileParameter, AsyncFileRequestListener asyncFileRequestListener, boolean bl) {
        if (asyncFileParameter == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)asyncFileParameter.in.fileUrl)) {
            if (asyncFileRequestListener != null) {
                asyncFileParameter.out.resultType = 3;
                asyncFileRequestListener.onDownloadFinish(asyncFileParameter);
            }
            return null;
        }
        return this.downLoad(asyncFileParameter, asyncFileRequestListener, bl);
    }

    public AsyncUploadFileJob exeUploadFileTask(AsyncUploadFileParameter asyncUploadFileParameter, AsyncUploadFileListener asyncUploadFileListener) {
        return this.exeUploadFileTask(asyncUploadFileParameter, asyncUploadFileListener, false);
    }

    public AsyncUploadFileJob exeUploadFileTaskWithoutParallel(AsyncUploadFileParameter asyncUploadFileParameter, AsyncUploadFileListener asyncUploadFileListener) {
        return this.exeUploadFileTask(asyncUploadFileParameter, asyncUploadFileListener, true);
    }

    private AsyncUploadFileJob exeUploadFileTask(AsyncUploadFileParameter asyncUploadFileParameter, AsyncUploadFileListener asyncUploadFileListener, boolean bl) {
        if (asyncUploadFileParameter == null) {
            return null;
        }
        LeLog.i(TAG, "exeHttpTask  url=" + asyncUploadFileParameter.in.url);
        if (TextUtils.isEmpty((CharSequence)asyncUploadFileParameter.in.url)) {
            if (asyncUploadFileListener != null) {
                asyncUploadFileParameter.out.resultType = 3;
                asyncUploadFileListener.onRequestResult(asyncUploadFileParameter);
            }
            return null;
        }
        return this.upload(asyncUploadFileParameter, asyncUploadFileListener, bl);
    }

    private AsyncHttpJob doGetRequest(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        AsyncHttpJob asyncHttpJob = new AsyncHttpJob(0, asyncHttpParameter, asyncHttpRequestListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncHttpJob, bl);
        return asyncHttpJob;
    }

    private AsyncHttpJob doPostRequest(AsyncHttpParameter asyncHttpParameter, AsyncHttpRequestListener asyncHttpRequestListener, boolean bl) {
        AsyncHttpJob asyncHttpJob = new AsyncHttpJob(1, asyncHttpParameter, asyncHttpRequestListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncHttpJob, bl);
        return asyncHttpJob;
    }

    private AsyncFileJob downLoad(AsyncFileParameter asyncFileParameter, AsyncFileRequestListener asyncFileRequestListener, boolean bl) {
        AsyncFileJob asyncFileJob = new AsyncFileJob(asyncFileParameter, asyncFileRequestListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncFileJob, bl);
        return asyncFileJob;
    }

    private AsyncUploadFileJob upload(AsyncUploadFileParameter asyncUploadFileParameter, AsyncUploadFileListener asyncUploadFileListener, boolean bl) {
        AsyncUploadFileJob asyncUploadFileJob = new AsyncUploadFileJob(asyncUploadFileParameter, asyncUploadFileListener){

            @Override
            protected void onPostExecute(Object object) {
                super.onPostExecute(object);
                AsyncManager.this.releaseTask(this);
            }

            @Override
            protected void onCancelled() {
                super.onCancelled();
                AsyncManager.this.releaseTask(this);
            }
        };
        this.exeTask(asyncUploadFileJob, bl);
        return asyncUploadFileJob;
    }

    public int getTaskSize() {
        return this.mTaskList.size();
    }

    public int getCachedTaskSize() {
        return this.mSemaphoreTaskList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelAllTask() {
        LeLog.i(TAG, "cancelAllTask");
        try {
            for (AsyncTask asyncTask : this.mTaskList) {
                ConcurrentLinkedQueue<AsyncTask> concurrentLinkedQueue = this.mTaskList;
                synchronized (concurrentLinkedQueue) {
                    try {
                        asyncTask.cancel(true);
                    }
                    catch (Throwable throwable) {
                        LeLog.w(TAG, "cancelAllTask waring in cancel asyncTask");
                    }
                }
            }
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        try {
            this.mSemaphore.release(15);
            return;
        }
        catch (Exception exception) {
            LeLog.w(TAG, "release semaphore waring in cancel asyncTask");
        }
    }
}

