/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPHeader;
import com.hpplay.cybergarage.upnp.device.MAN;
import com.hpplay.cybergarage.upnp.device.NT;
import com.hpplay.cybergarage.upnp.device.NTS;
import com.hpplay.cybergarage.upnp.device.ST;
import com.hpplay.cybergarage.upnp.device.USN;
import com.hpplay.cybergarage.upnp.ssdp.SSDP;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class SSDPPacket {
    private DatagramPacket dgmPacket = null;
    private String localAddr = "";
    private long timeStamp;
    public byte[] packetBytes = null;

    public SSDPPacket(byte[] byArray, int n2) {
        this.dgmPacket = new DatagramPacket(byArray, n2);
    }

    public DatagramPacket getDatagramPacket() {
        return this.dgmPacket;
    }

    public void setLocalAddress(String string) {
        this.localAddr = string;
    }

    public String getLocalAddress() {
        return this.localAddr;
    }

    public void setTimeStamp(long l2) {
        this.timeStamp = l2;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public InetAddress getRemoteInetAddress() {
        return this.getDatagramPacket().getAddress();
    }

    public String getRemoteAddress() {
        return this.getDatagramPacket().getAddress().getHostAddress();
    }

    public int getRemotePort() {
        return this.getDatagramPacket().getPort();
    }

    public byte[] getData() {
        if (this.packetBytes != null) {
            return this.packetBytes;
        }
        try {
            DatagramPacket datagramPacket = this.getDatagramPacket();
            int n2 = datagramPacket.getLength();
            String string = new String(datagramPacket.getData(), 0, n2);
            this.packetBytes = string.getBytes();
        }
        catch (Exception exception) {
            CLog.W("SSDPP", exception);
        }
        return this.packetBytes;
    }

    public String getHost() {
        return HTTPHeader.getValue(this.getData(), "HOST");
    }

    public String getCacheControl() {
        return HTTPHeader.getValue(this.getData(), "Cache-Control");
    }

    public String getLocation() {
        return HTTPHeader.getValue(this.getData(), "Location");
    }

    public String getOpt() {
        return HTTPHeader.getValue(this.getData(), "Opt");
    }

    public String getMAN() {
        return HTTPHeader.getValue(this.getData(), "MAN");
    }

    public String getST() {
        return HTTPHeader.getValue(this.getData(), "ST");
    }

    public String getNT() {
        return HTTPHeader.getValue(this.getData(), "NT");
    }

    public String getNTS() {
        return HTTPHeader.getValue(this.getData(), "NTS");
    }

    public String getServer() {
        return HTTPHeader.getValue(this.getData(), "Server");
    }

    public String getUSN() {
        return HTTPHeader.getValue(this.getData(), "USN");
    }

    public int getMX() {
        return HTTPHeader.getIntegerValue(this.getData(), "MX");
    }

    public InetAddress getHostInetAddress() {
        String string = "127.0.0.1";
        String string2 = this.getHost();
        int n2 = string2.lastIndexOf(":");
        if (0 <= n2) {
            string = string2.substring(0, n2);
            if (string.charAt(0) == '[') {
                string = string.substring(1, string.length());
            }
            if (string.charAt(string.length() - 1) == ']') {
                string = string.substring(0, string.length() - 1);
            }
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, 0);
        return inetSocketAddress.getAddress();
    }

    public boolean isRootDevice() {
        if (NT.isRootDevice(this.getNT())) {
            return true;
        }
        if (ST.isRootDevice(this.getST()) || TextUtils.equals((CharSequence)this.getST(), (CharSequence)"urn:schemas-upnp-org:device:MediaRenderer:1")) {
            return true;
        }
        return USN.isRootDevice(this.getUSN());
    }

    public boolean isDiscover() {
        return MAN.isDiscover(this.getMAN());
    }

    public boolean isAlive() {
        return NTS.isAlive(this.getNTS());
    }

    public boolean isByeBye() {
        return NTS.isByeBye(this.getNTS());
    }

    public int getLeaseTime() {
        return SSDP.getLeaseTime(this.getCacheControl());
    }

    public String toString() {
        return new String(this.getData());
    }
}

