/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.browse.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.hpplay.sdk.source.log.SourceLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class BrowserInfo
implements Parcelable {
    private static final String TAG = "BrowserInfo";
    public static final int TYPE_LELINK = 1;
    public static final int TYPE_DLNA = 3;
    public static final int TYPE_IM = 4;
    public static final int CONNECT_TYPE_TCP = 0;
    public static final int CONNECT_TYPE_HTTP = 1;
    public static final int CREATE_TYPE_BROADCAST = 1;
    public static final int CREATE_TYPE_QRCODE = 2;
    public static final int CREATE_TYPE_LOCAL_CACHE = 3;
    public static final int CREATE_TYPE_REMOTE_CACHE = 4;
    public static final int CREATE_TYPE_PIN_CODE = 5;
    public static final int CREATE_TYPE_CONFERENCE = 6;
    public static final int CREATE_TYPE_NFC = 7;
    public static final int CREATE_TYPE_IP_PORT = 8;
    public static final int CREATE_TYPE_SONIC_PIN = 9;
    public static final int CREATE_TYPE_BLUETOOTH_PIN = 10;
    public static final String KEY_NAME = "name";
    public static final String KEY_IP = "ip";
    public static final String KEY_TYPE = "type";
    private static final String KEY_EXTRA = "extras";
    public static final String KEY_PKG_NAME = "packagename";
    public static final String KEY_MAC = "devicemac";
    public static final String KEY_LEBO_FEATURE = "lebofeature";
    public static final String KEY_FEATURE = "feature";
    public static final String KEY_HEIGHT = "h";
    public static final String KEY_WIDTH = "w";
    public static final String KEY_RAOP = "raop";
    public static final String KEY_UID = "u";
    public static final String KEY_AIRPLAY = "airplay";
    public static final String KEY_REMOTE = "remote";
    public static final String KEY_MIRROR = "mirror";
    public static final String KEY_VERSION = "version";
    public static final String KEY_PORT = "port";
    public static final String KEY_LELINK_PORT = "lelinkport";
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_VER = "ver";
    public static final String KEY_APP_INFO = "appInfo";
    public static final String KEY_MANUFACTURER = "manufacturer";
    public static final String KEY_PING_CODE = "pincode";
    public static final String KEY_AGENT_PORT = "agentPort";
    public static final String KEY_PT = "pt";
    public static final String KEY_POL = "pol";
    public static final String KEY_PHONE = "phone";
    public static final String KEY_OMD = "omd";
    public static final String KEY_VV = "vv";
    public static final String KEY_HSTV = "hstv";
    public static final String KEY_ETV = "etv";
    public static final String KEY_ATV = "atv";
    public static final String KEY_HMD = "hmd";
    public static final String KEY_HTV = "htv";
    public static final String KEY_ISCONFERENCE = "isconference";
    public static final String KEY_TUNNELS = "tunnels";
    public static final String KEY_DRAINAGE = "drainage";
    public static final String KEY_DLNA_LOCATION = "dlna_location";
    public static final String KEY_SSDP_PACKET_DATA = "ssdp_packet_data";
    public static final String KEY_DLNA_MODE_NAME = "dlna_mode_name";
    public static final String KEY_DLNA_MODE_DESC = "dlna_mode_desc";
    public static final String KEY_DLNA_UUID = "dln_UUID";
    public static final String KEY_DLNA_UDN_UUID = "dlna_udn_uuid";
    public static final String KEY_DOMAIN = "domain";
    public static final String KEY_REMOTEPORT = "remotePort";
    public static final String KEY_CNAME = "cname";
    public static final String KEY_SSID = "ssid";
    public static final String KEY_DEVICE_NAME = "deviceName";
    public static final String KEY_LANGUAGE = "language";
    public static final String KEY_CREATE_TIME = "createTime";
    public static final String KEY_APP_ID = "a";
    private String uid;
    private String name;
    private String ip;
    private int type;
    private int createType;
    private int port;
    private boolean isOnLine = false;
    private boolean isLocalWifi;
    private Map<String, String> extras;
    public static final Parcelable.Creator<BrowserInfo> CREATOR = new Parcelable.Creator<BrowserInfo>(){

        public BrowserInfo createFromParcel(Parcel parcel) {
            return new BrowserInfo(parcel);
        }

        public BrowserInfo[] newArray(int n2) {
            return new BrowserInfo[n2];
        }
    };

    public BrowserInfo(int n2, int n3) {
        this.type = n2;
        this.createType = n3;
    }

    public BrowserInfo(int n2, JSONObject jSONObject) {
        this.decode(n2, jSONObject);
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getCreateType() {
        return this.createType;
    }

    public int getConnectionType() {
        if (4 == this.type) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public boolean isOnLine() {
        return this.isOnLine;
    }

    public void setOnLine(boolean bl) {
        this.isOnLine = bl;
    }

    public boolean isLocalWifi() {
        return this.isLocalWifi;
    }

    public void setLocalWifi(boolean bl) {
        this.isLocalWifi = bl;
    }

    public Map<String, String> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, String> map) {
        this.extras = map;
    }

    public void decode(int n2, JSONObject jSONObject) {
        if (null != jSONObject) {
            this.uid = jSONObject.optString(KEY_UID);
            this.name = jSONObject.optString(KEY_NAME);
            this.ip = jSONObject.optString(KEY_IP);
            this.port = jSONObject.optInt(KEY_PORT);
            this.type = jSONObject.optInt(KEY_TYPE);
            this.createType = n2;
            JSONObject jSONObject2 = jSONObject.optJSONObject(KEY_EXTRA);
            if (null != jSONObject2 && jSONObject2.length() > 0) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Iterator iterator = jSONObject2.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashMap.put(string, jSONObject2.optString(string));
                }
                this.extras = hashMap;
            }
        }
    }

    public JSONObject encode() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_UID, (Object)this.uid);
            jSONObject.put(KEY_NAME, (Object)this.name);
            jSONObject.put(KEY_IP, (Object)this.ip);
            jSONObject.put(KEY_PORT, this.port);
            jSONObject.put(KEY_TYPE, this.type);
            JSONObject jSONObject2 = new JSONObject();
            if (this.extras != null && !this.extras.isEmpty()) {
                for (String string : this.extras.keySet()) {
                    jSONObject2.put(string, (Object)this.extras.get(string));
                }
                jSONObject.put(KEY_EXTRA, (Object)jSONObject2);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public String toString() {
        return "BrowserInfo{uid='" + this.uid + '\'' + ", name='" + this.name + '\'' + ", ip='" + this.ip + '\'' + ", type=" + this.type + ", createType=" + this.createType + ", port=" + this.port + ", isOnLine=" + this.isOnLine + ", isLocalWifi=" + this.isLocalWifi + ", extras=" + this.extras + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.uid);
        parcel.writeString(this.name);
        parcel.writeString(this.ip);
        parcel.writeInt(this.type);
        parcel.writeInt(this.port);
        parcel.writeInt(this.createType);
        parcel.writeByte(this.isOnLine ? (byte)1 : 0);
        parcel.writeByte(this.isLocalWifi ? (byte)1 : 0);
        parcel.writeInt(this.extras.size());
        for (Map.Entry<String, String> entry : this.extras.entrySet()) {
            parcel.writeString(entry.getKey());
            parcel.writeString(entry.getValue());
        }
    }

    protected BrowserInfo(Parcel parcel) {
        this.uid = parcel.readString();
        this.name = parcel.readString();
        this.ip = parcel.readString();
        this.type = parcel.readInt();
        this.port = parcel.readInt();
        this.createType = parcel.readInt();
        this.isOnLine = parcel.readByte() != 0;
        this.isLocalWifi = parcel.readByte() != 0;
        int n2 = parcel.readInt();
        this.extras = new HashMap<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = parcel.readString();
            String string2 = parcel.readString();
            this.extras.put(string, string2);
        }
    }
}

