/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.LelinkPlayerListenerDispatcher;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.AESUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONObject;

public class LicenseManager {
    private static final String TAG = "LicenseManager";
    private static LicenseManager sInstance = null;
    private int mAuthCode = -1;
    private Date mStartTime = null;
    private Date mEndTime = null;
    private boolean mRequestDone = false;
    private ILicenseCheckListener mListener;
    private AsyncTask mTask;

    private LicenseManager() {
    }

    public static synchronized LicenseManager getInstance() {
        if (sInstance == null) {
            sInstance = new LicenseManager();
        }
        return sInstance;
    }

    public void requestLicense(final Context context) {
        if (this.mTask != null) {
            try {
                this.mTask.cancel(true);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            this.mTask = null;
        }
        final String string = Preference.getInstance().get("key_license_tsn", "");
        final Session session = Session.getInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", session.getUID());
        hashMap.put("appid", session.appKey);
        hashMap.put("token", session.getToken());
        hashMap.put("lbsn", DeviceUtil.getAndroidID(context));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            hashMap.put("tsn", string);
        }
        SourceLog.debug(TAG, "requestLicense " + CloudAPI.sLicenseAuth + "?" + HapplayUtils.getMapParams(hashMap));
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sLicenseAuth, HapplayUtils.getMapParams(hashMap));
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                LicenseManager.this.mTask = null;
                if (asyncHttpParameter.out != null && asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(LicenseManager.TAG, "requestLicense ignore cancel");
                    return;
                }
                int n2 = -1;
                if (asyncHttpParameter != null && asyncHttpParameter.out != null && asyncHttpParameter.out.resultType == 0) {
                    SourceLog.debug(LicenseManager.TAG, "requestLicense result: " + asyncHttpParameter.out.result);
                    String string2 = string;
                    if (TextUtils.isEmpty((CharSequence)string)) {
                        string2 = session.getUID();
                    }
                    n2 = LicenseManager.this.parseLicense(context, asyncHttpParameter.out.result, string2);
                }
                if (!LicenseManager.this.mRequestDone && LicenseManager.this.mListener != null) {
                    LicenseManager.this.mListener.checkLicense(LicenseManager.this.getCheckResult());
                    LicenseManager.this.mListener = null;
                }
                LicenseManager.this.mRequestDone = true;
                if (n2 != 0) {
                    LicenseManager.this.callbackError(n2);
                }
            }
        };
        this.mTask = AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    private void callbackError(int n2) {
        LelinkPlayerListenerDispatcher lelinkPlayerListenerDispatcher = BusinessEntity.getInstance().getListenerDispatcher();
        if (lelinkPlayerListenerDispatcher == null) {
            return;
        }
        int n3 = 213005;
        switch (n2) {
            case 1: {
                n3 = 213001;
                break;
            }
            case 2: {
                n3 = 213002;
                break;
            }
            case 3: {
                n3 = 213003;
                break;
            }
            case 4: {
                n3 = 213004;
                break;
            }
            case -1: {
                n3 = 213005;
            }
        }
        lelinkPlayerListenerDispatcher.onError(null, 213000, n3);
    }

    private int parseLicense(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "parseLicense,json is invalid");
            return -1;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("status");
            if (n2 != 200) {
                SourceLog.w(TAG, "parseLicense, error status :" + n2);
                if (this.getCheckResult()) {
                    return 0;
                }
                return -1;
            }
            JSONObject jSONObject2 = jSONObject.optJSONObject("data");
            if (jSONObject2 == null) {
                SourceLog.w(TAG, "parseLicense, error data");
                return -1;
            }
            int n3 = jSONObject2.optInt("authCode", -1);
            long l2 = jSONObject2.optLong("stime");
            String string3 = jSONObject2.optString("startTime");
            String string4 = jSONObject2.optString("endTime");
            String string5 = jSONObject2.optString("sign");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n3);
            stringBuilder.append(string2);
            stringBuilder.append(context.getPackageName());
            stringBuilder.append(l2);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                stringBuilder.append(string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                stringBuilder.append(string4);
            }
            stringBuilder.append(Session.getInstance().appSecret);
            String string6 = EncryptUtil.encryptMD5ToString(stringBuilder.toString());
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                string6 = string6.toLowerCase();
            }
            if (!TextUtils.isEmpty((CharSequence)string6) && !TextUtils.isEmpty((CharSequence)string5) && string5.equals(string6)) {
                this.updateLicense(n3, string3, string4);
                this.saveLicense(n3, string3, string4);
                return n3;
            }
            SourceLog.w(TAG, "parseLicense, sign wrong:" + string5 + "/" + string6);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "parseLicense,error :" + exception);
        }
        return -1;
    }

    private void saveLicense(int n2, String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("authCode", n2);
            jSONObject.put("startTime", (Object)string);
            jSONObject.put("endTime", (Object)string2);
            String string3 = AESUtils.encrypt(jSONObject.toString());
            Preference.getInstance().put("key_lcs_data", string3);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "saveLicense,error :" + exception);
        }
    }

    private void updateLicense(int n2, String string, String string2) {
        this.mAuthCode = n2;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.mStartTime = null;
            } else {
                if (!string.contains(":")) {
                    string = string.trim() + " 00:00:00";
                }
                this.mStartTime = simpleDateFormat.parse(string);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                this.mEndTime = null;
            } else {
                if (!string2.contains(":")) {
                    string2 = string2.trim() + " 23:59:59";
                }
                this.mEndTime = simpleDateFormat.parse(string2);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "updateLicense,error :" + exception);
        }
    }

    public void readCachedLicense() {
        try {
            String string = Preference.getInstance().get("key_lcs_data", null);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            string = AESUtils.decrypt(string);
            SourceLog.debug(TAG, "getCachedLicense, license :" + string);
            JSONObject jSONObject = new JSONObject(string);
            int n2 = jSONObject.optInt("authCode", -1);
            String string2 = jSONObject.optString("startTime");
            String string3 = jSONObject.optString("endTime");
            this.updateLicense(n2, string2, string3);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "getCachedLicense,error :" + exception);
        }
    }

    public void checkLicense(ILicenseCheckListener iLicenseCheckListener) {
        this.mListener = iLicenseCheckListener;
        boolean bl = this.getCheckResult();
        SourceLog.i(TAG, "checkLicense, mRequestDone :" + this.mRequestDone + ", cachedResult :" + bl);
        if (!this.mRequestDone && !bl) {
            return;
        }
        if (iLicenseCheckListener != null) {
            iLicenseCheckListener.checkLicense(bl);
        }
    }

    private boolean getCheckResult() {
        if (this.mAuthCode != 0) {
            SourceLog.i(TAG, "checkLicense fail, authCode :" + this.mAuthCode);
            return false;
        }
        Date date = new Date();
        if (this.mStartTime != null && !date.after(this.mStartTime)) {
            SourceLog.w(TAG, "checkLicense fail, wrong start time");
            return false;
        }
        if (this.mEndTime != null && !date.before(this.mEndTime)) {
            SourceLog.w(TAG, "checkLicense fail, wrong end time");
            return false;
        }
        return true;
    }

    public static interface ILicenseCheckListener {
        public void checkLicense(boolean var1);
    }
}

