/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import com.hpplay.sdk.source.mdns.MulticastDNSLookupBase;
import com.hpplay.sdk.source.mdns.ServiceInstance;
import com.hpplay.sdk.source.mdns.utils.Wait;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.PTRRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Lookup
extends MulticastDNSLookupBase {
    public Lookup(Name ... nameArray) {
        super(nameArray);
    }

    public Lookup(Name[] nameArray, int n2) {
        super(nameArray, n2);
    }

    public Lookup(Name name, int n2) {
        super(new Name[]{name}, n2);
    }

    public Lookup(Name[] nameArray, int n2, int n3) {
        super(nameArray, n2, n3);
    }

    public Lookup(Name name, int n2, int n3) {
        super(new Name[]{name}, n2, n3);
    }

    public Lookup(String ... stringArray) {
        super(stringArray);
    }

    public Lookup(String string, int n2) {
        super(string, n2);
    }

    public Lookup(String string, int n2, int n3) {
        super(string, n2, n3);
    }

    public Lookup(String[] stringArray, int n2) {
        super(stringArray, n2);
    }

    public Lookup(String[] stringArray, int n2, int n3) {
        super(stringArray, n2, n3);
    }

    protected Lookup() {
    }

    protected Lookup(Message message) {
        super(message);
    }

    @Override
    public void close() {
    }

    public Domain[] lookupDomains() {
        final Set<Domain> set = Collections.synchronizedSet(new HashSet());
        final List list = Collections.synchronizedList(new LinkedList());
        if (this.queries != null && this.queries.length > 0) {
            this.lookupRecordsAsync(new RecordListener(){

                @Override
                public void handleException(Object object, Exception exception) {
                    list.add(exception);
                }

                @Override
                public void receiveRecord(Object object, Record record) {
                    if (record.getTTL() > 0L && record.getType() == 12) {
                        String string = ((PTRRecord)record).getTarget().toString();
                        if (!string.endsWith(".")) {
                            string = string + ".";
                        }
                        try {
                            set.add(new Domain(new Name(string)));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
            });
            Wait.forResponse(set);
        }
        for (Name name : this.searchPath) {
            set.add(new Domain(name));
        }
        return set.toArray(new Domain[set.size()]);
    }

    public Record[] lookupRecords() {
        final ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
        final ConcurrentLinkedQueue concurrentLinkedQueue2 = new ConcurrentLinkedQueue();
        this.lookupRecordsAsync(new ResolverListener(){

            @Override
            public void handleException(Object object, Exception exception) {
                concurrentLinkedQueue2.add(exception);
            }

            @Override
            public void receiveMessage(Object object, Message message) {
                concurrentLinkedQueue.add(message);
            }
        });
        Wait.forResponse(concurrentLinkedQueue);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (Object e2 : concurrentLinkedQueue) {
            Message message = (Message)e2;
            switch (message.getRcode()) {
                case 0: {
                    arrayList.addAll(Arrays.asList(MulticastDNSUtils.extractRecords(message, 1, 2, 3)));
                    break;
                }
            }
        }
        return arrayList.toArray(new Record[arrayList.size()]);
    }

    public Object[] lookupRecordsAsync(final RecordListener recordListener) {
        return this.lookupRecordsAsync(new ResolverListener(){

            @Override
            public void handleException(Object object, Exception exception) {
                recordListener.handleException(object, exception);
            }

            @Override
            public void receiveMessage(Object object, Message message) {
                Record[] recordArray;
                for (Record record : recordArray = MulticastDNSUtils.extractRecords(message, 1, 3, 2)) {
                    recordListener.receiveRecord(object, record);
                }
            }
        });
    }

    public Object[] lookupRecordsAsync(ResolverListener resolverListener) {
        ArrayList arrayList = new ArrayList(this.queries.length);
        for (Message message : this.queries) {
            this.getQuerier().sendAsync(message, resolverListener);
        }
        return arrayList.toArray();
    }

    public ServiceInstance[] lookupServices() {
        ArrayList<ServiceInstance> arrayList = new ArrayList<ServiceInstance>();
        arrayList.addAll(Arrays.asList(this.extractServiceInstances(this.lookupRecords())));
        return arrayList.toArray(new ServiceInstance[arrayList.size()]);
    }

    public static Record[] lookupRecords(Name name) {
        return Lookup.lookupRecords(new Name[]{name}, 255, 255);
    }

    public static Record[] lookupRecords(Name[] nameArray) {
        return Lookup.lookupRecords(nameArray, 255, 255);
    }

    public static Record[] lookupRecords(Name name, int n2) {
        return Lookup.lookupRecords(new Name[]{name}, n2, 255);
    }

    public static Record[] lookupRecords(Name[] nameArray, int n2) {
        return Lookup.lookupRecords(nameArray, n2, 255);
    }

    public static Record[] lookupRecords(Name name, int n2, int n3) {
        return Lookup.lookupRecords(new Name[]{name}, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Record[] lookupRecords(Name[] nameArray, int n2, int n3) {
        try (Lookup lookup = new Lookup(nameArray, n2, n3);){
            Record[] recordArray = lookup.lookupRecords();
            return recordArray;
        }
    }

    public static ServiceInstance[] lookupServices(Name name) {
        return Lookup.lookupServices(new Name[]{name}, 255, 255);
    }

    public static ServiceInstance[] lookupServices(Name[] nameArray) {
        return Lookup.lookupServices(nameArray, 255, 255);
    }

    public static ServiceInstance[] lookupServices(Name name, int n2) {
        return Lookup.lookupServices(new Name[]{name}, n2, 255);
    }

    public static ServiceInstance[] lookupServices(Name[] nameArray, int n2) {
        return Lookup.lookupServices(nameArray, n2, 255);
    }

    public static ServiceInstance[] lookupServices(Name name, int n2, int n3) {
        return Lookup.lookupServices(new Name[]{name}, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceInstance[] lookupServices(Name[] nameArray, int n2, int n3) {
        try (Lookup lookup = new Lookup(nameArray, n2, n3);){
            ServiceInstance[] serviceInstanceArray = lookup.lookupServices();
            return serviceInstanceArray;
        }
    }

    public static interface RecordListener {
        public void handleException(Object var1, Exception var2);

        public void receiveRecord(Object var1, Record var2);
    }

    public static class Domain {
        private final Name name;
        private boolean isDefault;
        private boolean isLegacy;

        protected Domain(Name name) {
            this.name = name;
            byte[] byArray = name.getLabel(0);
            if (byArray != null) {
                switch ((char)byArray[0]) {
                    case 'd': {
                        this.isDefault = true;
                        break;
                    }
                    case 'l': {
                        this.isLegacy = true;
                    }
                }
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (this.name == object) {
                return true;
            }
            if (object instanceof Domain) {
                return this.name.equals(((Domain)object).name);
            }
            return false;
        }

        public Name getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isLegacy() {
            return this.isLegacy;
        }

        public String toString() {
            return this.name + (this.isDefault ? "  [default]" : "") + (this.isLegacy ? "  [legacy]" : "");
        }
    }
}

