/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.MessageInfos;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReceiveMessageThread
extends Thread {
    private static final String TAG = "ReceiveMessageThread";
    private BlockingQueue<MessageInfos> mMsgQueue = new LinkedBlockingQueue<MessageInfos>(20);
    private AtomicBoolean isQuit = new AtomicBoolean();

    public ReceiveMessageThread() {
        this.setName(TAG);
    }

    public synchronized void updateReceiveData(MessageInfos messageInfos) {
        if (!this.isQuit.get()) {
            this.mMsgQueue.offer(messageInfos);
        }
    }

    @Override
    public void run() {
        super.run();
        this.isQuit.set(false);
        while (!this.isQuit.get() && !this.isInterrupted()) {
            try {
                MessageInfos messageInfos = this.mMsgQueue.take();
                ((ResolverListener)messageInfos.getListener().get()).receiveMessage(messageInfos.getIds().get(), (Message)messageInfos.getMessage().get());
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)"=============>>>ReceiveMessageThread InterruptedException exit");
                break;
            }
        }
        Log.i((String)TAG, (String)"=============>>> ReceiveMessageThread exit");
    }

    public synchronized void release() {
        this.isQuit.set(true);
        this.interrupt();
        this.mMsgQueue.clear();
    }
}

