/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.utils;

import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Misc {
    public static final Logger globalLogger = Logger.getLogger("global");

    public static final void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final StringBuilder trimTrailingDot(StringBuilder stringBuilder) {
        for (int i2 = stringBuilder.length() - 1; i2 >= 0; --i2) {
            char c2 = stringBuilder.charAt(i2);
            if (c2 == '.' || Character.isWhitespace(c2)) continue;
            stringBuilder.setLength(i2);
            break;
        }
        return stringBuilder;
    }

    public static final String trimTrailingDot(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.' || Character.isWhitespace(c2)) continue;
            return string.substring(0, i2 + 1);
        }
        return string;
    }

    public static final String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return throwable.getMessage() + "\nStack Trace:\n" + stringWriter.toString();
    }

    public static final String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        for (char c2 : cArray) {
            if (c2 == '\\') {
                bl = true;
                n3 = 2;
                n2 = 0;
                continue;
            }
            if (bl && n3 < 0) {
                bl = false;
                stringBuilder.append((char)n2);
            }
            if (bl) {
                if (Character.isDigit(c2)) {
                    n2 = (int)((double)n2 + (double)(c2 - 48) * Math.pow(10.0, n3));
                }
            } else {
                stringBuilder.append(c2);
            }
            --n3;
        }
        return stringBuilder.toString();
    }

    public static Level setGlobalLogLevel(Level level) {
        Level level2 = globalLogger.getLevel();
        globalLogger.setLevel(Level.FINE);
        return level2;
    }

    public static final Logger getLogger(Class<?> clazz, boolean bl) {
        return Misc.getLogger(clazz.getName(), bl);
    }

    public static final Logger getLogger(String string, boolean bl) {
        Logger logger = Logger.getLogger(string);
        logger.setParent(globalLogger);
        if (bl) {
            logger.setLevel(Level.FINEST);
        }
        return logger;
    }
}

