/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Resolver;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverConfig;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import com.hpplay.sdk.source.mdns.xbill.dns.SimpleResolver;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIG;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 5;
    private List resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    private void init() {
        this.resolvers = new ArrayList();
    }

    public ExtendedResolver() {
        this.init();
        String[] stringArray = ResolverConfig.getCurrentConfig().servers();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                SimpleResolver simpleResolver = new SimpleResolver(stringArray[i2]);
                simpleResolver.setTimeout(5);
                this.resolvers.add(simpleResolver);
            }
        } else {
            this.resolvers.add(new SimpleResolver());
        }
    }

    @Override
    public void setPort(int n2) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setPort(n2);
        }
    }

    @Override
    public void setTCP(boolean bl) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setTCP(bl);
        }
    }

    @Override
    public void setIgnoreTruncation(boolean bl) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setIgnoreTruncation(bl);
        }
    }

    @Override
    public void setEDNS(int n2) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setEDNS(n2);
        }
    }

    @Override
    public void setEDNS(int n2, int n3, int n4, List list) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setEDNS(n2, n3, n4, list);
        }
    }

    @Override
    public void setTSIGKey(TSIG tSIG) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setTSIGKey(tSIG);
        }
    }

    @Override
    public void setTimeout(int n2, int n3) {
        for (int i2 = 0; i2 < this.resolvers.size(); ++i2) {
            ((Resolver)this.resolvers.get(i2)).setTimeout(n2, n3);
        }
    }

    @Override
    public void setTimeout(int n2) {
        this.setTimeout(n2, 0);
    }

    @Override
    public Message send(Message message) {
        Resolution resolution = new Resolution(this, message);
        return resolution.start();
    }

    @Override
    public Object sendAsync(Message message, ResolverListener resolverListener) {
        Resolution resolution = new Resolution(this, message);
        resolution.startAsync(resolverListener);
        return resolution;
    }

    private static class Resolution
    implements ResolverListener {
        Resolver[] resolvers;
        int[] sent;
        Object[] inprogress;
        int retries;
        int outstanding;
        boolean done;
        Message query;
        Message response;
        Throwable thrown;
        ResolverListener listener;

        public Resolution(ExtendedResolver extendedResolver, Message message) {
            List list = extendedResolver.resolvers;
            this.resolvers = list.toArray(new Resolver[list.size()]);
            if (extendedResolver.loadBalance) {
                int n2 = this.resolvers.length;
                int n3 = extendedResolver.lbStart++ % n2;
                if (extendedResolver.lbStart > n2) {
                    extendedResolver.lbStart = n2;
                }
                if (n3 > 0) {
                    Resolver[] resolverArray = new Resolver[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int n4 = (i2 + n3) % n2;
                        resolverArray[i2] = this.resolvers[n4];
                    }
                    this.resolvers = resolverArray;
                }
            }
            this.sent = new int[this.resolvers.length];
            this.inprogress = new Object[this.resolvers.length];
            this.retries = extendedResolver.retries;
            this.query = message;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(int n2) {
            int n3 = n2;
            this.sent[n3] = this.sent[n3] + 1;
            ++this.outstanding;
            try {
                this.inprogress[n2] = this.resolvers[n2].sendAsync(this.query, this);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Resolution resolution = this;
                synchronized (resolution) {
                    this.thrown = throwable2;
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message start() {
            try {
                this.sent[0] = this.sent[0] + 1;
                ++this.outstanding;
                this.inprogress[0] = new Object();
                return this.resolvers[0].send(this.query);
            }
            catch (Exception exception) {
                this.handleException(this.inprogress[0], exception);
                Resolution resolution = this;
                synchronized (resolution) {
                    while (!this.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.response != null) {
                    return this.response;
                }
                if (this.thrown instanceof IOException) {
                    throw (IOException)this.thrown;
                }
                if (this.thrown instanceof RuntimeException) {
                    throw (RuntimeException)this.thrown;
                }
                if (this.thrown instanceof Error) {
                    throw (Error)this.thrown;
                }
                throw new IllegalStateException("ExtendedResolver failure");
            }
        }

        public void startAsync(ResolverListener resolverListener) {
            this.listener = resolverListener;
            this.send(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveMessage(Object object, Message message) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message");
            }
            Resolution resolution = this;
            synchronized (resolution) {
                if (this.done) {
                    return;
                }
                this.response = message;
                this.done = true;
                if (this.listener == null) {
                    this.notifyAll();
                    return;
                }
            }
            this.listener.receiveMessage(this, this.response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleException(Object object, Exception exception) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: got " + exception);
            }
            Resolution resolution = this;
            synchronized (resolution) {
                int n2;
                --this.outstanding;
                if (this.done) {
                    return;
                }
                for (n2 = 0; n2 < this.inprogress.length && this.inprogress[n2] != object; ++n2) {
                }
                if (n2 == this.inprogress.length) {
                    return;
                }
                boolean bl = false;
                if (this.sent[n2] == 1 && n2 < this.resolvers.length - 1) {
                    bl = true;
                }
                if (exception instanceof InterruptedIOException) {
                    if (this.sent[n2] < this.retries) {
                        this.send(n2);
                    }
                    if (this.thrown == null) {
                        this.thrown = exception;
                    }
                } else if (exception instanceof SocketException) {
                    if (this.thrown == null || this.thrown instanceof InterruptedIOException) {
                        this.thrown = exception;
                    }
                } else {
                    this.thrown = exception;
                }
                if (this.done) {
                    return;
                }
                if (bl) {
                    this.send(n2 + 1);
                }
                if (this.done) {
                    return;
                }
                if (this.outstanding == 0) {
                    this.done = true;
                    if (this.listener == null) {
                        this.notifyAll();
                        return;
                    }
                }
                if (!this.done) {
                    return;
                }
            }
            if (!(this.thrown instanceof Exception)) {
                this.thrown = new RuntimeException(this.thrown.getMessage());
            }
            this.listener.handleException(this, (Exception)this.thrown);
        }
    }
}

