/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.Generator;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.RelativeNameException;
import com.hpplay.sdk.source.mdns.xbill.dns.SOARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.TTL;
import com.hpplay.sdk.source.mdns.xbill.dns.Tokenizer;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Master {
    private Name origin;
    private File file;
    private Record last = null;
    private long defaultTTL;
    private Master included = null;
    private Tokenizer st;
    private int currentType;
    private int currentDClass;
    private long currentTTL;
    private boolean needSOATTL;
    private Generator generator;
    private List generators;
    private boolean noExpandGenerate;

    Master(File file, Name name, long l2) {
        if (name == null || name.isAbsolute()) {
            this.file = file;
            this.st = new Tokenizer(file);
            this.origin = name;
            this.defaultTTL = l2;
        }
    }

    public Master(String string, Name name, long l2) {
        this(new File(string), name, l2);
    }

    public Master(String string, Name name) {
        this(new File(string), name, -1L);
    }

    public Master(String string) {
        this(new File(string), (Name)null, -1L);
    }

    public Master(InputStream inputStream, Name name, long l2) {
        if (name != null && !name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        this.st = new Tokenizer(inputStream);
        this.origin = name;
        this.defaultTTL = l2;
    }

    public Master(InputStream inputStream, Name name) {
        this(inputStream, name, -1L);
    }

    public Master(InputStream inputStream) {
        this(inputStream, (Name)null, -1L);
    }

    private Name parseName(String string, Name name) {
        try {
            return Name.fromString(string, name);
        }
        catch (Exception exception) {
            throw this.st.exception(exception.getMessage());
        }
    }

    private void parseTTLClassAndType() {
        String string;
        boolean bl;
        block10: {
            bl = false;
            bl = false;
            string = this.st.getString();
            this.currentDClass = DClass.value(string);
            if (this.currentDClass >= 0) {
                string = this.st.getString();
                bl = true;
            }
            this.currentTTL = -1L;
            try {
                this.currentTTL = TTL.parseTTL(string);
                string = this.st.getString();
            }
            catch (NumberFormatException numberFormatException) {
                if (this.defaultTTL >= 0L) {
                    this.currentTTL = this.defaultTTL;
                }
                if (this.last == null) break block10;
                this.currentTTL = this.last.getTTL();
            }
        }
        if (!bl) {
            this.currentDClass = DClass.value(string);
            if (this.currentDClass >= 0) {
                string = this.st.getString();
            } else {
                this.currentDClass = 1;
            }
        }
        if ((this.currentType = Type.value(string)) < 0) {
            throw this.st.exception("Invalid type '" + string + "'");
        }
        if (this.currentTTL < 0L) {
            if (this.currentType != 6) {
                throw this.st.exception("missing TTL");
            }
            this.needSOATTL = true;
            this.currentTTL = 0L;
        }
    }

    private long parseUInt32(String string) {
        if (!Character.isDigit(string.charAt(0))) {
            return -1L;
        }
        try {
            long l2 = Long.parseLong(string);
            return l2 >= 0L && l2 <= 0xFFFFFFFFL ? l2 : -1L;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    private void startGenerate() {
        String string = this.st.getIdentifier();
        int n2 = string.indexOf("-");
        if (n2 < 0) {
            throw this.st.exception("Invalid $GENERATE range specifier: " + string);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        String string4 = null;
        n2 = string3.indexOf("/");
        if (n2 >= 0) {
            string4 = string3.substring(n2 + 1);
            string3 = string3.substring(0, n2);
        }
        long l2 = this.parseUInt32(string2);
        long l3 = this.parseUInt32(string3);
        long l4 = string4 != null ? this.parseUInt32(string4) : 1L;
        if (l2 >= 0L && l3 >= 0L && l2 <= l3 && l4 > 0L) {
            String string5 = this.st.getIdentifier();
            this.parseTTLClassAndType();
            if (!Generator.supportedType(this.currentType)) {
                throw this.st.exception("$GENERATE does not support " + Type.string(this.currentType) + " records");
            }
            String string6 = this.st.getIdentifier();
            this.st.getEOL();
            this.st.unget();
            this.generator = new Generator(l2, l3, l4, string5, this.currentType, this.currentDClass, this.currentTTL, string6, this.origin);
            if (this.generators == null) {
                this.generators = new ArrayList(1);
            }
        } else {
            throw this.st.exception("Invalid $GENERATE range specifier: " + string);
        }
        this.generators.add(this.generator);
    }

    private void endGenerate() {
        this.st.getEOL();
        this.generator = null;
    }

    private Record nextGenerated() {
        try {
            return this.generator.nextRecord();
        }
        catch (Tokenizer.TokenizerException tokenizerException) {
            throw this.st.exception("Parsing $GENERATE: " + tokenizerException.getBaseMessage());
        }
        catch (Exception exception) {
            throw this.st.exception("Parsing $GENERATE: " + exception.getMessage());
        }
    }

    public Record _nextRecord() {
        Name name;
        Record record;
        if (this.included != null) {
            record = this.included.nextRecord();
            if (record != null) {
                return record;
            }
            this.included = null;
        }
        if (this.generator != null) {
            record = this.nextGenerated();
            if (record != null) {
                return record;
            }
            this.endGenerate();
        }
        while (true) {
            Object object;
            Tokenizer.Token token = this.st.get(true, false);
            if (token.type == 2) {
                object = this.st.get();
                if (((Tokenizer.Token)object).type == 1) continue;
                if (((Tokenizer.Token)object).type == 0) {
                    return null;
                }
                this.st.unget();
                if (this.last == null) {
                    throw this.st.exception("no owner");
                }
                name = this.last.getName();
                break;
            }
            if (token.type == 1) continue;
            if (token.type == 0) {
                return null;
            }
            if (token.value.charAt(0) != '$') {
                object = token.value;
                name = this.parseName((String)object, this.origin);
                if (this.last == null || !name.equals(this.last.getName())) break;
                name = this.last.getName();
                break;
            }
            object = token.value;
            if (((String)object).equalsIgnoreCase("$ORIGIN")) {
                this.origin = this.st.getName(Name.root);
                this.st.getEOL();
                continue;
            }
            if (((String)object).equalsIgnoreCase("$TTL")) {
                this.defaultTTL = this.st.getTTL();
                this.st.getEOL();
                continue;
            }
            if (((String)object).equalsIgnoreCase("$INCLUDE")) {
                File file;
                Object object2;
                String string = this.st.getString();
                if (this.file != null) {
                    object2 = this.file.getParent();
                    file = new File((String)object2, string);
                } else {
                    file = new File(string);
                }
                object2 = this.origin;
                token = this.st.get();
                if (token.isString()) {
                    object2 = this.parseName(token.value, Name.root);
                    this.st.getEOL();
                }
                this.included = new Master(file, (Name)object2, this.defaultTTL);
                return this.nextRecord();
            }
            if (!((String)object).equalsIgnoreCase("$GENERATE")) {
                throw this.st.exception("Invalid directive: " + (String)object);
            }
            if (this.generator != null) {
                throw new IllegalStateException("cannot nest $GENERATE");
            }
            this.startGenerate();
            if (!this.noExpandGenerate) {
                return this.nextGenerated();
            }
            this.endGenerate();
        }
        this.parseTTLClassAndType();
        this.last = Record.fromString(name, this.currentType, this.currentDClass, this.currentTTL, this.st, this.origin);
        if (this.needSOATTL) {
            long l2 = ((SOARecord)this.last).getMinimum();
            this.last.setTTL(l2);
            this.defaultTTL = l2;
            this.needSOATTL = false;
        }
        return this.last;
    }

    public Record nextRecord() {
        Record record = null;
        try {
            record = this._nextRecord();
        }
        finally {
            if (record == null) {
                this.st.close();
            }
        }
        return record;
    }

    public void expandGenerate(boolean bl) {
        this.noExpandGenerate = !bl;
    }

    public Iterator generators() {
        return this.generators != null ? Collections.unmodifiableList(this.generators).iterator() : Collections.EMPTY_LIST.iterator();
    }

    protected void finalize() {
        if (this.st != null) {
            this.st.close();
        }
    }
}

