/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.player;

import android.content.Context;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.player.ICastPlayer;
import com.hpplay.sdk.source.player.listener.OnCompletionListener;
import com.hpplay.sdk.source.player.listener.OnErrorListener;
import com.hpplay.sdk.source.player.listener.OnInfoListener;
import com.hpplay.sdk.source.player.listener.OnLoadingListener;
import com.hpplay.sdk.source.player.listener.OnPreparedListener;
import com.hpplay.sdk.source.player.listener.OnStateChangeListener;
import com.hpplay.sdk.source.player.listener.OnStopListener;
import com.hpplay.sdk.source.protocol.AbsBridge;

public abstract class AbsPlayer
implements ICastPlayer {
    protected Context mContext;
    protected OutParameter mPlayInfo;
    protected AbsBridge mBridge;
    protected int mCurrentState = 0;
    protected OnLoadingListener mLoadingListener;
    protected OnPreparedListener mPreparedListener;
    protected OnStateChangeListener mStateChangeListener;
    protected OnInfoListener mInfoListener;
    protected OnErrorListener mErrorListener;
    protected OnCompletionListener mCompletionListener;
    protected OnStopListener mStopListener;

    public AbsPlayer(Context context) {
        this.mContext = context;
    }

    protected void initListener() {
        this.mBridge.setOnLoadingListener(new OnLoadingListener(){

            @Override
            public void onLoading(ICastPlayer iCastPlayer, String string) {
                AbsPlayer.this.mCurrentState = 1;
                if (AbsPlayer.this.mLoadingListener != null) {
                    AbsPlayer.this.mLoadingListener.onLoading(iCastPlayer, string);
                }
            }
        });
        this.mBridge.setOnPreparedListener(new OnPreparedListener(){

            @Override
            public void onPrepared(ICastPlayer iCastPlayer) {
                AbsPlayer.this.mCurrentState = 2;
                if (AbsPlayer.this.mPreparedListener != null) {
                    AbsPlayer.this.mPreparedListener.onPrepared(AbsPlayer.this);
                }
            }
        });
        this.mBridge.setOnStateChangeListener(new OnStateChangeListener(){

            @Override
            public void onStateChanged(ICastPlayer iCastPlayer, int n2) {
                AbsPlayer.this.mCurrentState = n2;
                if (AbsPlayer.this.mStateChangeListener != null) {
                    AbsPlayer.this.mStateChangeListener.onStateChanged(AbsPlayer.this, n2);
                }
            }
        });
        this.mBridge.setOnInfoListener(new OnInfoListener(){

            @Override
            public void onInfo(ICastPlayer iCastPlayer, int n2, int n3, int n4) {
                if (AbsPlayer.this.mInfoListener != null) {
                    AbsPlayer.this.mInfoListener.onInfo(iCastPlayer, n2, n3, n4);
                }
            }
        });
        this.mBridge.setOnErrorListener(new OnErrorListener(){

            @Override
            public void onError(ICastPlayer iCastPlayer, int n2, int n3, String string) {
                AbsPlayer.this.mCurrentState = -1;
                if (AbsPlayer.this.mErrorListener != null) {
                    AbsPlayer.this.mErrorListener.onError(AbsPlayer.this, n2, n3, string);
                }
            }
        });
        this.mBridge.setOnCompletionListener(new OnCompletionListener(){

            @Override
            public void onComplete(ICastPlayer iCastPlayer) {
                AbsPlayer.this.mCurrentState = 5;
                if (AbsPlayer.this.mCompletionListener != null) {
                    AbsPlayer.this.mCompletionListener.onComplete(AbsPlayer.this);
                }
            }
        });
        this.mBridge.setOnStopListener(new OnStopListener(){

            @Override
            public void onStop(ICastPlayer iCastPlayer, StopInfo stopInfo) {
                AbsPlayer.this.mCurrentState = 6;
                if (AbsPlayer.this.mStopListener != null) {
                    AbsPlayer.this.mStopListener.onStop(AbsPlayer.this, stopInfo);
                }
            }
        });
    }

    protected void removeListener() {
        this.mBridge.setOnLoadingListener(null);
        this.mBridge.setOnPreparedListener(null);
        this.mBridge.setOnStateChangeListener(null);
        this.mBridge.setOnInfoListener(null);
        this.mBridge.setOnErrorListener(null);
        this.mBridge.setOnCompletionListener(null);
        this.mBridge.setOnStopListener(null);
    }

    @Override
    public void setDataSource(OutParameter outParameter) {
        this.mPlayInfo = outParameter;
        this.mBridge.setDataSource(outParameter);
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        return false;
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
    }

    public AbsBridge getBridge() {
        return this.mBridge;
    }

    @Override
    public boolean start(String string) {
        return false;
    }

    @Override
    public boolean pause(String string) {
        return false;
    }

    @Override
    public void onAppPause() {
    }

    @Override
    public void onAppResume() {
    }

    @Override
    public boolean seekTo(String string, int n2) {
        return false;
    }

    @Override
    public void addVolume() {
        this.mBridge.addVolume();
    }

    @Override
    public void subVolume() {
        this.mBridge.subVolume();
    }

    @Override
    public void setVolume(int n2) {
        this.mBridge.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        this.mBridge.selectAudiotrack(n2);
    }

    @Override
    public void stop(String string) {
    }

    @Override
    public boolean playDrama(String string, String string2) {
        return false;
    }

    @Override
    public boolean playNextDrama(String string) {
        return false;
    }

    @Override
    public boolean playPreDrama(String string) {
        return false;
    }

    @Override
    public boolean appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        return false;
    }

    @Override
    public boolean clearPlayList(String string) {
        return false;
    }

    @Override
    public void setOnLoadingListener(OnLoadingListener onLoadingListener) {
        this.mLoadingListener = onLoadingListener;
    }

    @Override
    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        this.mPreparedListener = onPreparedListener;
    }

    @Override
    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mStateChangeListener = onStateChangeListener;
    }

    @Override
    public void setOnInfoListener(OnInfoListener onInfoListener) {
        this.mInfoListener = onInfoListener;
    }

    @Override
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        this.mErrorListener = onErrorListener;
    }

    @Override
    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        this.mCompletionListener = onCompletionListener;
    }

    @Override
    public void setOnStopListener(OnStopListener onStopListener) {
        this.mStopListener = onStopListener;
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
    }
}

