/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.Context;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.KeepAliveUtitls;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class DevicePreChecker
extends Thread {
    private static final String TAG = "DevicePreChecker";
    private final LinkedBlockingQueue<LelinkServiceInfo> mServiceInfos = new LinkedBlockingQueue();
    private final ConcurrentHashMap<String, OnDevicePreCheckResultCallback> mResultMap = new ConcurrentHashMap();
    private boolean isRunning = false;
    public static final int OFFLINE = 0;
    public static final int ALL_ONLINE = 1;
    public static final int ONLY_ONE_ONLINE = 2;
    private Context mContext;
    private long mCheckStartTime;

    public DevicePreChecker(Context context) {
        this.mContext = context;
    }

    public void setOnDevicePreCheckResult(LelinkServiceInfo lelinkServiceInfo, OnDevicePreCheckResultCallback onDevicePreCheckResultCallback) {
        String string = DevicePreChecker.getLelinkServiceKey(lelinkServiceInfo);
        this.mServiceInfos.add(lelinkServiceInfo);
        this.mResultMap.put(string, onDevicePreCheckResultCallback);
    }

    public static String getLelinkServiceKey(LelinkServiceInfo lelinkServiceInfo) {
        return lelinkServiceInfo.getName() + lelinkServiceInfo.getIp();
    }

    @Override
    public void run() {
        super.run();
        this.isRunning = true;
        while (this.isRunning) {
            try {
                boolean bl;
                int n2;
                LelinkServiceInfo lelinkServiceInfo = this.mServiceInfos.take();
                if (lelinkServiceInfo == null) break;
                this.mCheckStartTime = System.currentTimeMillis();
                BrowserInfo browserInfo = null;
                BrowserInfo browserInfo2 = null;
                BrowserInfo browserInfo3 = null;
                try {
                    browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
                    browserInfo2 = lelinkServiceInfo.getBrowserInfos().get(3);
                    browserInfo3 = lelinkServiceInfo.getBrowserInfos().get(4);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                if (browserInfo != null && browserInfo2 != null) {
                    if (NetworkUtil.isWifiConnected(this.mContext)) {
                        n2 = 1;
                    } else {
                        BrowserInfo browserInfo4 = lelinkServiceInfo.getBrowserInfos().get(4);
                        if (browserInfo4 != null && !this.checkIM(browserInfo4)) {
                            lelinkServiceInfo.getBrowserInfos().remove(3);
                            lelinkServiceInfo.getBrowserInfos().remove(1);
                            n2 = 2;
                        } else {
                            n2 = 0;
                        }
                    }
                    this.callback(lelinkServiceInfo, n2);
                    continue;
                }
                if (browserInfo != null) {
                    bl = KeepAliveUtitls.tcpCheckTvState(browserInfo.getName(), browserInfo.getIp(), browserInfo.getPort());
                } else if (browserInfo2 != null) {
                    bl = KeepAliveUtitls.tcpCheckTvState(browserInfo2.getName(), browserInfo2.getIp(), browserInfo2.getPort());
                } else if (browserInfo3 != null) {
                    bl = this.checkIM(browserInfo3);
                } else {
                    this.callback(lelinkServiceInfo, 0);
                    continue;
                }
                n2 = bl ? 1 : 0;
                this.callback(lelinkServiceInfo, n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                break;
            }
        }
        this.isRunning = false;
    }

    private boolean checkIM(BrowserInfo browserInfo) {
        ArrayList<BrowserInfo> arrayList = new ArrayList<BrowserInfo>();
        arrayList.add(browserInfo);
        String string = KeepAliveUtitls.httpPostCheckTvState(arrayList);
        boolean bl = string != null ? string.contains("state:true") : false;
        return bl;
    }

    private void callback(LelinkServiceInfo lelinkServiceInfo, int n2) {
        try {
            SourceLog.i(TAG, "=============> callback use time  " + (System.currentTimeMillis() - this.mCheckStartTime) + " state " + n2);
            String string = DevicePreChecker.getLelinkServiceKey(lelinkServiceInfo);
            OnDevicePreCheckResultCallback onDevicePreCheckResultCallback = this.mResultMap.get(string);
            if (onDevicePreCheckResultCallback != null) {
                onDevicePreCheckResultCallback.onResult(lelinkServiceInfo, n2);
                this.mResultMap.remove(string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void release() {
        this.isRunning = false;
        this.interrupt();
    }

    public static interface OnDevicePreCheckResultCallback {
        public void onResult(LelinkServiceInfo var1, int var2);
    }
}

