/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.VirtualDisplay;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.FileUtil;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.api.ICloudMirrorPlayListener;
import com.hpplay.sdk.source.api.ICommonListener;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.api.IMirrorChangeListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.IRelevantInfoListener;
import com.hpplay.sdk.source.api.ISearchBannerDataCallback;
import com.hpplay.sdk.source.api.ISendPassCallback;
import com.hpplay.sdk.source.api.ISinkKeyEventListener;
import com.hpplay.sdk.source.api.ISinkTouchEventListener;
import com.hpplay.sdk.source.api.IUploadLogQueryListener;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.BrowserConfigBean;
import com.hpplay.sdk.source.bean.DanmakuBean;
import com.hpplay.sdk.source.bean.DanmakuPropertyBean;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.HeicBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.bean.VipAuthSetting;
import com.hpplay.sdk.source.browse.api.AuthListener;
import com.hpplay.sdk.source.browse.api.IAPICallbackListener;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.api.OptionCentral;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.PlayController;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.LicenseManager;
import com.hpplay.sdk.source.business.cloud.RightsManager;
import com.hpplay.sdk.source.business.cloud.SDKConfig;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.da.e;
import com.hpplay.sdk.source.device.Device;
import com.hpplay.sdk.source.device.DeviceCodeResolver;
import com.hpplay.sdk.source.device.ServiceUpdater;
import com.hpplay.sdk.source.localserver.LelinkServerInstance;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.mirror.yim.render.MirrorPlayerActivity;
import com.hpplay.sdk.source.pass.Parser;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.pass.bean.ConnectBean;
import com.hpplay.sdk.source.pass.sinkkey.SinkKeyEventDispatcher;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventDispatcher;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventMonitor;
import com.hpplay.sdk.source.permission.ContextCompat;
import com.hpplay.sdk.source.permission.PermissionBridgeActivity;
import com.hpplay.sdk.source.process.BrowserDispatcher;
import com.hpplay.sdk.source.process.BrowserThread;
import com.hpplay.sdk.source.process.CommonListenerWrapper;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.DevicePreChecker;
import com.hpplay.sdk.source.process.NetworkReceiver;
import com.hpplay.sdk.source.process.OnlineCheckThread;
import com.hpplay.sdk.source.process.OnlineManager;
import com.hpplay.sdk.source.process.PushFailedRetryManager;
import com.hpplay.sdk.source.process.RelationReportTask;
import com.hpplay.sdk.source.process.TimeTickReceiver;
import com.hpplay.sdk.source.protocol.CaptureBridge;
import com.hpplay.sdk.source.protocol.browser.BrowserBridge;
import com.hpplay.sdk.source.protocol.browser.BrowserHistory;
import com.hpplay.sdk.source.protocol.browser.ble.BleProxy;
import com.hpplay.sdk.source.protocol.browser.sonic.SonicProxy;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import com.hpplay.sdk.source.transceiver.bean.NotifyMirrorBean;
import com.hpplay.sdk.source.utils.AppContextUtils;
import com.hpplay.sdk.source.utils.BrowseResultOnlineCheck;
import com.hpplay.sdk.source.utils.BrowserResolver;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CrashHandler;
import com.hpplay.sdk.source.utils.CreateUtil;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.LogUpload;
import com.hpplay.sdk.source.utils.UploadLogCallback;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class LelinkSdkManager {
    private static final String TAG = "LelinkSdkManager";
    private static final int PARSER_TYPE_QR = 1;
    private static final int PARSER_TYPE_PINCODE = 2;
    private static final int PARSER_TYPE_CREATE_LELINK_SERVICE = 3;
    private static final int WHAT_DELAY_NOTIFY_LIST = 1;
    private static final int WHAT_DELETE_HEIC_IMG = 2;
    private static final int WHAT_DELAY_CAST = 3;
    private static final int WHAT_DELAY_DEVICE_OFFLINE = 4;
    private static final int DELAY_NOTIFY_LIST = 500;
    private static final int DELAY_DELETE_HEIC_IMG = 60000;
    private static final int MAX_PLAY_LIST_SIZE = 100;
    private static boolean mIsFirstBrowser = true;
    private static final int DELAY_PUSH_FAILED_RESEARCH_DELAY_TIME = 5000;
    private static LelinkSdkManager sInstance;
    private AtomicBoolean mRetryMirrorOnce = new AtomicBoolean(false);
    private Context mContext;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    LelinkSdkManager.this.notifyBrowseList();
                    break;
                }
                case 2: {
                    SourceLog.i(LelinkSdkManager.TAG, "msg, delete heic img");
                    final String string = (String)message.obj;
                    AsyncManager.getInstance().exeRunnable(new Runnable(){

                        @Override
                        public void run() {
                            File file = new File(string);
                            if (file != null && file.exists()) {
                                file.delete();
                            }
                        }
                    }, null);
                    break;
                }
                case 3: {
                    SourceLog.i(LelinkSdkManager.TAG, "msg, heic img delay cast");
                    HeicBean heicBean = (HeicBean)message.obj;
                    if (heicBean == null) {
                        SourceLog.w(LelinkSdkManager.TAG, "value is invalid");
                        return false;
                    }
                    LelinkSdkManager.this.startPlayMedia(heicBean.lelinkServiceInfo, heicBean.lelinkPlayerInfo, heicBean.path, heicBean.type);
                    break;
                }
                case 4: {
                    if (BusinessEntity.getInstance().getListenerDispatcher() == null) break;
                    OutParameter outParameter = new OutParameter();
                    if (message.obj != null) {
                        outParameter = (OutParameter)message.obj;
                    }
                    BusinessEntity.getInstance().getListenerDispatcher().onError(outParameter, 210010, 210014);
                }
            }
            return false;
        }
    });
    private OnlineCheckThread mOnlineCheckThread;
    public long mAuthSuccessTime = -1L;
    public int mExpireTime = 0;
    private long mPreBrowserTime = 0L;
    private BrowserThread mBrowserThread;
    private BrowserConfigBean mBrowserConfig;
    private long mBrowserTimeStamp = -1L;
    private LelinkPlayerInfo mMirrorPlayInfo;
    private Activity mExpandActivity = null;
    private View mExpandView = null;
    private SecondMirrorView mSecondMirrorView = null;
    private BrowserDispatcher mBrowserDispatcher;
    public ISearchBannerDataCallback mSearchBannerDataCallback;
    private IServiceInfoParseListener mOuterParseListener;
    private IServiceInfoParseListener mOwnerParseListener = new IServiceInfoParseListener(){

        @Override
        public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
            if (LelinkSdkManager.this.mOuterParseListener != null) {
                lelinkServiceInfo = BrowserResolver.updateServiceList(lelinkServiceInfo);
                LelinkSdkManager.this.mOuterParseListener.onParseResult(n2, lelinkServiceInfo);
            }
        }
    };
    private IServiceInfoParseListener mOwnerSonicPinParseListener = new IServiceInfoParseListener(){

        @Override
        public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
            BrowserResolver.updateServiceList(lelinkServiceInfo);
        }
    };
    private IServiceInfoParseListener mOwnerBlueToothListener = new IServiceInfoParseListener(){

        @Override
        public void onParseResult(int n2, LelinkServiceInfo lelinkServiceInfo) {
            BrowserResolver.updateServiceList(lelinkServiceInfo);
        }
    };
    public ICloudMirrorPlayListener mOuterCloudMirrorPlayListener;
    public IRelevantInfoListener mOuterRelevantInfoListener;
    public IMirrorChangeListener mOuterMirrorChangeListener;
    private NetworkReceiver mNetworkChangeReceiver = null;
    private TimeTickReceiver mTimeTickReceiver = null;
    public ISendPassCallback mPassCallback;
    private AuthListener mOuterAuthListener = null;
    private AuthListener mOwnerAuthListener = new AuthListener(){

        @Override
        public void onAuthSuccess(String string, String string2) {
            Session.getInstance().isFirstBoot = false;
            if (LelinkSdkManager.this.mOuterAuthListener != null) {
                LelinkSdkManager.this.mOuterAuthListener.onAuthSuccess(string, string2);
            }
            LelinkSdkManager.this.mAuthSuccessTime = System.currentTimeMillis();
            try {
                JSONObject jSONObject = new JSONObject(string2);
                JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                LelinkSdkManager.this.mExpireTime = jSONObject2.getInt("expire_time");
                SourceLog.i(LelinkSdkManager.TAG, "onAuthSuccess: expireTime =" + LelinkSdkManager.this.mExpireTime);
            }
            catch (Exception exception) {
                SourceLog.w(LelinkSdkManager.TAG, exception);
            }
        }

        @Override
        public void onAuthFailed(int n2) {
            Session.getInstance().isFirstBoot = false;
            if (LelinkSdkManager.this.mOuterAuthListener != null) {
                LelinkSdkManager.this.mOuterAuthListener.onAuthFailed(n2);
            }
        }
    };
    private DevicePreChecker mDevicePreChecker;
    private final ConnectCallback mirrorConnectCallback = new ConnectCallback(){
        OutParameter playInfo;
        LelinkPlayerInfo playerInfo;

        @Override
        public void setInfos(OutParameter outParameter, LelinkPlayerInfo lelinkPlayerInfo, LelinkServiceInfo lelinkServiceInfo) {
            this.playInfo = outParameter;
            this.playerInfo = lelinkPlayerInfo;
        }

        @Override
        public void onConnect(int n2, boolean bl) {
            SourceLog.w(LelinkSdkManager.TAG, "startMirror onConnect group:" + bl);
            this.playInfo.currentBrowserInfo = CastUtil.getPreMirrorInfo(this.playerInfo.getLelinkServiceInfo());
            if (this.playInfo.currentBrowserInfo == null) {
                SourceLog.w(LelinkSdkManager.TAG, "startMirror ignore,invalid browser info:" + this.playerInfo.getLelinkServiceInfo());
                if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                    BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211054);
                }
                return;
            }
            ConnectBean connectBean = Parser.getInstance().getConnectBean(this.playInfo.currentBrowserInfo.getUid());
            if (connectBean != null && connectBean.mirror == -1) {
                SourceLog.w(LelinkSdkManager.TAG, "startMirror ignore, sink not support mirror");
                if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                    BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211052);
                }
                return;
            }
            SourceLog.w(LelinkSdkManager.TAG, "startMirror onConnect");
            this.playInfo.protocol = this.playInfo.currentBrowserInfo.getType();
            this.playInfo.connectProtocol = n2;
            this.playInfo.connectSession = ConnectManager.getInstance().getConnectSession(this.playerInfo.getLelinkServiceInfo());
            if (4 == this.playInfo.protocol) {
                boolean bl2 = RightsManager.getInstance().hasVipFeature(this.playInfo.serviceInfo.getUid(), "LEBO_CLOUDMIRROR_QY");
                boolean bl3 = "develop".equals("lecast") || "happytest".equals("lecast");
                SourceLog.w(LelinkSdkManager.TAG, "startMirror hasVipFeature:" + bl2);
                if (bl2 || bl3) {
                    BusinessEntity.getInstance().dispatch(LelinkSdkManager.this.mContext, this.playInfo, bl);
                } else {
                    SourceLog.w(LelinkSdkManager.TAG, "startMirror igonre, no cloud mirror vip feature");
                    if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                        BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211053);
                    }
                }
            } else {
                BusinessEntity.getInstance().dispatch(LelinkSdkManager.this.mContext, this.playInfo, bl);
            }
        }
    };
    private ConnectCallback pushConnectCallback = new ConnectCallback(){
        OutParameter playInfo;
        LelinkPlayerInfo playerInfo;
        LelinkServiceInfo lelinkServiceInfo;

        @Override
        public void setInfos(OutParameter outParameter, LelinkPlayerInfo lelinkPlayerInfo, LelinkServiceInfo lelinkServiceInfo) {
            this.playInfo = outParameter;
            this.playerInfo = lelinkPlayerInfo;
            this.lelinkServiceInfo = lelinkServiceInfo;
        }

        @Override
        public void onConnect(int n2, boolean bl) {
            this.playInfo.currentBrowserInfo = n2 == 3 ? CastUtil.getPrePushInfoByProtocol(this.lelinkServiceInfo, n2) : CastUtil.getPrePushInfo(this.lelinkServiceInfo);
            if (this.playInfo.currentBrowserInfo == null) {
                SourceLog.w(LelinkSdkManager.TAG, "startPlayMedia ignore,invalid browser info");
                return;
            }
            this.playInfo.protocol = this.playInfo.currentBrowserInfo.getType();
            this.playInfo.connectSession = ConnectManager.getInstance().getConnectSession(this.lelinkServiceInfo);
            BusinessEntity.getInstance().dispatch(LelinkSdkManager.this.mContext, this.playInfo, false);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LelinkSdkManager getInstance() {
        Class<LelinkSdkManager> clazz = LelinkSdkManager.class;
        synchronized (LelinkSdkManager.class) {
            if (sInstance == null) {
                sInstance = new LelinkSdkManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private LelinkSdkManager() {
        this.mBrowserDispatcher = new BrowserDispatcher();
    }

    public void initSDK(Context context, String string, String string2, String string3, String string4, String string5) {
        this.mContext = context;
        if (!Feature.isLeboApp() && !Feature.isDisableCrs(string)) {
            CrashHandler.getInstance().init(this.mContext.getApplicationContext());
        }
        ModuleLinker.getInstance().init(this.mContext, new String[0]);
        AppContextUtils.getInstance().setAppContext(this.mContext);
        SourceLog.i(TAG, "initSDK " + string + "/" + string5);
        Preference.initPreference(this.mContext);
        Session.initSession(this.mContext);
        Session.getInstance().appKey = string;
        Session.getInstance().appSecret = string2;
        Session.getInstance().appVersion = string5;
        Session.getInstance().userID = string3;
        Session.getInstance().oaID = string4;
        DeviceUtil.setOAID(string4);
        PublicCastClient.init(this.mContext.getApplicationContext());
        SourceDataReport.initDataReport(this.mContext.getApplicationContext());
        LelinkServerInstance.getInstance().init(this.mContext.getApplicationContext());
        BrowseResultOnlineCheck.getInstance().setContext(this.mContext.getApplicationContext());
        if (!a.l() && a.n()) {
            LicenseManager.getInstance().readCachedLicense();
        }
        AuthSDK.getInstance().init(this.mContext.getApplicationContext());
        AuthSDK.getInstance().addAuthListener(this.mOwnerAuthListener);
        AuthSDK.getInstance().authSDK();
        if (a.k()) {
            e.d().a(this.mContext);
        }
        this.registerReceiver();
        boolean bl = Preference.getInstance().get("key_enable_log", true);
        this.enableLog(bl);
    }

    private void registerReceiver() {
        IntentFilter intentFilter;
        if (null == this.mNetworkChangeReceiver) {
            this.mNetworkChangeReceiver = new NetworkReceiver();
            intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.wifi.STATE_CHANGE");
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            this.mContext.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, intentFilter);
        }
        if (null == this.mTimeTickReceiver) {
            this.mTimeTickReceiver = new TimeTickReceiver();
            intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.TIME_TICK");
            this.mContext.registerReceiver((BroadcastReceiver)this.mTimeTickReceiver, intentFilter);
        }
    }

    private void unregisterReceiver() {
        if (this.mNetworkChangeReceiver != null) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            this.mNetworkChangeReceiver = null;
        }
        if (this.mTimeTickReceiver != null) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mTimeTickReceiver);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
    }

    public void isDebug(boolean bl) {
        SourceLog.i(TAG, "isDebug," + bl);
        Preference.getInstance().put("key_enable_log", bl);
        this.enableLog(bl);
    }

    private void enableLog(boolean bl) {
        SourceLog.i(TAG, "enableLog," + bl);
        if (this.mContext == null) {
            SourceLog.i(TAG, "enableLog,value is invalid");
            return;
        }
        if (bl) {
            if (Feature.isLeboApp() || Feature.isHappyTest()) {
                SourceLog.enableLogWriter(this.mContext.getApplicationContext(), 100);
            } else {
                SourceLog.enableLogWriter(this.mContext.getApplicationContext(), 1);
            }
        } else if (Feature.isLeboApp() || Feature.isHappyTest()) {
            SourceLog.disableLog(this.mContext.getApplicationContext(), 100);
        } else {
            SourceLog.disableLog(this.mContext.getApplicationContext(), 1);
        }
        CLog.enableTrace(bl);
    }

    public void isDebugTimestamp(boolean bl) {
        Session.getInstance().setDebugTimestamp(bl);
    }

    public void setDebugAVListener(IDebugAVListener iDebugAVListener) {
        Session.getInstance().setDebugAVListener(iDebugAVListener);
    }

    public void setBrowseListener(IBrowseListener iBrowseListener) {
        this.mBrowserDispatcher.setBrowseListener(iBrowseListener);
    }

    public void setRetryBrowseListener(IBrowseListener iBrowseListener) {
        if (this.mBrowserDispatcher != null) {
            this.mBrowserDispatcher.setRetryBrowseListener(iBrowseListener);
        }
    }

    public void setConnectListener(IConnectListener iConnectListener) {
        ConnectManager.getInstance().setConnectListener(iConnectListener);
    }

    public void setPlayerListener(ILelinkPlayerListener iLelinkPlayerListener) {
        BusinessEntity.getInstance().setPlayerListener(iLelinkPlayerListener);
    }

    public void setNewPlayerListener(INewPlayerListener iNewPlayerListener) {
        BusinessEntity.getInstance().setNewPlayerListener(iNewPlayerListener);
    }

    public void setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        BusinessEntity.getInstance().setDaPlayListener(iDaPlayerListener);
    }

    public void setCloudMirrorPlayListener(ICloudMirrorPlayListener iCloudMirrorPlayListener) {
        this.mOuterCloudMirrorPlayListener = iCloudMirrorPlayListener;
    }

    public void startBrowseThread() {
        this.startBrowseThread(this.mBrowserConfig);
    }

    public void startBrowseThread(boolean bl, boolean bl2) {
        BrowserConfigBean browserConfigBean = new BrowserConfigBean();
        browserConfigBean.useLelink = bl;
        browserConfigBean.useDlna = bl2;
        this.startBrowseThread(browserConfigBean);
    }

    public void startBrowseThread(final BrowserConfigBean browserConfigBean) {
        if (mIsFirstBrowser) {
            mIsFirstBrowser = false;
            e.d().a();
        }
        this.checkLicense(new LicenseManager.ILicenseCheckListener(){

            @Override
            public void checkLicense(boolean bl) {
                if (bl) {
                    LelinkSdkManager.this.startBrowseInValidLicense(browserConfigBean);
                } else {
                    SourceLog.w(LelinkSdkManager.TAG, "startBrowseThread ignore, invalid license");
                }
            }
        });
    }

    private void startBrowseInValidLicense(BrowserConfigBean browserConfigBean) {
        if (System.currentTimeMillis() - this.mPreBrowserTime < 200L) {
            SourceLog.w(TAG, "startBrowseThread ignore, space less than 200ms");
            return;
        }
        if (browserConfigBean == null) {
            SourceLog.w(TAG, "startBrowseThread ignore, invalid input");
            return;
        }
        if (this.mBrowserThread == null || !this.mBrowserThread.isAlive()) {
            this.mBrowserThread = new BrowserThread(browserConfigBean);
            this.mBrowserThread.start();
        } else {
            this.mBrowserThread.setConfigBean(browserConfigBean);
        }
        SourceLog.i(TAG, "startBrowseThread " + this.mBrowserThread.isAlive());
        this.mBrowserThread.startBrowse();
        this.mPreBrowserTime = System.currentTimeMillis();
    }

    private void checkLicense(final LicenseManager.ILicenseCheckListener iLicenseCheckListener) {
        if (!a.l()) {
            if (!a.n()) {
                SourceLog.e(TAG, "checkLicense ignore, sdk is not free, do you forget to set permission mode?");
                return;
            }
            LicenseManager.getInstance().checkLicense(new LicenseManager.ILicenseCheckListener(){

                @Override
                public void checkLicense(boolean bl) {
                    iLicenseCheckListener.checkLicense(bl);
                }
            });
        } else {
            iLicenseCheckListener.checkLicense(true);
        }
    }

    public void browse(BrowserConfigBean browserConfigBean) {
        if (browserConfigBean == null) {
            SourceLog.w(TAG, "browse ignore");
            return;
        }
        this.mBrowserConfig = browserConfigBean;
        if (!this.canDisableDLNA()) {
            browserConfigBean.useDlna = true;
        }
        SourceLog.i(TAG, "browse " + browserConfigBean.useLelink + "/" + browserConfigBean.useDlna);
        int n2 = 3;
        if (browserConfigBean.useLelink && browserConfigBean.useDlna) {
            n2 = 3;
        } else if (browserConfigBean.useLelink) {
            n2 = 1;
        } else if (browserConfigBean.useDlna) {
            n2 = 2;
        }
        this.clearBrowserList();
        BrowserBridge.getInstance().setBrowserListener(this.mBrowserDispatcher);
        BrowserBridge.getInstance().startBrowse(this.mContext, n2);
        BrowserHistory.getInstance().startLocalBrowser(n2);
        if (browserConfigBean.useSonic) {
            this.sonicBrowse();
        }
        if (browserConfigBean.useBLE) {
            this.bleBrowse();
        }
        this.mBrowserDispatcher.browser();
        this.mBrowserTimeStamp = System.currentTimeMillis();
        RelationReportTask.getInstance().report(this.mContext, this.mBrowserTimeStamp, this.mBrowserTimeStamp + 30000L, SDKConfig.getInstance().getSearchOutTime() * 1000);
        CastUtil.printSDKInfo();
    }

    public BrowserConfigBean getBrowserConfig() {
        return this.mBrowserConfig;
    }

    private void sonicBrowse() {
        if (SonicProxy.canStartSonicBrowse(this.mContext)) {
            SonicProxy.setServiceInfoParseListener(this.mOwnerSonicPinParseListener);
            if (SonicProxy.startBrowse(this.mContext)) {
                BrowserHistory.getInstance().startSonicBrowser();
            }
        } else {
            SourceLog.w(TAG, "browse has no permission to use sonic");
        }
    }

    private void bleBrowse() {
        if (1 == a.f(this.mContext)) {
            SourceLog.i(TAG, "bleBrowse");
            BleProxy.setServiceInfoParseListener(this.mOwnerBlueToothListener);
            if (BleProxy.startBrowse(this.mContext)) {
                BrowserHistory.getInstance().startBLEBrowser();
            }
        } else {
            SourceLog.i(TAG, "bleBrowse ignore");
        }
        if (1 != a.e(this.mContext)) {
            SourceDataReport.getInstance().onBlePublish(0, null);
            return;
        }
        if (!PublicCastClient.getInstance().isConnectedServer()) {
            PublicCastClient.getInstance().connectServer(CloudAPI.sImServer, com.hpplay.sdk.source.d.a.a(), null);
        } else {
            SourceLog.i(TAG, "bleBrowse startPublish");
            BleProxy.startPublish(this.mContext, Preference.getInstance().get("key_device_id"));
        }
        ServiceUpdater.getInstance().updateServiceInfo(this.mContext);
    }

    private boolean canDisableDLNA() {
        return Feature.isMUIChannel() || Feature.isKangka() || Feature.isOPPOChannel() || Feature.isVivoChannel() || Feature.isSmartis() || Feature.isNubiaChannel() || Feature.isYoulexueChannel() || Feature.isLeboApp() || Feature.isHuaweiChannel() || Feature.isHappyTest();
    }

    public void stopBrowseThread() {
        this.stopBrowseThread(true);
    }

    public void stopBrowseThread(boolean bl) {
        if (this.mBrowserThread != null && System.currentTimeMillis() - this.mPreBrowserTime > 200L) {
            this.mBrowserThread.stopBrowser();
        }
        if (bl) {
            this.mBrowserDispatcher.notifyBrowserStop();
        }
    }

    public void stopBrowse() {
        SourceLog.i(TAG, "stopBrowse");
        RelationReportTask.getInstance().stopBrowser();
        BrowserBridge.getInstance().stopBrowse();
        if (SonicProxy.canStartSonicBrowse(this.mContext)) {
            SonicProxy.stopBrowse(this.mContext);
        }
        if (a.e(this.mContext) == 1) {
            BleProxy.stopPublish(this.mContext);
        }
        if (a.f(this.mContext) == 1) {
            BleProxy.stopBrowse(this.mContext);
        }
        this.mBrowserDispatcher.stopBrowser();
        ServiceUpdater.getInstance().updateServiceInfo(this.mContext);
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "connect info:" + lelinkServiceInfo.getName());
        final LelinkServiceInfo lelinkServiceInfo2 = this.findSameServiceInfo(lelinkServiceInfo);
        if (lelinkServiceInfo2 == null) {
            return;
        }
        boolean bl = false;
        if (!CastUtil.isSupportMultiChannel(lelinkServiceInfo)) {
            bl = ConnectManager.getInstance().checkOnline(lelinkServiceInfo2, new OnlineManager.OnlineListener(){

                @Override
                public void OnLineCheckResult(LelinkServiceInfo lelinkServiceInfo, boolean bl) {
                    if (bl) {
                        ConnectManager.getInstance().connect(LelinkSdkManager.this.mContext, lelinkServiceInfo2, CastUtil.isSupportMultiChannel(lelinkServiceInfo2));
                    } else {
                        ConnectManager.getInstance().notifyInvalid(lelinkServiceInfo);
                    }
                }
            });
        }
        if (!bl) {
            ConnectManager.getInstance().connect(this.mContext, lelinkServiceInfo2, CastUtil.isSupportMultiChannel(lelinkServiceInfo2));
        }
    }

    public List<LelinkServiceInfo> getConnectInfos() {
        return ConnectManager.getInstance().getConnections();
    }

    public boolean disconnect(LelinkServiceInfo lelinkServiceInfo) {
        lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo);
        SourceLog.i(TAG, "disconnect " + lelinkServiceInfo);
        BusinessEntity.getInstance().stop(1005);
        BusinessEntity.getInstance().release();
        ConnectManager.getInstance().disconnect(lelinkServiceInfo);
        return true;
    }

    public void addVolume() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.addVolume();
    }

    public void subVolume() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.subVolume();
    }

    public void setVolume(int n2) {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.setVolume(n2);
    }

    public void selectAudiotrack(int n2) {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.selectAudiotrack(n2);
    }

    public void resume() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.resume();
    }

    public void pause() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.pause();
    }

    public void seekTo(int n2) {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        businessEntity.seekTo(n2);
    }

    public void startExpandMirror(LelinkPlayerInfo lelinkPlayerInfo) {
        if (lelinkPlayerInfo == null) {
            SourceLog.w(TAG, "startExpandMirror ignore,LelinkPlayerInfo is null");
            return;
        }
        if (!a.f()) {
            SourceLog.w(TAG, "startExpandMirror ignore,mirror not support");
            return;
        }
        if (this.isMirroring()) {
            OutParameter outParameter = BusinessEntity.getInstance().getCurrentPlayInfo();
            if (lelinkPlayerInfo != null && lelinkPlayerInfo.getLelinkServiceInfo() != null && outParameter != null && outParameter.serviceInfo != null && outParameter.serviceInfo.equals(lelinkPlayerInfo.getLelinkServiceInfo())) {
                SourceLog.i(TAG, "startExpandMirror is mirroring now, use switchExpansionScreen");
                this.switchExpansionScreen(true);
                return;
            }
        }
        this.mRetryMirrorOnce.set(false);
        this.startMirror(lelinkPlayerInfo, true);
    }

    public void setExpansionScreenInfo(Activity activity, View view) {
        SourceLog.i(TAG, "setExpansionScreenInfo " + activity + " / " + view);
        this.mExpandActivity = activity;
        this.mExpandView = view;
    }

    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        this.mSecondMirrorView = secondMirrorView;
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            SourceLog.w(TAG, "setSecondMirrorView ignore 2 ");
            return;
        }
        SourceLog.i(TAG, "setSecondMirrorView " + secondMirrorView);
        playController.getPlayInfo().secondMirrorView = this.mSecondMirrorView;
        playController.setSecondMirrorView(secondMirrorView);
    }

    public void switchExpansionScreen(boolean bl) {
        if ((this.mExpandActivity == null || this.mExpandView == null) && bl) {
            SourceLog.w(TAG, "switchExpansionScreen ignore");
            return;
        }
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            SourceLog.w(TAG, "switchExpansionScreen ignore 2 " + bl);
            return;
        }
        SourceLog.i(TAG, "switchExpansionScreen " + bl);
        playController.getPlayInfo().expandActivity = this.mExpandActivity;
        playController.getPlayInfo().expandView = this.mExpandView;
        playController.switchExpansionScreen(bl);
    }

    public void stopExpandMirror() {
        this.stopPlay();
        SourceLog.flushLogWriter();
    }

    public AtomicBoolean getRetryMirrorOnce() {
        return this.mRetryMirrorOnce;
    }

    public void startMirror(LelinkPlayerInfo lelinkPlayerInfo) {
        this.mMirrorPlayInfo = lelinkPlayerInfo;
        this.mRetryMirrorOnce.set(false);
        this.startMirror(lelinkPlayerInfo, false);
    }

    private void startMirror(LelinkPlayerInfo lelinkPlayerInfo, boolean bl) {
        boolean bl2;
        if (!a.e()) {
            SourceLog.w(TAG, "startMirror ignore,system not support");
            if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211004);
            }
            return;
        }
        if (!a.f()) {
            SourceLog.w(TAG, "startMirror ignore,mirror not support");
            if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211051);
            }
            return;
        }
        LelinkServiceInfo lelinkServiceInfo = this.findSameServiceInfo(lelinkPlayerInfo.getLelinkServiceInfo());
        if (lelinkServiceInfo != null) {
            lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
        }
        if (lelinkServiceInfo != null && !CastUtil.isSinkSupportMirror(lelinkServiceInfo)) {
            SourceLog.w(TAG, "startMirror ignore,mirror not support 2");
            if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211052);
            }
            return;
        }
        this.mMirrorPlayInfo = lelinkPlayerInfo;
        boolean bl3 = bl2 = OptionCentral.isExternalVideo() || Preference.getInstance().get("is_system_app", false);
        if (bl2) {
            this.startMirror(null, lelinkPlayerInfo, bl);
            return;
        }
        try {
            Intent intent = new Intent(this.mContext, PermissionBridgeActivity.class);
            if (lelinkPlayerInfo.isClearActivityTaskWhenStartMirror()) {
                intent.setFlags(0x10008000);
            } else {
                intent.setFlags(0x10000000);
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("is_expand", bl);
            bundle.putInt("permission_type", 3);
            bundle.putParcelable("player_info", (Parcelable)lelinkPlayerInfo);
            intent.putExtras(bundle);
            this.mContext.startActivity(intent);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void startMirror(Intent intent, LelinkPlayerInfo lelinkPlayerInfo, boolean bl) {
        LelinkPlayerInfo lelinkPlayerInfo2;
        if (!a.f()) {
            SourceLog.w(TAG, "startMirror ignore,mirror not support");
            return;
        }
        LelinkPlayerInfo lelinkPlayerInfo3 = lelinkPlayerInfo;
        if (lelinkPlayerInfo == null) {
            lelinkPlayerInfo3 = this.mMirrorPlayInfo;
        }
        if ((lelinkPlayerInfo2 = lelinkPlayerInfo3) == null) {
            SourceLog.w(TAG, "startMirror ignore,invalid playerInfo");
            if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211054);
            }
            return;
        }
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        OutParameter outParameter = new OutParameter();
        outParameter.castType = 2;
        outParameter.mimeType = 102;
        outParameter.mirrorIntent = intent;
        if (lelinkPlayerInfo2.getLelinkServiceInfo() == null) {
            outParameter.serviceInfo = ConnectManager.getInstance().getLastServiceInfo();
        } else {
            LelinkServiceInfo lelinkServiceInfo = this.findSameServiceInfo(lelinkPlayerInfo2.getLelinkServiceInfo());
            lelinkPlayerInfo2.setLelinkServiceInfo(lelinkServiceInfo);
            outParameter.serviceInfo = lelinkServiceInfo;
        }
        if (outParameter.serviceInfo == null) {
            SourceLog.w(TAG, "startMirror ignore,invalid service info");
            if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211054);
            }
            return;
        }
        SourceLog.i(TAG, "startMirror " + outParameter.serviceInfo.getName() + " / " + lelinkPlayerInfo2.getMirrorSendTimeout());
        outParameter.mirrorResLevel = lelinkPlayerInfo2.getResolutionLevel();
        outParameter.mirrorBitRateLevel = lelinkPlayerInfo2.getBitRateLevel();
        outParameter.mirrorAudioType = lelinkPlayerInfo2.getMirrorAudioType();
        outParameter.requestAudioFocus = lelinkPlayerInfo2.isRequestAudioFocus();
        outParameter.fullScreenType = lelinkPlayerInfo2.getFullScreen();
        outParameter.isAutoBitrate = lelinkPlayerInfo2.isAutoBitrate();
        outParameter.session = CreateUtil.createSessionId();
        outParameter.urlID = CreateUtil.createMirrorUri();
        outParameter.mirrorSendTimeout = lelinkPlayerInfo2.getMirrorSendTimeout();
        outParameter.isExpandMirror = bl;
        if (bl) {
            if (this.mExpandActivity == null || this.mExpandView == null) {
                SourceLog.w(TAG, "startMirror ExpansionScreen ignore");
                if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                    BusinessEntity.getInstance().getListenerDispatcher().onError(null, 211000, 211054);
                }
                return;
            }
            outParameter.expandActivity = this.mExpandActivity;
            outParameter.expandView = this.mExpandView;
            outParameter.secondMirrorView = this.mSecondMirrorView;
        }
        outParameter.isGroup = CastUtil.isSupportMultiChannel(outParameter.serviceInfo);
        outParameter.password = lelinkPlayerInfo2.getCastPwd();
        this.mirrorConnectCallback.setInfos(outParameter, lelinkPlayerInfo2, null);
        this.checkDevice(outParameter.serviceInfo, this.mirrorConnectCallback, outParameter.isGroup);
        CastUtil.printSDKInfo();
    }

    public void startRenderCloudMirror(String string, String string2, String string3, String string4) {
        if (!a.d()) {
            SourceLog.w(TAG, "startRenderCloudMirror ignore, cloud mirror not support");
            return;
        }
        Intent intent = new Intent(this.mContext, MirrorPlayerActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("session", string3);
        intent.putExtra("uri", string4);
        intent.putExtra("room_id_key", string);
        intent.putExtra("uid_key", string2);
        this.mContext.startActivity(intent);
    }

    private void startGetSDCardPermission(Context context, LelinkServiceInfo lelinkServiceInfo, String string, LelinkPlayerInfo lelinkPlayerInfo, int n2) {
        Intent intent = new Intent(context, PermissionBridgeActivity.class);
        intent.setFlags(0x10000000);
        Bundle bundle = new Bundle();
        bundle.putInt("permission_type", 2);
        bundle.putString("url", string);
        bundle.putInt("mime_type", n2);
        bundle.putParcelable("service_info", (Parcelable)lelinkServiceInfo);
        if (lelinkPlayerInfo != null) {
            bundle.putParcelable("player_info", (Parcelable)lelinkPlayerInfo);
        }
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    public void createPreChecker() {
        if (this.mDevicePreChecker != null && !this.mDevicePreChecker.isRunning()) {
            this.mDevicePreChecker.release();
            this.mDevicePreChecker = null;
        }
        if (this.mDevicePreChecker == null) {
            this.mDevicePreChecker = new DevicePreChecker(this.mContext);
            this.mDevicePreChecker.start();
        }
    }

    public void startPlayCheck(LelinkPlayerInfo lelinkPlayerInfo) {
        if (lelinkPlayerInfo == null) {
            SourceLog.w(TAG, "startPlayMedia ignore, invalid player info");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)lelinkPlayerInfo.getUrl()) || !TextUtils.isEmpty((CharSequence)lelinkPlayerInfo.getLocalPath()) || lelinkPlayerInfo.getLoaclUri() != null) {
            this.createPreChecker();
            if (lelinkPlayerInfo.getLelinkServiceInfo() != null) {
                SourceLog.i(TAG, " new device start check ");
                lelinkPlayerInfo.setLelinkServiceInfo(lelinkPlayerInfo.getLelinkServiceInfo());
                this.mDevicePreChecker.setOnDevicePreCheckResult(lelinkPlayerInfo.getLelinkServiceInfo(), new DevicePreCheckCallback(lelinkPlayerInfo));
            } else if (ConnectManager.getInstance().getLastServiceInfo() != null) {
                SourceLog.i(TAG, " connected device start check ");
                this.mDevicePreChecker.setOnDevicePreCheckResult(ConnectManager.getInstance().getLastServiceInfo(), new DevicePreCheckCallback(lelinkPlayerInfo));
            } else {
                this.startPlay(lelinkPlayerInfo);
            }
        } else {
            SourceLog.e(TAG, "startPlayMedia ignore, invalid url");
        }
    }

    private LelinkServiceInfo getPlayServiceInfo(LelinkPlayerInfo lelinkPlayerInfo) {
        LelinkServiceInfo lelinkServiceInfo = lelinkPlayerInfo.getLelinkServiceInfo();
        if (lelinkServiceInfo == null) {
            LelinkServiceInfo lelinkServiceInfo2 = ConnectManager.getInstance().getLastServiceInfo();
            if (lelinkServiceInfo2 == null) {
                SourceLog.w(TAG, "startPlayMedia ignore ,there has no valid service info");
                return null;
            }
            SourceLog.w(TAG, "startPlayMedia has no service info, use last connect service info " + lelinkServiceInfo2.getName() + "/" + lelinkServiceInfo2.getIp());
            lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo2);
            lelinkServiceInfo = lelinkServiceInfo2;
        } else {
            lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo);
            lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
        }
        return lelinkServiceInfo;
    }

    private void startPlay(LelinkPlayerInfo lelinkPlayerInfo) {
        LelinkServiceInfo lelinkServiceInfo = this.getPlayServiceInfo(lelinkPlayerInfo);
        if (lelinkServiceInfo == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)lelinkPlayerInfo.getLocalPath())) {
            this.startPlayMedia(lelinkServiceInfo, lelinkPlayerInfo, lelinkPlayerInfo.getLocalPath(), lelinkPlayerInfo.getType(), true);
        } else if (lelinkPlayerInfo.getLocalUri() != null) {
            this.startPlayMedia(lelinkServiceInfo, lelinkPlayerInfo, lelinkPlayerInfo.getLocalUri().toString(), lelinkPlayerInfo.getType(), true);
        } else {
            this.startPlayMedia(lelinkServiceInfo, lelinkPlayerInfo, lelinkPlayerInfo.getUrl(), lelinkPlayerInfo.getType(), false);
        }
    }

    public void startPlayMedia(LelinkServiceInfo lelinkServiceInfo, String string, int n2, boolean bl) {
        this.startPlayMedia(lelinkServiceInfo, null, string, n2, bl);
    }

    public void startPlayMedia(LelinkServiceInfo lelinkServiceInfo, final LelinkPlayerInfo lelinkPlayerInfo, String string, final int n2, boolean bl) {
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "startPlayMedia ignore, invalid service info");
            return;
        }
        lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo);
        if (bl && ContextCompat.checkSelfPermission(this.mContext, "android.permission.READ_EXTERNAL_STORAGE") == -1) {
            SourceLog.i(TAG, " not permission ");
            this.startGetSDCardPermission(this.mContext, lelinkServiceInfo, string, lelinkPlayerInfo, n2);
            return;
        }
        if (bl) {
            if (n2 == 103 && Build.VERSION.SDK_INT >= 28 && !TextUtils.isEmpty((CharSequence)string) && (string.endsWith(".heic") || string.endsWith(".HEIC"))) {
                SourceLog.i(TAG, "startPlayMedia,is heic local photo");
                final String string2 = string;
                final LelinkServiceInfo lelinkServiceInfo2 = lelinkServiceInfo;
                AsyncManager.getInstance().exeRunnable(new Runnable(){

                    @Override
                    public void run() {
                        HeicBean heicBean = new HeicBean();
                        heicBean.lelinkServiceInfo = lelinkServiceInfo2;
                        heicBean.lelinkPlayerInfo = lelinkPlayerInfo;
                        heicBean.path = LelinkSdkManager.this.heicChangeToJpeg(string2, lelinkPlayerInfo.getParams());
                        heicBean.type = n2;
                        Message message = LelinkSdkManager.this.mHandler.obtainMessage();
                        message.what = 3;
                        message.obj = heicBean;
                        LelinkSdkManager.this.mHandler.sendMessage(message);
                    }
                }, null);
                return;
            }
            string = LelinkServerInstance.getInstance().getFileDownloadUrl(string, lelinkPlayerInfo.getParams());
        }
        this.startPlayMedia(lelinkServiceInfo, lelinkPlayerInfo, string, n2);
    }

    private String heicChangeToJpeg(String string, String string2) {
        String string3 = LelinkServerInstance.getInstance().getHeicToJpegPath(string);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            string = string3;
            Message message = this.mHandler.obtainMessage();
            message.what = 2;
            message.obj = string3;
            this.mHandler.sendMessageDelayed(message, 60000L);
        }
        return LelinkServerInstance.getInstance().getFileDownloadUrl(string, string2);
    }

    private void startPlayMedia(LelinkServiceInfo lelinkServiceInfo, LelinkPlayerInfo lelinkPlayerInfo, String string, int n2) {
        OutParameter outParameter = this.getOutParameter(lelinkServiceInfo, lelinkPlayerInfo, string, n2);
        if (outParameter == null) {
            return;
        }
        this.pushConnectCallback.setInfos(outParameter, lelinkPlayerInfo, lelinkServiceInfo);
        this.checkDevice(outParameter.serviceInfo, this.pushConnectCallback, false);
        CastUtil.printSDKInfo();
        SourceLog.i(TAG, "startPlayMedia " + outParameter.getPlayUrl());
    }

    private OutParameter getOutParameter(LelinkServiceInfo lelinkServiceInfo, LelinkPlayerInfo lelinkPlayerInfo, String string, int n2) {
        OutParameter outParameter = new OutParameter();
        outParameter.setUrl(string);
        if (lelinkPlayerInfo != null) {
            outParameter.urls = lelinkPlayerInfo.getUrlList();
            outParameter.period = lelinkPlayerInfo.getPeriod();
            outParameter.headLength = lelinkPlayerInfo.getHeadDuration();
            outParameter.tailLength = lelinkPlayerInfo.getTailDuration();
            outParameter.dramaID = lelinkPlayerInfo.getDramaID();
            if (outParameter.urls != null && outParameter.urls.length > 0 && (TextUtils.isEmpty((CharSequence)outParameter.dramaID) || outParameter.urls.length > 100)) {
                if (BusinessEntity.getInstance().getListenerDispatcher() != null) {
                    BusinessEntity.getInstance().getListenerDispatcher().onError(null, 210000, 100000);
                }
                return null;
            }
        }
        SourceLog.i(TAG, "startPlayMedia " + outParameter.getPlayUrl());
        outParameter.mimeType = n2;
        outParameter.castType = 1;
        outParameter.serviceInfo = lelinkServiceInfo;
        if (lelinkPlayerInfo != null) {
            outParameter.playerInfoBean = lelinkPlayerInfo.getPlayInfoBean();
            outParameter.mediaAssetBean = lelinkPlayerInfo.getMediaAsset();
            outParameter.microAppInfoBean = lelinkPlayerInfo.getMicroAppInfoBean();
            outParameter.startPosition = lelinkPlayerInfo.getStartPosition();
            if (outParameter.mediaAssetBean != null) {
                outParameter.duration = (int)outParameter.mediaAssetBean.getDuration();
            }
            outParameter.password = lelinkPlayerInfo.getCastPwd();
            outParameter.retryDLNAHttp = lelinkPlayerInfo.isRetryDLNAHttp();
        }
        outParameter.urlID = CreateUtil.createPushUri(outParameter.getPlayUrl());
        outParameter.session = CreateUtil.createSessionId();
        return outParameter;
    }

    private void checkDevice(LelinkServiceInfo lelinkServiceInfo, final ConnectCallback connectCallback, final boolean bl) {
        lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo);
        boolean bl2 = false;
        if (!bl) {
            bl2 = ConnectManager.getInstance().checkOnline(lelinkServiceInfo, new OnlineManager.OnlineListener(){

                @Override
                public void OnLineCheckResult(LelinkServiceInfo lelinkServiceInfo, boolean bl2) {
                    if (bl2) {
                        LelinkSdkManager.this.checkConnect(lelinkServiceInfo, connectCallback, bl);
                    } else {
                        ConnectManager.getInstance().notifyInvalid(lelinkServiceInfo);
                    }
                }
            });
        }
        if (!bl2) {
            this.checkConnect(lelinkServiceInfo, connectCallback, bl);
        }
    }

    private void checkConnect(LelinkServiceInfo lelinkServiceInfo, ConnectCallback connectCallback, boolean bl) {
        if (lelinkServiceInfo == null) {
            SourceLog.w(TAG, "checkConnect ignore, serviceInfo is null");
            return;
        }
        SourceLog.w(TAG, "checkConnect " + bl);
        if (ConnectManager.getInstance().getConnectSession(lelinkServiceInfo, bl) != null) {
            SourceLog.i(TAG, "checkConnect: connect inner " + lelinkServiceInfo.getName() + "/" + lelinkServiceInfo.getIp());
            ConnectManager.getInstance().resetLastConnectBridge(lelinkServiceInfo);
            int n2 = ConnectManager.getInstance().getConnectProtocol(lelinkServiceInfo);
            SourceLog.i(TAG, "connectProtocol : " + n2);
            if (n2 != -1) {
                SourceLog.i(TAG, " do onConnect callback : " + n2);
                connectCallback.onConnect(n2, bl);
                return;
            }
            SourceLog.i(TAG, "checkConnect: has no valid protocol " + lelinkServiceInfo.getName() + "/" + lelinkServiceInfo.getIp());
            ConnectManager.getInstance().removeBridge(lelinkServiceInfo);
            SourceLog.i(TAG, "checkConnect: connect inner " + lelinkServiceInfo.getName() + "/" + lelinkServiceInfo.getIp());
        }
        ConnectManager.getInstance().setConnectCheckListener(new CheckConnectListener(connectCallback, bl));
        ConnectManager.getInstance().connect(this.mContext, lelinkServiceInfo, bl);
    }

    public void setLogCallback(ILogCallback iLogCallback) {
        Session.getInstance().setLogCallback(iLogCallback);
    }

    public void setSearchBannerDataCallback(ISearchBannerDataCallback iSearchBannerDataCallback) {
        this.mSearchBannerDataCallback = iSearchBannerDataCallback;
    }

    public void setMirrorChangeListener(IMirrorChangeListener iMirrorChangeListener) {
        this.mOuterMirrorChangeListener = iMirrorChangeListener;
    }

    public void setCommonListener(ICommonListener iCommonListener) {
        CommonListenerWrapper.getInstance().setCommonListener(iCommonListener);
    }

    public Object getOption(int n2, Object ... objectArray) {
        ConnectBridge connectBridge = ConnectManager.getInstance().getLastConnectBridge();
        switch (n2) {
            case 1048629: {
                SourceLog.i(TAG, "OPTION_35");
                if (connectBridge != null && connectBridge.isSupportPassMsg(12)) {
                    return 0;
                }
                return -1;
            }
            case 1048631: {
                SourceLog.i(TAG, "OPTION_37");
                if (connectBridge != null && connectBridge.isSupportPassMsg(15)) {
                    return 0;
                }
                return -1;
            }
            case 1048675: {
                SourceLog.i(TAG, "OPTION_63");
                if (connectBridge != null && connectBridge.isSupportPassMsg(6)) {
                    return 0;
                }
                return -1;
            }
            case 1048626: {
                return this.getPlayState();
            }
            case 0x200003: {
                SourceLog.flushLogWriter();
                return SourceLog.getLogDir();
            }
            case 0x200007: {
                try {
                    LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)objectArray[0];
                    if (lelinkServiceInfo == null) {
                        return -1;
                    }
                    boolean bl = CastUtil.isSupportMultiChannel(lelinkServiceInfo);
                    return bl ? 0 : -1;
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                    return -1;
                }
            }
            case 0x200008: {
                if (connectBridge != null && connectBridge.isSupportUrlList()) {
                    return 0;
                }
                return -1;
            }
            case 2097177: {
                if (connectBridge != null && connectBridge.isSupportTrack()) {
                    return 0;
                }
                return -1;
            }
            case 2097173: {
                try {
                    LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)objectArray[0];
                    if (lelinkServiceInfo == null) {
                        return -1;
                    }
                    if (connectBridge != null && connectBridge.isSupportPassMsg(31)) {
                        return 0;
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                return -1;
            }
            case 2097175: {
                if (connectBridge != null && connectBridge.isSupportPassMsg(36)) {
                    return 0;
                }
                return -1;
            }
            case 0x200029: {
                return String.valueOf(this.isMirroring());
            }
        }
        return -1;
    }

    public int getPlayState() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        return businessEntity.getCurrentPlayState();
    }

    private boolean isMirroring() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            return false;
        }
        OutParameter outParameter = playController.getPlayInfo();
        if (outParameter == null) {
            return false;
        }
        int n2 = this.getPlayState();
        return outParameter.castType == 2 && (n2 == 1 || n2 == 5 || n2 == 11);
    }

    private boolean isPushing() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        PlayController playController = businessEntity.getCurrentPlayController();
        if (playController == null) {
            return false;
        }
        return playController.isInPlaybackState();
    }

    public void stopPlay() {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        if (businessEntity != null) {
            businessEntity.stop(1000);
        }
        SourceLog.flushLogWriter();
    }

    public void stopPlayWithCallback(int n2) {
        BusinessEntity businessEntity = BusinessEntity.getInstance();
        if (businessEntity != null) {
            businessEntity.stopWithCallback(n2);
        }
        SourceLog.flushLogWriter();
    }

    public void setServiceInfoParseListener(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mOuterParseListener = iServiceInfoParseListener;
    }

    public void addQRCodeToLelinkServiceInfo(final String string) {
        SourceLog.i(TAG, "addQRCodeToLelinkServiceInfo " + string);
        this.checkLicense(new LicenseManager.ILicenseCheckListener(){

            @Override
            public void checkLicense(boolean bl) {
                if (bl) {
                    BrowserHistory.getInstance().startQRBrowser();
                    Device.addQRLelinkServiceInfo(string, LelinkSdkManager.this.mOwnerParseListener);
                } else {
                    SourceLog.w(LelinkSdkManager.TAG, "addQRCodeToLelinkServiceInfo ignore, invalid license");
                }
            }
        });
    }

    public void addPinCodeToLelinkServiceInfo(final String string) {
        SourceLog.i(TAG, "addPinCodeToLelinkServiceInfo " + string);
        this.checkLicense(new LicenseManager.ILicenseCheckListener(){

            @Override
            public void checkLicense(boolean bl) {
                if (bl) {
                    BrowserHistory.getInstance().startPinCodeBrowser();
                    Device.addPinCodeServiceInfo(LelinkSdkManager.this.mContext, string, LelinkSdkManager.this.mOwnerParseListener);
                } else {
                    SourceLog.w(LelinkSdkManager.TAG, "addPinCodeToLelinkServiceInfo ignore, invalid license");
                }
            }
        });
    }

    public void createLelinkServiceInfo(SinkParameterBean sinkParameterBean) {
        SourceLog.i(TAG, "createLelinkServiceInfo " + sinkParameterBean);
        if (sinkParameterBean == null) {
            return;
        }
        if (sinkParameterBean.createType == SinkParameterBean.CREATE_BY_SINK_SERVER) {
            Device.createBySinkServer(sinkParameterBean.ip, sinkParameterBean.port, this.mOwnerParseListener);
            return;
        }
        Device.createLelinkServiceInfo(sinkParameterBean, this.mOwnerParseListener);
    }

    public void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        Device.createPinCode(iCreatePinCodeListener);
    }

    public void createShortUrl(ICreateShortUrlListener iCreateShortUrlListener) {
        Device.createShortUrl(iCreateShortUrlListener);
    }

    public void multiMirrorControl(boolean bl, List<LelinkServiceInfo> list) {
        if (bl) {
            this.addCloudMirrorDevice(list);
        }
    }

    public void addCloudMirrorDevice(List<LelinkServiceInfo> list) {
    }

    public VirtualDisplay getVirtualDisplay() {
        return CaptureBridge.getInstance().getVirtualDisplay();
    }

    public void setOption(int n2, Object ... objectArray) {
        switch (n2) {
            case 100: 
            case 10000: {
                if (objectArray[0] == null || !(objectArray[0] instanceof String) || objectArray[1] == null || !(objectArray[1] instanceof String) || objectArray[2] == null) break;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("data", objectArray[0]);
                    jSONObject.put("manifestVer", 1);
                    jSONObject.put("appID", objectArray[1]);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                boolean bl = Boolean.parseBoolean(String.valueOf(objectArray[2]));
                PassSender.getInstance().sendPass(n2, jSONObject.toString(), bl);
                break;
            }
            case 22: {
                PassSender.getInstance().sendVIPQuery(objectArray[0].toString());
                break;
            }
            case 65541: {
                Object object = objectArray[0];
                if (!(object instanceof Boolean)) break;
                Session.getInstance().isFilter501Version = (Boolean)object;
                break;
            }
            case 65543: {
                this.release();
                break;
            }
            case 0x100011: {
                this.setConferenceServerUrl(objectArray);
                break;
            }
            case 0x100012: {
                this.setStaffInfo(objectArray);
                break;
            }
            case 1048611: {
                this.setConferenceBrowseListener(objectArray);
                break;
            }
            case 1048612: {
                break;
            }
            case 1048629: {
                JSONObject jSONObject = new JSONObject();
                try {
                    float f2 = Float.parseFloat(objectArray[0] + "");
                    jSONObject.put("manifestVer", 1);
                    jSONObject.put("rate", (double)f2);
                    PassSender.getInstance().playRate(jSONObject.toString());
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 1048631: {
                PassSender.getInstance().queryRate();
                break;
            }
            case 0x100041: {
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                Preference.getInstance().put("key_uuid", string);
                Preference.getInstance().put("key_session", string2);
                SourceLog.i(TAG, "vip info " + string + "  " + string2);
                if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
                    RightsManager.getInstance().logout();
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string)) break;
                VipAuthSetting vipAuthSetting = new VipAuthSetting();
                vipAuthSetting.uuid = string;
                vipAuthSetting.ssid = string2;
                RightsManager.getInstance().loginVipAuth(vipAuthSetting);
                break;
            }
            case 0x100044: {
                try {
                    int n3 = Integer.parseInt((String)objectArray[0]);
                    int n4 = Integer.parseInt((String)objectArray[1]);
                    int n5 = Integer.parseInt((String)objectArray[2]);
                    Preference.getInstance().put("maxbitrate", n3);
                    Preference.getInstance().put("minbitrate", n4);
                    Preference.getInstance().put("framebitrate", n5);
                    if (objectArray.length <= 3) break;
                    int n6 = Integer.parseInt(objectArray[3].toString());
                    int n7 = Integer.parseInt(objectArray[4].toString());
                    Preference.getInstance().put("c_mirror_width", n6);
                    Preference.getInstance().put("c_mirror_height", n7);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 1048648: {
                Preference.getInstance().put("key_username", (String)objectArray[0]);
                break;
            }
            case 1048649: {
                boolean bl = Boolean.parseBoolean(objectArray[0].toString());
                if (bl) {
                    this.uploadLogQuery();
                }
                this.enableLog(bl);
                break;
            }
            case 0x100050: {
                break;
            }
            case 0x100051: {
                AuthSDK.getInstance().authSDK();
                break;
            }
            case 1048659: {
                String string = "";
                String string3 = "";
                try {
                    string = (String)objectArray[0];
                    string3 = (String)objectArray[1];
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                this.uploadLog(string, string3);
                break;
            }
            case 0x100061: {
                OptionCentral.changeExternalAudioState(Boolean.parseBoolean((String)objectArray[0]));
                break;
            }
            case 1048675: {
                if (objectArray == null || objectArray[0] == null) break;
                try {
                    OutParameter outParameter = BusinessEntity.getInstance().getCurrentPlayInfo();
                    if (outParameter == null) {
                        SourceLog.i(TAG, "danmaku ignore");
                        return;
                    }
                    String string = null;
                    if (objectArray[0] instanceof String) {
                        JSONObject jSONObject = new JSONObject((String)objectArray[0]);
                        jSONObject.put("manifestVer", 1);
                        jSONObject.put("uri", (Object)outParameter.urlID);
                        string = jSONObject.toString();
                    } else if (objectArray[0] instanceof DanmakuBean) {
                        DanmakuBean danmakuBean = (DanmakuBean)objectArray[0];
                        string = danmakuBean.toJson(outParameter.urlID, 1);
                    }
                    SourceLog.i(TAG, "danmaku json body :" + string);
                    PassSender.getInstance().sendDanmu(string);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 1048676: {
                if (objectArray == null || objectArray.length <= 0 || !(objectArray[0] instanceof DanmakuPropertyBean)) break;
                DanmakuPropertyBean danmakuPropertyBean = (DanmakuPropertyBean)objectArray[0];
                PassSender.getInstance().setDanmuProperty(danmakuPropertyBean.toString());
                break;
            }
            case 0x100066: {
                if (!this.canReverseControl()) {
                    return;
                }
                OptionCentral.registerOrUnregisterSinkKeyEvent(Boolean.parseBoolean((String)objectArray[0]));
                break;
            }
            case 1048679: {
                if (!this.canReverseControl()) {
                    return;
                }
                OptionCentral.registerOrUnregisterSinkTouchEvent(Boolean.parseBoolean((String)objectArray[0]));
                break;
            }
            case 1179652: {
                if (objectArray == null || objectArray.length <= 3 || !(objectArray[0] instanceof String) || !(objectArray[1] instanceof String) || !(objectArray[2] instanceof String) || !(objectArray[3] instanceof String)) break;
                String string = (String)objectArray[0];
                String string4 = (String)objectArray[1];
                String string5 = (String)objectArray[2];
                String string6 = (String)objectArray[3];
                this.startRenderCloudMirror(string, string4, string5, string6);
                break;
            }
            case 1179656: {
                Activity activity = (Activity)objectArray[0];
                View view = (View)objectArray[1];
                this.setExpansionScreenInfo(activity, view);
                break;
            }
            case 1179657: {
                BusinessEntity.getInstance().onAppPause();
                break;
            }
            case 0x120010: {
                BusinessEntity.getInstance().onAppResume();
                break;
            }
            case 1048680: {
                PassSender.getInstance().sendShortVideoList(objectArray[0].toString());
                break;
            }
            case 0x200001: {
                OptionCentral.setExternalVideo(Boolean.parseBoolean(objectArray[0].toString()));
                break;
            }
            case 0x200002: {
                try {
                    String string = objectArray[0].toString();
                    BrowserConfigBean browserConfigBean = BrowserConfigBean.formJSON(string);
                    SourceLog.i(TAG, "OPTION_BROWSER " + browserConfigBean);
                    if (browserConfigBean == null) break;
                    this.startBrowseThread(browserConfigBean);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 0x200004: {
                Preference.getInstance().put("key_multi_channel", objectArray[0].toString());
                break;
            }
            case 0x200005: {
                try {
                    int n8 = Integer.parseInt(objectArray[0].toString());
                    if (n8 == 4) {
                        BusinessEntity.getInstance().switchYim();
                        break;
                    }
                    if (n8 == 1) {
                        BusinessEntity.getInstance().switchLelink();
                        break;
                    }
                    SourceLog.w(TAG, "OPTION_CHANGE_MIRROR invalid protocol:" + n8);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 0x200006: {
                try {
                    this.createLelinkServiceInfo(SinkParameterBean.formJson(objectArray[0].toString()));
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 1179654: {
                String string = (String)objectArray[0];
                SourceLog.i(TAG, "OPTION_SUPER_DEVICE_ID " + string);
                Preference.getInstance().put("super_device_id", string);
                RightsManager.getInstance().vipAuth();
                break;
            }
            case 0x200009: {
                BusinessEntity businessEntity = BusinessEntity.getInstance();
                businessEntity.playDrama(objectArray[0].toString());
                break;
            }
            case 0x2000010: {
                BusinessEntity.getInstance().playNextDrama();
                break;
            }
            case 0x2000011: {
                BusinessEntity.getInstance().playPreDrama();
                break;
            }
            case 0x200012: {
                int n9 = 1;
                try {
                    n9 = Integer.parseInt(objectArray[0].toString());
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                SourceLog.i(TAG, "OPTION_OVERLAY_PERMISSION enable:" + n9);
                Preference.getInstance().put("key_request_window_permiss", n9 != 0);
                break;
            }
            case 2097171: {
                PassSender.getInstance().sendMicroPass(objectArray[0].toString(), "", Integer.parseInt(objectArray[1].toString()));
                break;
            }
            case 2097172: {
                PassSender.getInstance().sendStopMicro("", Integer.parseInt(objectArray[0].toString()));
                break;
            }
            case 2097174: {
                OutParameter outParameter = BusinessEntity.getInstance().getCurrentPlayInfo();
                if (outParameter == null) {
                    SourceLog.i(TAG, "danmaku ignore");
                    return;
                }
                try {
                    int n10 = Integer.parseInt(objectArray[0].toString());
                    this.selectAudiotrack(n10);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 2097175: {
                try {
                    if (this.isMirroring() || this.isPushing()) {
                        PassSender.getInstance().sendTempRestrict("", Boolean.parseBoolean(objectArray[0].toString()));
                        break;
                    }
                    SourceLog.i(TAG, "sendTempRestrict ignore, try again when casting");
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 2097176: {
                boolean bl = true;
                try {
                    bl = Boolean.parseBoolean(objectArray[0].toString());
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                SourceLog.i(TAG, "OPTION_MIRROR_NOTIFICATION enable:" + bl);
                Preference.getInstance().put("mirror_notification", bl);
                break;
            }
            case 0x200020: {
                Session.getInstance().disableIM(Boolean.parseBoolean(objectArray[0].toString()));
                break;
            }
            case 0x200021: {
                String string = null;
                if (objectArray[0] instanceof String) {
                    string = (String)objectArray[0];
                }
                this.setWatermarkInfo(string);
                break;
            }
            case 0x200022: {
                LelinkSdkManager.getInstance().setWatermarkVisible(Boolean.parseBoolean(objectArray[0].toString()));
                break;
            }
            case 0x200023: {
                CommonListenerWrapper.getInstance().registerListener(objectArray);
                break;
            }
            case 0x200024: {
                CommonListenerWrapper.getInstance().unRegisterListener(objectArray);
                break;
            }
            case 0x200025: {
                PassSender.getInstance().sendNotifyMirrorMsg(NotifyMirrorBean.formJSON(objectArray[0].toString()));
                break;
            }
            case 0x200026: {
                PassSender.getInstance().sendNotifyRemoteMsg(objectArray[0].toString(), Integer.parseInt(objectArray[1].toString()), Integer.parseInt(objectArray[2].toString()));
                break;
            }
            case 0x200027: {
                if (a.l()) {
                    SourceLog.w(TAG, "OPTION_PERMISSION_MODE ignore, sdk is free");
                    return;
                }
                try {
                    int n11 = Integer.parseInt(objectArray[0].toString());
                    SourceLog.i(TAG, "OPTION_PERMISSION_MODE mode:" + n11);
                    Preference.getInstance().put("key_permission_mode", n11);
                    if (n11 != 1) break;
                    if (objectArray.length > 1) {
                        Preference.getInstance().put("key_license_tsn", objectArray[1].toString());
                    }
                    LicenseManager.getInstance().requestLicense(this.mContext);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, "OPTION_PERMISSION_MODE :" + exception);
                }
                break;
            }
            case 0x200028: {
                LelinkSdkManager.getInstance().setMirrorScreenSecret(Boolean.parseBoolean(objectArray[0].toString()));
                break;
            }
            case 0x200030: {
                if (objectArray.length <= 1) break;
                CaptureBridge.getInstance().setRotation(Integer.parseInt(objectArray[0].toString()), Boolean.parseBoolean(objectArray[1].toString()));
                break;
            }
            case 0x200032: {
                int n12 = 0;
                try {
                    n12 = Integer.parseInt(objectArray[0].toString());
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                SourceLog.i(TAG, "OPTION_MIRROR_NOTIFY_TYPE :" + n12);
                Preference.getInstance().put("mirror_notify_type", n12);
                break;
            }
            case 2097201: {
                try {
                    CaptureBridge.getInstance().setDisplayReuse(Boolean.parseBoolean(objectArray[0].toString()));
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                break;
            }
            case 0x200033: {
                try {
                    CaptureBridge.getInstance().resize(Integer.parseInt(objectArray[0].toString()));
                    break;
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
        }
    }

    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (dramaInfoBeanArray == null || dramaInfoBeanArray.length > 100) {
            SourceLog.w(TAG, "appendPlayList values ignore");
            return;
        }
        BusinessEntity.getInstance().appendPlayList(dramaInfoBeanArray, n2, n3, n4);
    }

    public void clearPlayList() {
        BusinessEntity.getInstance().clearPlayList();
    }

    public void setWatermarkInfo(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.w(TAG, "setWatermarkInfo values ignore");
            return;
        }
        Preference.getInstance().put("mirror_watermark_obj_json_str", string);
    }

    public void setWatermarkVisible(boolean bl) {
        SourceLog.i(TAG, "setWatermarkVisible isVisible:" + bl);
        Preference.getInstance().put("mirror_watermark_switch", bl);
        BusinessEntity.getInstance().setWatermarkVisible(bl);
    }

    public void setMirrorScreenSecret(boolean bl) {
        SourceLog.i(TAG, "setMirrorScreenSecret status:" + bl);
        Preference.getInstance().put("mirror_secret_switch", bl);
        BusinessEntity.getInstance().setMirrorScreenSecret(bl);
    }

    public void startOnlineCheck(IAPICallbackListener iAPICallbackListener, List<LelinkServiceInfo> list) {
        try {
            if (iAPICallbackListener != null && list != null && (this.mOnlineCheckThread == null || this.mOnlineCheckThread.isCompletion())) {
                this.mOnlineCheckThread = new OnlineCheckThread(iAPICallbackListener, list);
                this.mOnlineCheckThread.start();
                return;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceLog.w(TAG, "setInteractListener values is Invalid");
    }

    public void uploadLog(String string, String string2) {
        String string3 = CreateUtil.createEid();
        LogUpload.uploadLogFile(this.mContext, CloudAPI.sLogReportUrl, null, string3, string, string2, new UploadLogCallback(){

            @Override
            public void uploadStatus(int n2) {
                SourceLog.i(LelinkSdkManager.TAG, "uploadStatus i =" + n2);
                LelinkSdkManager.this.uploadLogStatus(n2);
            }
        });
        LelinkServiceInfo lelinkServiceInfo = ConnectManager.getInstance().getLastServiceInfo();
        if (lelinkServiceInfo == null) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
            jSONObject.put("manifestVer", 1);
            jSONObject.put("euqid", (Object)string3);
            jSONObject.put("et", (Object)string);
            PassSender.getInstance().syncLogReport(lelinkServiceInfo, jSONObject.toString());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void uploadLogQuery() {
        SourceLog.w(TAG, "uploadLogQuery");
        LogUpload.uploadLogFileQuery(this.mContext, new IUploadLogQueryListener(){

            @Override
            public void onQueryResult(String string) {
                try {
                    SourceLog.w(LelinkSdkManager.TAG, "log query result = " + string);
                    JSONObject jSONObject = new JSONObject(string);
                    int n2 = jSONObject.optInt("code");
                    String string2 = jSONObject.optString("msg");
                    int n3 = jSONObject.optInt("report_err");
                    int n4 = jSONObject.optInt("eid");
                    if (n2 == 200 && n3 != 0) {
                        LogUpload.uploadLogFile(LelinkSdkManager.this.mContext, CloudAPI.sLogReportUrl, n4 + "", null, "", "", null);
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(LelinkSdkManager.TAG, exception);
                }
            }

            @Override
            public void onError() {
                SourceLog.w(LelinkSdkManager.TAG, "uploadLogQuery error");
            }
        });
    }

    private void uploadLogStatus(int n2) {
        int n3 = -1;
        switch (n2) {
            case 200: {
                n3 = 1;
                break;
            }
            case 202: {
                n3 = -1;
                break;
            }
            case 400: {
                n3 = 2;
                break;
            }
            case 405: {
                n3 = 4;
                break;
            }
            case 406: {
                n3 = 3;
            }
        }
        if (this.mOuterRelevantInfoListener != null) {
            this.mOuterRelevantInfoListener.onReverseInfoResult(1179655, n3 + "");
        }
    }

    private void setConferenceServerUrl(Object[] objectArray) {
        if (objectArray.length < 1) {
            SourceLog.i(TAG, "setConferenceServerUrl need more parameter");
            return;
        }
        SourceLog.i(TAG, "setConferenceServerUrl: " + objectArray[0]);
        Object object = objectArray[0];
        if (object instanceof String) {
            String string = object.toString();
            if (string.startsWith("http")) {
                if (string.endsWith("/")) {
                    int n2 = string.lastIndexOf("/");
                    CloudAPI.sConferenceRoot = string.substring(0, n2);
                } else {
                    CloudAPI.sConferenceRoot = string;
                }
                CloudAPI.updateDynamicUrls();
            }
            return;
        }
        SourceLog.w(TAG, "setConferenceServerUrl values is Invalid");
    }

    private void setStaffInfo(Object[] objectArray) {
        if (objectArray.length < 2) {
            SourceLog.i(TAG, "setStaffInfo need more parameter");
            return;
        }
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        SourceLog.i(TAG, "setStaffInfo value0:" + object + " value1:" + object2);
        if (object instanceof String && object2 instanceof String) {
            Session.getInstance().department = (String)object;
            Session.getInstance().jobNumber = (String)object2;
        }
    }

    private void setConferenceBrowseListener(Object[] objectArray) {
        SourceLog.i(TAG, "LEBO_OPTION_23 value: " + objectArray[0]);
    }

    public boolean canPlayScreen(LelinkServiceInfo lelinkServiceInfo) {
        if ((lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo)) == null) {
            return false;
        }
        Integer[] integerArray = lelinkServiceInfo.getProtocols();
        if (integerArray == null || integerArray.length <= 0) {
            return false;
        }
        for (Integer n2 : integerArray) {
            if (n2 != 1 && (n2 != 4 || !Feature.hasCloudMirror())) continue;
            return true;
        }
        return false;
    }

    public boolean canPlayLocalMedia(LelinkServiceInfo lelinkServiceInfo) {
        if ((lelinkServiceInfo = this.findSameServiceInfo(lelinkServiceInfo)) == null) {
            return false;
        }
        Integer[] integerArray = lelinkServiceInfo.getProtocols();
        if (integerArray == null || integerArray.length <= 0) {
            return false;
        }
        for (Integer n2 : integerArray) {
            if (n2 != 1 && n2 != 3) continue;
            return true;
        }
        return false;
    }

    public void updateAudioData(byte[] byArray, AudioFrameBean audioFrameBean) {
        OptionCentral.updateAudioData(byArray, audioFrameBean);
    }

    public void updateVideoData(byte[] byArray, VideoFrameBean videoFrameBean) {
        OptionCentral.updateVideoData(byArray, videoFrameBean);
    }

    public void setSinkKeyEventListener(final ISinkKeyEventListener iSinkKeyEventListener) {
        if (iSinkKeyEventListener == null) {
            return;
        }
        if (!this.canReverseControl()) {
            SourceLog.w(TAG, "setSinkKeyEventListener ignore, this channel not support this feature");
            return;
        }
        SourceLog.i(TAG, "setSinkKeyEventListener " + iSinkKeyEventListener);
        SinkKeyEventDispatcher.getInstance().setSinkKeyEventListener(new ISinkKeyEventListener(){

            @Override
            public void onKeyEvent(final KeyEvent keyEvent) {
                LelinkSdkManager.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iSinkKeyEventListener.onKeyEvent(keyEvent);
                    }
                });
            }
        });
    }

    public void setSinkTouchEventListener(SinkTouchEventArea sinkTouchEventArea, float f2, final ISinkTouchEventListener iSinkTouchEventListener) {
        if (iSinkTouchEventListener == null) {
            return;
        }
        if (!this.canReverseControl()) {
            SourceLog.w(TAG, "setSinkTouchEventListener ignore, this channel not support this feature");
            return;
        }
        SourceLog.i(TAG, "setSinkTouchEventListener " + iSinkTouchEventListener);
        SinkTouchEventMonitor.getInstance().setTouchEventArea(sinkTouchEventArea);
        SinkTouchEventMonitor.getInstance().setTouchScaleModulus(f2);
        SinkTouchEventDispatcher.getInstance().setSinkTouchEventListener(new ISinkTouchEventListener(){

            @Override
            public void onTouchEvent(final MotionEvent motionEvent) {
                LelinkSdkManager.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        iSinkTouchEventListener.onTouchEvent(motionEvent);
                    }
                });
            }
        });
    }

    public void setPassCallback(ISendPassCallback iSendPassCallback) {
        this.mPassCallback = iSendPassCallback;
    }

    public void setRelevantInfoListener(IRelevantInfoListener iRelevantInfoListener) {
        this.mOuterRelevantInfoListener = iRelevantInfoListener;
    }

    public void setAuthListener(AuthListener authListener) {
        this.mOuterAuthListener = authListener;
    }

    public String getSDKInfos(int n2) {
        if (n2 == 1) {
            return Session.getInstance().getUID();
        }
        if (n2 == 2) {
            return Session.getInstance().getHID();
        }
        return "";
    }

    public void setSystemApp(boolean bl) {
        Preference.getInstance().put("is_system_app", bl);
    }

    public List<LelinkServiceInfo> getBrowserList() {
        return this.mBrowserDispatcher.getBrowserList();
    }

    public void clearBrowserList() {
        this.mBrowserDispatcher.clearBrowserList();
        DeviceCodeResolver.getInstance().clear();
        BrowserHistory.getInstance().clearHistory();
        RelationReportTask.getInstance().clear();
    }

    public void release() {
        SourceLog.i(TAG, "release");
        this.deleteHeicFileDir();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        BrowserBridge.release();
        SonicProxy.release();
        this.unregisterReceiver();
        SourceDataReport.getInstance().logout();
        this.mBrowserDispatcher.clearBrowserList();
        if (this.mOnlineCheckThread != null) {
            this.mOnlineCheckThread.release();
        }
        RelationReportTask.unInit();
        SourceLog.flushLogWriter();
        SourceLog.disableLogWriter();
        e.d().c();
        CommonListenerWrapper.getInstance().release();
    }

    private void deleteHeicFileDir() {
        SourceLog.i(TAG, "deleteHeicFileDir");
        AsyncManager.getInstance().exeRunnable(new Runnable(){

            @Override
            public void run() {
                String string = LelinkServerInstance.getInstance().getHeicDirPath();
                if (TextUtils.isEmpty((CharSequence)string)) {
                    return;
                }
                FileUtil.deleteFile(string);
            }
        }, null);
    }

    public void notifyBrowserListIfNeeded(boolean bl) {
        if (bl) {
            this.notifyBrowseList();
        } else {
            this.mHandler.removeMessages(1);
            this.mHandler.sendEmptyMessageDelayed(1, 500L);
        }
    }

    public void notifyBrowseList() {
        this.mBrowserDispatcher.notifyBrowserSuccess();
        try {
            for (LelinkServiceInfo lelinkServiceInfo : this.getBrowserList()) {
                ConnectManager.getInstance().notifyBrowseResult(lelinkServiceInfo);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void clearPermissionIntentAndRetryMirror() {
        this.startMirror(this.mMirrorPlayInfo, false);
    }

    private LelinkServiceInfo findSameServiceInfo(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null || this.mBrowserDispatcher.getBrowserList() == null) {
            SourceLog.i(TAG, "findSameServiceInfo ignore" + lelinkServiceInfo + "\n" + this.mBrowserDispatcher.getBrowserList());
            return lelinkServiceInfo;
        }
        try {
            for (LelinkServiceInfo lelinkServiceInfo2 : this.mBrowserDispatcher.getBrowserList()) {
                SourceLog.i(TAG, "findSameServiceInfo " + lelinkServiceInfo + "\n" + lelinkServiceInfo2);
                if (!lelinkServiceInfo2.equals(lelinkServiceInfo)) continue;
                return lelinkServiceInfo2;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SourceLog.w(TAG, "not findSameServiceInfo, use outside info " + lelinkServiceInfo);
        return lelinkServiceInfo;
    }

    private boolean canReverseControl() {
        if (Feature.isLeboApp()) {
            return true;
        }
        SourceLog.i(TAG, "canReverseControl " + a.m());
        return a.m();
    }

    public Context getContext() {
        return this.mContext;
    }

    private static interface ConnectCallback {
        public void setInfos(OutParameter var1, LelinkPlayerInfo var2, LelinkServiceInfo var3);

        public void onConnect(int var1, boolean var2);
    }

    static class CheckConnectListener
    implements IConnectListener {
        private final ConnectCallback callback;
        private final boolean isGroup;

        public CheckConnectListener(ConnectCallback connectCallback, boolean bl) {
            this.callback = connectCallback;
            this.isGroup = bl;
        }

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            SourceLog.i(LelinkSdkManager.TAG, "CheckConnectListener  onConnect");
            this.callback.onConnect(n2, this.isGroup);
            ConnectManager.getInstance().setConnectCheckListener(null);
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            SourceLog.i(LelinkSdkManager.TAG, "onDisconnect");
        }
    }

    class DevicePreCheckCallback
    implements DevicePreChecker.OnDevicePreCheckResultCallback {
        private LelinkPlayerInfo lelinkPlayerInfo;

        public DevicePreCheckCallback(LelinkPlayerInfo lelinkPlayerInfo) {
            this.lelinkPlayerInfo = lelinkPlayerInfo;
        }

        @Override
        public void onResult(LelinkServiceInfo lelinkServiceInfo, int n2) {
            try {
                SourceLog.i(LelinkSdkManager.TAG, "DevicePreCheckCallback : " + n2);
                if (n2 == 0 || n2 == 2) {
                    ConnectManager.getInstance().disconnect(lelinkServiceInfo);
                }
                OutParameter outParameter = LelinkSdkManager.this.getOutParameter(lelinkServiceInfo, this.lelinkPlayerInfo, this.lelinkPlayerInfo.getUrl(), this.lelinkPlayerInfo.getType());
                if (n2 == 0) {
                    if (NetworkUtil.isWifiConnected(LelinkSdkManager.this.mContext)) {
                        PushFailedRetryManager.getInstance().connectFailedRetry(lelinkServiceInfo, new PushFailedRetryManager.ConnectRetryListener(){

                            @Override
                            public void onLelinkServiceInfoCallback(LelinkServiceInfo lelinkServiceInfo) {
                                LelinkSdkManager.this.mHandler.removeMessages(4);
                                DevicePreCheckCallback.this.lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
                                LelinkSdkManager.this.startPlay(DevicePreCheckCallback.this.lelinkPlayerInfo);
                                PushFailedRetryManager.getInstance().stopRetry();
                            }
                        });
                        LelinkSdkManager.this.mHandler.sendMessageDelayed(Message.obtain(null, (int)4, (Object)outParameter), 5000L);
                    } else {
                        LelinkSdkManager.this.mHandler.sendMessageDelayed(Message.obtain(null, (int)4, (Object)outParameter), 5000L);
                    }
                    return;
                }
                this.lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
                LelinkSdkManager.this.startPlay(this.lelinkPlayerInfo);
            }
            catch (Exception exception) {
                SourceLog.w(LelinkSdkManager.TAG, exception);
            }
        }
    }
}

