/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.hpplay.common.utils.NetworkUtil;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.browser.BrowserBridge;

public class NetworkReceiver
extends BroadcastReceiver {
    private static final String TAG = "NetworkReceiver";
    private boolean firstNetworkChange = true;
    private boolean isConnected;
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());

    public void onReceive(Context context, Intent intent) {
        if (AuthSDK.getInstance().getAuthCode() == 402 || AuthSDK.getInstance().getAuthCode() == -101) {
            return;
        }
        String string = intent.getAction();
        SourceLog.i(TAG, "onReceive: action := " + string);
        try {
            if ("android.net.wifi.STATE_CHANGE".equalsIgnoreCase(string)) {
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                String string2 = intent.getStringExtra("bssid");
                if (null == networkInfo) {
                    return;
                }
                boolean bl = networkInfo.isConnected();
                SourceLog.i(TAG, "wifi connect  " + bl);
                NetworkInfo.State state = networkInfo.getState();
                if (state == NetworkInfo.State.CONNECTED) {
                    if (bl) {
                        this.isConnected = true;
                        if (!Session.getInstance().isAuthSuccess && !Session.getInstance().isFirstBoot) {
                            AuthSDK.getInstance().authSDK();
                        }
                        if (this.firstNetworkChange) {
                            SourceLog.i(TAG, "firstNetworkChange in NetworkAndTimeChangeReceiver");
                            this.firstNetworkChange = false;
                            return;
                        }
                        LelinkSdkManager.getInstance().clearBrowserList();
                        this.mMainHandler.removeCallbacksAndMessages(null);
                        this.mMainHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (!Build.MANUFACTURER.toLowerCase().equals("huawei") || !Build.MANUFACTURER.toLowerCase().equals("honor")) {
                                    LelinkSdkManager.getInstance().startBrowseThread();
                                }
                                BusinessEntity.getInstance().onWifiConnected();
                            }
                        }, 500L);
                    }
                } else if (state == NetworkInfo.State.DISCONNECTED) {
                    SourceLog.i(TAG, "f++++++++++++++++++++++++++++++++++r");
                    if (this.isConnected && !bl) {
                        this.isConnected = false;
                        if (this.firstNetworkChange) {
                            SourceLog.i(TAG, "firstNetworkChange in NetworkAndTimeChangeReceiver");
                            this.firstNetworkChange = false;
                            return;
                        }
                        this.mMainHandler.removeCallbacksAndMessages(null);
                        LelinkSdkManager.getInstance().clearBrowserList();
                        BrowserBridge.getInstance().onNetDisconnect(4);
                    }
                }
            } else if ("android.net.conn.CONNECTIVITY_CHANGE".equalsIgnoreCase(string)) {
                NetworkUtil.NetworkType networkType = NetworkUtil.getNetworkType(context);
                SourceLog.i(TAG, "networkType:" + (Object)((Object)networkType));
                NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                if (networkInfo == null || networkInfo.getType() != 0) {
                    if (networkInfo != null && NetworkInfo.State.CONNECTED == networkInfo.getState() && networkInfo.isAvailable() && !Session.getInstance().isAuthSuccess) {
                        AuthSDK.getInstance().authSDK();
                    }
                    return;
                }
                if (NetworkInfo.State.CONNECTED == networkInfo.getState() && networkInfo.isAvailable()) {
                    if (!Session.getInstance().isAuthSuccess) {
                        AuthSDK.getInstance().authSDK();
                    }
                    if (this.firstNetworkChange) {
                        SourceLog.i(TAG, "firstNetworkChange in NetworkAndTimeChangeReceiver");
                        this.firstNetworkChange = false;
                        return;
                    }
                    SourceLog.i(TAG, "mobile is open");
                    this.reconnectIM();
                    LelinkSdkManager.getInstance().clearBrowserList();
                } else if (!NetworkUtil.NetworkType.NETWORK_WIFI.equals((Object)networkType)) {
                    if (this.firstNetworkChange) {
                        SourceLog.i(TAG, "firstNetworkChange in NetworkAndTimeChangeReceiver");
                        this.firstNetworkChange = false;
                        return;
                    }
                    SourceLog.i(TAG, "mobile is close");
                    LelinkSdkManager.getInstance().clearBrowserList();
                }
            } else if ("android.intent.action.SCREEN_ON".equals(string)) {
                this.reconnectIM();
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void reconnectIM() {
        PublicCastClient.getInstance().disconnectServer();
        PublicCastClient.getInstance().reconnect();
    }
}

