/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.player.listener.OnCompletionListener;
import com.hpplay.sdk.source.player.listener.OnErrorListener;
import com.hpplay.sdk.source.player.listener.OnInfoListener;
import com.hpplay.sdk.source.player.listener.OnLoadingListener;
import com.hpplay.sdk.source.player.listener.OnPreparedListener;
import com.hpplay.sdk.source.player.listener.OnStateChangeListener;
import com.hpplay.sdk.source.player.listener.OnStopListener;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.LelinkMirrorBridge;
import com.hpplay.sdk.source.protocol.LelinkPushBridge;
import java.nio.ByteBuffer;

public class LelinkBridge
extends AbsBridge {
    private static final String TAG = "LelinkBridge";
    private OutParameter mPlayInfo;
    private AbsBridge mLelinkBridge;

    public LelinkBridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
        this.mPlayInfo = outParameter;
        this.mLelinkBridge = this.mPlayInfo.castType == 1 ? new LelinkPushBridge(this.mContext, outParameter) : new LelinkMirrorBridge(this.mContext, outParameter);
    }

    @Override
    public void setDataSource(OutParameter outParameter) {
        super.setDataSource(outParameter);
        this.mLelinkBridge.setDataSource(outParameter);
    }

    @Override
    public void play(String string) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "play ignore");
            return;
        }
        SourceLog.i(TAG, "play");
        this.mLelinkBridge.play(string);
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "switchExpansionScreen ignore");
            return false;
        }
        SourceLog.i(TAG, "switchExpansionScreen");
        return this.mLelinkBridge.switchExpansionScreen(bl);
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        super.setSecondMirrorView(secondMirrorView);
        this.mLelinkBridge.setSecondMirrorView(secondMirrorView);
    }

    @Override
    public void resume(String string) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "resume ignore");
            return;
        }
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "resume ignore 2");
            return;
        }
        this.mLelinkBridge.resume(string);
    }

    @Override
    public void pause(String string) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "pause ignore");
            return;
        }
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "pause ignore 2");
            return;
        }
        this.mLelinkBridge.pause(string);
    }

    @Override
    public void seekTo(int n2) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "seekTo ignore");
            return;
        }
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "seekTo ignore 2");
            return;
        }
        this.mLelinkBridge.seekTo(n2);
    }

    @Override
    public void addVolume() {
        super.addVolume();
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "addVolume ignore");
            return;
        }
        this.mLelinkBridge.addVolume();
    }

    @Override
    public void subVolume() {
        super.subVolume();
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "subVolume ignore");
            return;
        }
        this.mLelinkBridge.subVolume();
    }

    @Override
    public void setVolume(int n2) {
        super.setVolume(n2);
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "setVolume ignore");
            return;
        }
        this.mLelinkBridge.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        super.selectAudiotrack(n2);
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "selectAudiotrack ignore");
            return;
        }
        this.mLelinkBridge.selectAudiotrack(n2);
    }

    @Override
    public void sendVideoData(ByteBuffer byteBuffer, int n2, int n3, int n4, long l2) {
        super.sendVideoData(byteBuffer, n2, n3, n4, l2);
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "sendVideoData ignore");
            return;
        }
        this.mLelinkBridge.sendVideoData(byteBuffer, n2, n3, n4, l2);
    }

    @Override
    public void sendAudioData(byte[] byArray, int n2, int n3) {
        super.sendAudioData(byArray, n2, n3);
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "sendAudioData ignore");
            return;
        }
        this.mLelinkBridge.sendAudioData(byArray, n2, n3);
    }

    @Override
    public void setExternalMirrorData() {
        super.setExternalMirrorData();
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "setExternalMirrorData ignore");
            return;
        }
        this.mLelinkBridge.setExternalMirrorData();
    }

    @Override
    public void stop(String string) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "stop ignore");
            return;
        }
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "stop ignore 2");
            return;
        }
        SourceLog.w(TAG, "Lelinkbrideg stop ");
        this.mLelinkBridge.stop(string);
    }

    @Override
    public void playDrama(String string, String string2) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "playDrama ignore");
            return;
        }
        this.mLelinkBridge.playDrama(string, string2);
    }

    @Override
    public void playNextDrama(String string) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "playNextDrama ignore");
            return;
        }
        this.mLelinkBridge.playNextDrama(string);
    }

    @Override
    public void playPreDrama(String string) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "playPreDrama ignore");
            return;
        }
        this.mLelinkBridge.playPreDrama(string);
    }

    @Override
    public void appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "appendPlayList ignore");
            return;
        }
        this.mLelinkBridge.appendPlayList(string, dramaInfoBeanArray, n2, n3, n4);
    }

    @Override
    public void clearPlayList(String string) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "clearPlayList ignore");
            return;
        }
        this.mLelinkBridge.clearPlayList(string);
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "setWatermarkInfo ignore");
            return;
        }
        this.mLelinkBridge.setWatermarkVisible(bl);
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "setMirrorScreenSecret ignore");
            return;
        }
        this.mLelinkBridge.setMirrorScreenSecret(bl);
    }

    @Override
    public void onAppResume() {
        super.onAppResume();
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "onAppResume ignore 2");
            return;
        }
        this.mLelinkBridge.onAppResume();
    }

    @Override
    public void onAppPause() {
        super.onAppPause();
        if (this.mLelinkBridge == null) {
            SourceLog.w(TAG, "onAppPause ignore 2");
            return;
        }
        this.mLelinkBridge.onAppPause();
    }

    @Override
    public void setOnLoadingListener(OnLoadingListener onLoadingListener) {
        super.setOnLoadingListener(onLoadingListener);
        this.mLelinkBridge.setOnLoadingListener(onLoadingListener);
    }

    @Override
    public void setOnPreparedListener(OnPreparedListener onPreparedListener) {
        super.setOnPreparedListener(onPreparedListener);
        this.mLelinkBridge.setOnPreparedListener(onPreparedListener);
    }

    @Override
    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        super.setOnStateChangeListener(onStateChangeListener);
        this.mLelinkBridge.setOnStateChangeListener(onStateChangeListener);
    }

    @Override
    public void setOnInfoListener(OnInfoListener onInfoListener) {
        super.setOnInfoListener(onInfoListener);
        this.mLelinkBridge.setOnInfoListener(onInfoListener);
    }

    @Override
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        super.setOnErrorListener(onErrorListener);
        this.mLelinkBridge.setOnErrorListener(onErrorListener);
    }

    @Override
    public void setOnCompletionListener(OnCompletionListener onCompletionListener) {
        super.setOnCompletionListener(onCompletionListener);
        this.mLelinkBridge.setOnCompletionListener(onCompletionListener);
    }

    @Override
    public void setOnStopListener(OnStopListener onStopListener) {
        super.setOnStopListener(onStopListener);
        this.mLelinkBridge.setOnStopListener(onStopListener);
    }

    @Override
    public void screenshot(int n2) {
        super.screenshot(n2);
        this.mLelinkBridge.screenshot(n2);
    }

    @Override
    public void onCaptureStart(int n2) {
        super.onCaptureStart(n2);
        this.mLelinkBridge.onCaptureStart(n2);
    }

    @Override
    public void onCaptureStop(int n2) {
        super.onCaptureStop(n2);
        this.mLelinkBridge.onCaptureStop(n2);
    }

    @Override
    public void onInfo(int n2, String string) {
        super.onInfo(n2, string);
        this.mLelinkBridge.onInfo(n2, string);
    }

    @Override
    public void frozen(boolean bl) {
        super.frozen(bl);
        this.mLelinkBridge.frozen(bl);
    }

    @Override
    public void release() {
        this.mLelinkBridge.release();
    }
}

