/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Build;
import android.text.TextUtils;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkReceiver;
import com.hpplay.sdk.source.utils.Feature;

public class MirrorNotification {
    private static final String TAG = "MirrorNotification";
    public static final String ZTE_CHANNEL_ID = "smart_cast_channel";
    public static final String ZTE_ACTION_CASTING_SERVICE_CLICK_FILTER = "casting.service.notification.click.filter";
    public static final int ZTE_NOTIFICATION_ID = 110;
    private static final int PENDING_INTENT_FLAG_MUTABLE = 0x2000000;

    public NotificationChannel createNotificationChannel(Context context) {
        if (Feature.isZTEChannel()) {
            return MirrorNotification.createZTENotificationChannel(context);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            String string = "\u4e50\u64ad\u622a\u5c4f";
            NotificationChannel notificationChannel = new NotificationChannel("DlnaService", (CharSequence)string, 3);
            notificationChannel.enableLights(false);
            notificationChannel.enableVibration(false);
            notificationChannel.setSound(null, null);
            notificationChannel.setShowBadge(false);
            return notificationChannel;
        }
        return null;
    }

    public Notification createNotification(Context context, String string, int n2) {
        if (Feature.isZTEChannel()) {
            return MirrorNotification.createZTENotification(context, string);
        }
        String string2 = "\u5df2\u8fde\u63a5\u5230 ";
        String string3 = "\u505c\u6b62\u955c\u50cf";
        SourceLog.i(TAG, "createNotification");
        if (Build.VERSION.SDK_INT >= 26) {
            Notification.Builder builder;
            block11: {
                String string4 = string2 + (TextUtils.isEmpty((CharSequence)string) ? "\u63a5\u6536\u7aef" : string);
                builder = new Notification.Builder(context);
                builder.setAutoCancel(false);
                builder.setShowWhen(false);
                Icon icon = null;
                Bitmap bitmap = MirrorNotification.getIcon(context);
                if (bitmap != null) {
                    icon = Icon.createWithBitmap((Bitmap)bitmap);
                }
                if (icon != null) {
                    builder.setSmallIcon(icon);
                } else {
                    builder.setSmallIcon(17301651);
                }
                builder.setContentTitle((CharSequence)string4);
                builder.setChannelId("DlnaService");
                try {
                    if (n2 == 2) break block11;
                    Intent intent = new Intent(context, LelinkReceiver.class);
                    intent.setAction("com.hpplay.source.service.close");
                    intent.setPackage(context.getPackageName());
                    intent.setClass(context, LelinkReceiver.class);
                    int n3 = 0x10000000;
                    if (Build.VERSION.SDK_INT >= 31) {
                        n3 = 0x2000000;
                    }
                    PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)n3);
                    String string5 = null;
                    try {
                        string5 = context.getResources().getString(context.getResources().getIdentifier("dlna_disconnect", "string", context.getPackageName()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!TextUtils.isEmpty(string5)) {
                        string3 = string5;
                    }
                    builder.addAction(new Notification.Action.Builder(null, (CharSequence)string3, pendingIntent).build());
                    builder.setContentIntent(pendingIntent);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            return builder.build();
        }
        return null;
    }

    public static synchronized Bitmap getIcon(Context context) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = context.getApplicationContext().getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 0);
            Drawable drawable2 = packageManager.getApplicationIcon(applicationInfo);
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static NotificationChannel createZTENotificationChannel(Context context) {
        String string = HapplayUtils.getAppName(context);
        String string2 = ZTE_CHANNEL_ID;
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel = new NotificationChannel(string2, (CharSequence)string, 1);
            notificationChannel.enableLights(false);
            notificationChannel.enableVibration(false);
            notificationChannel.setSound(null, null);
            notificationChannel.setShowBadge(false);
            return notificationChannel;
        }
        return null;
    }

    private static Notification createZTENotification(Context context, String string) {
        if (Build.VERSION.SDK_INT >= 26) {
            Notification.Builder builder = new Notification.Builder(context);
            Icon icon = null;
            Bitmap bitmap = MirrorNotification.getIcon(context);
            if (bitmap != null) {
                icon = Icon.createWithBitmap((Bitmap)bitmap);
            }
            if (icon != null) {
                builder.setSmallIcon(icon);
            } else {
                builder.setSmallIcon(17301651);
            }
            try {
                int n2 = 0x10000000;
                if (Build.VERSION.SDK_INT >= 31) {
                    n2 = 0x2000000;
                }
                Intent intent = new Intent(ZTE_ACTION_CASTING_SERVICE_CLICK_FILTER);
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)1, (Intent)intent, (int)n2);
                builder.setContentIntent(pendingIntent);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            builder.setAutoCancel(false);
            builder.setContentTitle((CharSequence)string);
            builder.setChannelId(ZTE_CHANNEL_ID);
            builder.setAutoCancel(false);
            builder.setOngoing(true);
            return builder.build();
        }
        return null;
    }
}

