/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.browser.ble;

import android.content.Context;
import android.text.TextUtils;
import com.hpplay.ble.AdvertiseManager;
import com.hpplay.ble.DiscoveryAdvertiseManager;
import com.hpplay.ble.DiscoveryResult;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.device.Device;
import com.hpplay.sdk.source.device.DevicePinParser;
import com.hpplay.sdk.source.device.ServiceUpdater;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.connect.AbsIMMsgReceiveListener;

public class BleBrowserBridge {
    private static final String TAG = "BleBrowserBridge";
    private static BleBrowserBridge sInstance;
    private IServiceInfoParseListener mServiceInfoParseListener;
    private boolean isStop = true;
    private boolean isBrowserSuccess = false;
    private DiscoveryAdvertiseManager.BleDiscoveryCallback mCallback = new DiscoveryAdvertiseManager.BleDiscoveryCallback(){

        public void onDiscoveryResult(DiscoveryResult discoveryResult) {
            if (BleBrowserBridge.this.isStop || discoveryResult == null) {
                return;
            }
            String string = discoveryResult.getPinCode();
            if (TextUtils.isEmpty((CharSequence)string)) {
                SourceLog.w(BleBrowserBridge.TAG, "discoveryResult: ble is empty");
                return;
            }
            if (string.equals(Preference.getInstance().get("key_device_id"))) {
                return;
            }
            Device.addDeviceCodeServiceInfo(string, 10, BleBrowserBridge.this.mServiceInfoParseListener);
        }
    };
    private AbsIMMsgReceiveListener mIMMsgReceiveListener = new AbsIMMsgReceiveListener(){

        @Override
        public void onMsgReceive(int n2, String string) {
            super.onMsgReceive(n2, string);
            switch (n2) {
                case 1: {
                    BleBrowserBridge.this.mServerParser.setParseResultListener(BleBrowserBridge.this.mServiceInfoParseListener);
                    BleBrowserBridge.this.mServerParser.parseServiceInfo(string, 10);
                }
            }
        }
    };
    private DevicePinParser mServerParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized BleBrowserBridge getInstance() {
        Class<BleBrowserBridge> clazz = BleBrowserBridge.class;
        synchronized (BleBrowserBridge.class) {
            if (sInstance == null) {
                sInstance = new BleBrowserBridge();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private BleBrowserBridge() {
    }

    public void setServiceInfoParseListener(IServiceInfoParseListener iServiceInfoParseListener) {
        this.mServiceInfoParseListener = iServiceInfoParseListener;
    }

    public boolean startBrowse(Context context) {
        if (1 != a.f(context)) {
            SourceLog.w(TAG, "startBrowse has no permission to use ble");
            return false;
        }
        this.isBrowserSuccess = DiscoveryAdvertiseManager.getInstance().startScan(context, this.mCallback);
        SourceLog.w(TAG, "startBrowse " + this.isBrowserSuccess);
        this.isStop = !this.isBrowserSuccess;
        ServiceUpdater.getInstance().updateServiceInfo(context);
        return this.isBrowserSuccess;
    }

    public void stopBrowse(Context context) {
        if (this.isStop) {
            return;
        }
        SourceLog.i(TAG, "stopBrowse");
        this.isStop = true;
        this.isBrowserSuccess = false;
        DiscoveryAdvertiseManager.getInstance().stopScan();
        ServiceUpdater.getInstance().updateServiceInfo(context);
    }

    public boolean isBrowserSuccess() {
        return this.isBrowserSuccess;
    }

    public void stopPublish(Context context) {
        SourceLog.i(TAG, "stopPublish");
        AdvertiseManager.getInstance().stopAdvertise();
        ServiceUpdater.getInstance().updateServiceInfo(context);
    }

    protected boolean startPublish(Context context, String string) {
        if (1 != a.e(context)) {
            SourceLog.w(TAG, "startPublish has no permission to use ble");
            return false;
        }
        SourceLog.i(TAG, "startPublish deviceCode:" + string);
        PublicCastClient.getInstance().setIMMsgReceiveListener(this.mIMMsgReceiveListener);
        return AdvertiseManager.getInstance().startAdvertise(context, string);
    }

    public void release() {
    }
}

