/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.text.TextUtils;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;
import java.util.Map;

public class CastUtil {
    private static final String TAG = "CastUtil";
    private static final String KEY_HW_PCMODE = "ro.config.hw_emui_wfd_pc_mode";
    private static final boolean DEFAULT_ENABLE_MULTI_CHANNEL = false;
    public static final String PLAT_TYPE_IOS = "ios";
    public static final String PLAT_TYPE_MAC = "Mac Os";
    public static final String PLAT_TYPE_PC = "pc";
    public static final String PLAT_TYPE_H5 = "h5";
    public static final String PLAT_TYPE_ANDROID = "android";
    public static final String PLAT_TYPE_LINUX = "linux";
    public static final String PLAT_TYPE_PHONE = "phone";

    public static boolean isSinkSupportMirror(LelinkServiceInfo lelinkServiceInfo) {
        return CastUtil.isSupportLelink(lelinkServiceInfo) || CastUtil.isSupportIM(lelinkServiceInfo);
    }

    public static boolean isSupportLelink(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return false;
        }
        try {
            BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
            return browserInfo != null;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static boolean isSupportLelinkV2(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return false;
        }
        try {
            BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
            return CastUtil.isSupportLelinkV2(browserInfo);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static boolean isSupportLelinkV2(BrowserInfo browserInfo) {
        if (browserInfo == null) {
            return false;
        }
        String string = browserInfo.getExtras().get("vv");
        return "2".equals(string);
    }

    public static boolean isSupportIM(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return false;
        }
        try {
            BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(4);
            return browserInfo != null;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static BrowserInfo getBrowserInfo(LelinkServiceInfo lelinkServiceInfo, int n2) {
        try {
            if (lelinkServiceInfo.getBrowserInfos() == null) {
                return null;
            }
            return lelinkServiceInfo.getBrowserInfos().get(n2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static boolean isUseLocalCast(LelinkServiceInfo lelinkServiceInfo) {
        BrowserInfo browserInfo = CastUtil.getPrePushInfo(lelinkServiceInfo);
        if (browserInfo == null) {
            return false;
        }
        return browserInfo.getType() != 4;
    }

    public static BrowserInfo getPreMirrorInfo(LelinkServiceInfo lelinkServiceInfo) {
        return CastUtil.getPreBrowserInfo(lelinkServiceInfo, 2);
    }

    public static BrowserInfo getPrePushInfo(LelinkServiceInfo lelinkServiceInfo) {
        return CastUtil.getPreBrowserInfo(lelinkServiceInfo, 1);
    }

    public static BrowserInfo getPrePushInfoByProtocol(LelinkServiceInfo lelinkServiceInfo, int n2) {
        try {
            BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(n2);
            if (browserInfo != null) {
                return browserInfo;
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return CastUtil.getPreBrowserInfo(lelinkServiceInfo, 1);
    }

    public static BrowserInfo getPreConnectInfo(LelinkServiceInfo lelinkServiceInfo) {
        return CastUtil.getPreBrowserInfo(lelinkServiceInfo, 1);
    }

    public static BrowserInfo getPreBrowserInfo(LelinkServiceInfo lelinkServiceInfo, int n2) {
        try {
            if (n2 == 2) {
                BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
                if (browserInfo != null) {
                    return browserInfo;
                }
                if (!a.d()) {
                    return null;
                }
                BrowserInfo browserInfo2 = lelinkServiceInfo.getBrowserInfos().get(4);
                if (browserInfo2 != null) {
                    return browserInfo2;
                }
            } else if (n2 == 1) {
                BrowserInfo browserInfo = lelinkServiceInfo.getBrowserInfos().get(1);
                if (browserInfo != null) {
                    return browserInfo;
                }
                BrowserInfo browserInfo3 = lelinkServiceInfo.getBrowserInfos().get(3);
                if (browserInfo3 != null) {
                    return browserInfo3;
                }
                BrowserInfo browserInfo4 = lelinkServiceInfo.getBrowserInfos().get(4);
                if (browserInfo4 != null) {
                    return browserInfo4;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return null;
    }

    public static boolean isSupportMultiChannel(LelinkServiceInfo lelinkServiceInfo) {
        if (!a.d()) {
            SourceLog.w(TAG, "isSupportMultiChannel false, not support cloud mirror");
            return false;
        }
        if (!Feature.isLeboApp()) {
            SourceLog.w(TAG, "isSupportMultiChannel false, not lebo app");
            return false;
        }
        if (!CastUtil.isSupportIM(lelinkServiceInfo)) {
            SourceLog.w(TAG, "isSupportMultiChannel false, has no im");
            return false;
        }
        if (!CastUtil.isSupportMultiChannel(lelinkServiceInfo, 4) && !CastUtil.isSupportMultiChannel(lelinkServiceInfo, 1)) {
            SourceLog.w(TAG, "isSupportMultiChannel false, old sink");
            return false;
        }
        boolean bl = false;
        String string = Preference.getInstance().get("key_multi_channel");
        SourceLog.w(TAG, "isSupportMultiChannel " + string);
        if (!TextUtils.isEmpty((CharSequence)string) && TextUtils.isDigitsOnly((CharSequence)string)) {
            bl = Integer.parseInt(string) == 1;
        }
        return bl;
    }

    private static boolean isSupportMultiChannel(LelinkServiceInfo lelinkServiceInfo, int n2) {
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, n2);
        if (browserInfo == null) {
            return false;
        }
        try {
            if (!browserInfo.getExtras().containsKey("tunnels")) {
                SourceLog.w(TAG, "isSupportMultiChannel false, old sink");
                return false;
            }
            String string = browserInfo.getExtras().get("tunnels");
            if ("3".equals(string)) {
                return true;
            }
            SourceLog.w(TAG, "isSupportMultiChannel false, sink not support:" + string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return false;
    }

    public static void setLelinkPlat(LelinkServiceInfo lelinkServiceInfo, int n2) {
        try {
            if (lelinkServiceInfo == null) {
                return;
            }
            BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 1);
            if (browserInfo == null) {
                return;
            }
            String string = PLAT_TYPE_ANDROID;
            switch (n2) {
                case 101: {
                    string = PLAT_TYPE_IOS;
                    break;
                }
                case 102: {
                    string = PLAT_TYPE_MAC;
                    break;
                }
                case 103: {
                    string = PLAT_TYPE_PC;
                    break;
                }
                case 104: {
                    string = PLAT_TYPE_H5;
                    break;
                }
                case 106: {
                    string = PLAT_TYPE_LINUX;
                    break;
                }
                case 107: {
                    string = PLAT_TYPE_PHONE;
                }
            }
            Map<String, String> map = browserInfo.getExtras();
            if (map != null) {
                map.put("pt", string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public static boolean isFullScreen(int n2, BrowserInfo browserInfo) {
        if (n2 == 1) {
            return true;
        }
        if (n2 == 2) {
            return false;
        }
        return Feature.isMUIChannel();
    }

    public static String getSinkName(LelinkServiceInfo lelinkServiceInfo) {
        if (lelinkServiceInfo == null) {
            return null;
        }
        return lelinkServiceInfo.getName();
    }

    public static String getKey(LelinkServiceInfo lelinkServiceInfo) {
        if (!TextUtils.isEmpty((CharSequence)lelinkServiceInfo.getUid())) {
            return lelinkServiceInfo.getUid();
        }
        return lelinkServiceInfo.getIp() + lelinkServiceInfo.getName();
    }

    public static void printSDKInfo() {
        SourceLog.i(TAG, "SDK info: 4.07.19/2022-05-05-14-28/lecast/1/ cu:" + Session.getInstance().getUID() + "/ hid:" + Session.getInstance().getHID());
    }

    public static String getVersion() {
        return String.valueOf(40719);
    }
}

