/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.text.TextUtils;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class KeepAliveUtitls {
    private static final String TAG = "KeepAliveUtitls";
    private static final long CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tcpCheckTvState(String string, String string2, int n2, int n3) {
        boolean bl = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            socket.setSoTimeout(n3);
            String string3 = KeepAliveUtitls.findValidLocalIP(string2);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                socket.bind(new InetSocketAddress(string3, 0));
            }
            socket.connect(new InetSocketAddress(string2, n2), n3);
            bl = true;
        }
        catch (Exception exception) {
            SourceLog.i(TAG, string + " +++++++++++ is offline ++++++++++++++" + string2);
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    SourceLog.w(TAG, iOException);
                }
            }
        }
        return bl;
    }

    public static boolean tcpCheckTvState(String string, String string2, int n2) {
        return KeepAliveUtitls.tcpCheckTvState(string, string2, n2, (int)CONNECT_TIMEOUT);
    }

    private static String findValidLocalIP(String string) {
        try {
            String string2 = string.substring(0, string.lastIndexOf("."));
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration == null) {
                return null;
            }
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    String string3;
                    String string4;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || TextUtils.isEmpty((CharSequence)(string4 = inetAddress.getHostAddress())) || !TextUtils.equals((CharSequence)string2, (CharSequence)(string3 = string4.substring(0, string4.lastIndexOf("."))))) continue;
                    return string4;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return null;
    }

    public static String getSinkServerInfo(SinkParameterBean sinkParameterBean) {
        if (sinkParameterBean == null) {
            SourceLog.w(TAG, "getSinkServerInfo,value is invalid");
            return null;
        }
        HTTPInfoBean hTTPInfoBean = new HTTPInfoBean();
        hTTPInfoBean.appID = sinkParameterBean.appID;
        hTTPInfoBean.uid = sinkParameterBean.uid;
        hTTPInfoBean.dsn = sinkParameterBean.dsn;
        ArrayList<HTTPInfoBean> arrayList = new ArrayList<HTTPInfoBean>();
        arrayList.add(hTTPInfoBean);
        if (sinkParameterBean.createType == SinkParameterBean.CREATE_BY_SINK_DSN) {
            return KeepAliveUtitls.httpPostCheckDeviceStateByDsn(arrayList);
        }
        return KeepAliveUtitls.httpPostCheckTvStateByUID(arrayList);
    }

    public static String httpPostCheckTvState(List<BrowserInfo> list) {
        if (null == list || list.isEmpty()) {
            SourceLog.i(TAG, "httpPostCheckTvState is empty");
            return null;
        }
        ArrayList<HTTPInfoBean> arrayList = new ArrayList<HTTPInfoBean>();
        for (BrowserInfo object2 : list) {
            HTTPInfoBean hTTPInfoBean = new HTTPInfoBean();
            hTTPInfoBean.uid = object2.getUid();
            try {
                hTTPInfoBean.appID = object2.getExtras().get("a");
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            arrayList.add(hTTPInfoBean);
        }
        String string = KeepAliveUtitls.httpPostCheckTvStateByUID(arrayList);
        if (TextUtils.isEmpty((CharSequence)string)) {
            for (BrowserInfo browserInfo : list) {
                browserInfo.setOnLine(false);
            }
            return null;
        }
        try {
            if (string.contains("200")) {
                JSONObject jSONObject = new JSONObject(string);
                JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                JSONObject jSONObject3 = jSONObject.optJSONObject("capblity");
                JSONArray jSONArray = jSONObject2.optJSONArray("tvList");
                if (jSONArray != null && jSONArray.length() > 0) {
                    String string2;
                    String string3;
                    String string4;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    int n2 = jSONArray.length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        JSONObject jSONObject4 = jSONArray.optJSONObject(i2);
                        string4 = jSONObject4.optString("ra");
                        string3 = jSONObject4.optString("u");
                        Object object = jSONObject4.optString("pol");
                        boolean bl = jSONObject4.optBoolean("online");
                        string2 = jSONObject4.optString("pt");
                        if (TextUtils.isEmpty((CharSequence)object)) {
                            object = "0";
                        }
                        if (TextUtils.isEmpty((CharSequence)string2)) {
                            string2 = "uk";
                        }
                        hashMap.put(string3, String.valueOf(bl) + "@" + (String)object + "@" + string2);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("doCheck httpCheck:").append("\r\n");
                    Boolean bl = null;
                    string4 = "0";
                    string3 = "uk";
                    for (BrowserInfo browserInfo : list) {
                        string2 = (String)hashMap.get(browserInfo.getUid());
                        if (!TextUtils.isEmpty((CharSequence)string2)) {
                            String[] stringArray = string2.split("@");
                            bl = Boolean.valueOf(stringArray[0]);
                            string4 = stringArray[1];
                            string3 = stringArray[2];
                        }
                        if (bl == null) {
                            bl = false;
                        }
                        browserInfo.setLocalWifi(false);
                        browserInfo.setOnLine(bl);
                        if (browserInfo.getExtras() != null) {
                            browserInfo.getExtras().put("pol", string4);
                            browserInfo.getExtras().put("pt", string3);
                        }
                        stringBuilder.append("name:").append(browserInfo.getName()).append(" alive state:").append(browserInfo.isOnLine()).append("\r\n");
                    }
                    return stringBuilder.toString();
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostCheckDeviceStateByDsn(List<HTTPInfoBean> list) {
        if (list == null || list.isEmpty()) {
            SourceLog.w(TAG, "httpPostCheckDeviceStateByDsn,value is invalid");
            return null;
        }
        SourceLog.i(TAG, "httpPostCheckDeviceStateByDsn");
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("uid", (Object)Session.getInstance().getUID());
            jSONObject.put("appid", (Object)Session.getInstance().appKey);
            jSONObject.put("token", (Object)a.a());
            jSONObject.put("ver", (Object)"1.0");
            JSONArray jSONArray = new JSONArray();
            for (HTTPInfoBean object : list) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("ra", (Object)object.appID);
                jSONObject2.put("dsn", (Object)object.dsn);
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("tvList", (Object)jSONArray.toString());
            SourceLog.i(TAG, "httpPostCheckTvState parameter:" + CloudAPI.sGetDeviceStatusByDsn);
            SourceLog.i(TAG, "httpPostCheckTvState parameter:" + jSONObject.toString());
            URL uRL = new URL(CloudAPI.sGetDeviceStatusByDsn);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout((int)CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout((int)CONNECT_TIMEOUT);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "text/html");
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
            httpURLConnection.setRequestProperty("contentType", "utf-8");
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(jSONObject.toString().getBytes());
            outputStream.flush();
            if (200 == httpURLConnection.getResponseCode()) {
                String string2;
                inputStream = httpURLConnection.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append("\r\n");
                }
                string = stringBuffer.toString();
                SourceLog.i(TAG, "httpPostCheckTvState result:" + string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != httpURLConnection) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPostCheckTvStateByUID(List<HTTPInfoBean> list) {
        if (list == null || list.isEmpty()) {
            SourceLog.w(TAG, "httpPostCheckTvStateByUID,value is invalid");
            return null;
        }
        SourceLog.i(TAG, "httpPostCheckTvStateByUID");
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("uid", (Object)Session.getInstance().getUID());
            jSONObject.put("appid", (Object)Session.getInstance().appKey);
            jSONObject.put("token", (Object)a.a());
            jSONObject.put("ver", (Object)"2.1");
            JSONArray jSONArray = new JSONArray();
            for (HTTPInfoBean object : list) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("u", (Object)object.uid);
                jSONObject2.put("ra", (Object)object.appID);
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("tvList", (Object)jSONArray.toString());
            SourceLog.i(TAG, "httpPostCheckTvState parameter:" + CloudAPI.sGetTVListStatus);
            SourceLog.i(TAG, "httpPostCheckTvState parameter:" + jSONObject.toString());
            URL uRL = new URL(CloudAPI.sGetTVListStatus);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setConnectTimeout((int)CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout((int)CONNECT_TIMEOUT);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-type", "text/html");
            httpURLConnection.setRequestProperty("Accept-Charset", "utf-8");
            httpURLConnection.setRequestProperty("contentType", "utf-8");
            httpURLConnection.connect();
            outputStream = httpURLConnection.getOutputStream();
            outputStream.write(jSONObject.toString().getBytes());
            outputStream.flush();
            if (200 == httpURLConnection.getResponseCode()) {
                String string2;
                inputStream = httpURLConnection.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                StringBuffer stringBuffer = new StringBuffer();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                    stringBuffer.append("\r\n");
                }
                string = stringBuffer.toString();
                SourceLog.i(TAG, "httpPostCheckTvState result:" + string);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
            if (null != httpURLConnection) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
        }
        return string;
    }

    public static class HTTPInfoBean {
        public String appID;
        public String uid;
        public String dsn;
    }
}

